/*
 * Decompiled with CFR 0.152.
 */
package skyview.process.imagefinder;

import skyview.geometry.Transformer;
import skyview.process.ImageFinder;
import skyview.survey.Image;

public class Overlap
extends ImageFinder {
    @Override
    public int[] findImages(Image[] input, Image output) {
        if (input == null || input.length == 0) {
            return null;
        }
        int imgCnt = 0;
        double ow = output.getWidth();
        double oh = output.getHeight();
        Transformer fromOut = null;
        double[][] coords = new double[4][3];
        double[] corners = new double[2];
        try {
            fromOut = output.getTransformer().inverse();
            corners[0] = 0.0;
            corners[1] = 0.0;
            fromOut.transform(corners, coords[0]);
            corners[0] = ow;
            corners[1] = 0.0;
            fromOut.transform(corners, coords[1]);
            corners[0] = ow;
            corners[1] = oh;
            fromOut.transform(corners, coords[2]);
            corners[0] = 0.0;
            corners[1] = oh;
            fromOut.transform(corners, coords[3]);
        }
        catch (Exception e) {
            throw new Error("In findImages: Unexpected transformation error for output image:" + e);
        }
        for (int i = 0; i < input.length; ++i) {
            if (this.overlap(coords, input[i])) {
                ++imgCnt;
                continue;
            }
            input[i] = null;
        }
        System.err.println("  Overlap Finder: Number of candidates to process: " + imgCnt);
        if (imgCnt > 0) {
            return new int[0];
        }
        return null;
    }

    private boolean overlap(double[][] corners, Image test) {
        int lower = 0;
        int higher = 0;
        int left = 0;
        int right = 0;
        double[] pos = new double[2];
        for (int i = 0; i < corners.length; ++i) {
            try {
                test.getTransformer().transform(corners[i], pos);
                if (pos[1] < 0.0) {
                    ++lower;
                } else if (pos[1] > (double)test.getHeight()) {
                    ++higher;
                }
                if (pos[0] < 0.0) {
                    ++left;
                    continue;
                }
                if (!(pos[0] > (double)test.getWidth())) continue;
                ++right;
                continue;
            }
            catch (Exception e) {
                System.err.println("Error return: false");
                return false;
            }
        }
        return lower != 4 && higher != 4 && left != 4 && right != 4;
    }
}

