/*
 * Decompiled with CFR 0.152.
 */
package skyview.process;

import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.process.Mosaicker;
import skyview.survey.Image;

public class IDMosaic
extends Mosaicker {
    private String[] usedImageNames;
    private int[] counts;
    private int nocoverage;
    private int nonphysical;

    @Override
    public String getName() {
        return "IDMosaic";
    }

    @Override
    public String getDescription() {
        return "Say which tile each pixel would be sampled from.";
    }

    @Override
    public void process(Image[] input, Image output, int[] osource, Sampler samp, DepthSampler dSampler) {
        int[] source = (int[])osource.clone();
        int width = output.getWidth();
        int height = output.getHeight();
        int depth = output.getDepth();
        this.counts = new int[input.length];
        this.usedImageNames = new String[input.length];
        boolean newData = false;
        double[] out = new double[2];
        double[] in = new double[2];
        boolean morePixels = true;
        samp.setOutput(output);
        while (morePixels) {
            morePixels = false;
            Object data = null;
            int currImg = -4;
            for (int pix = 0; pix < source.length; ++pix) {
                int img = source[pix];
                if (img == -4) continue;
                if (currImg == -4) {
                    currImg = img;
                }
                if (img != currImg) {
                    morePixels = true;
                    continue;
                }
                if (img >= 0) {
                    if (this.counts[img] == 0) {
                        this.usedImageNames[img] = input[img].getName();
                    }
                    int n = img;
                    this.counts[n] = this.counts[n] + 1;
                } else if (img == -2) {
                    ++this.nocoverage;
                } else if (img == -3) {
                    ++this.nonphysical;
                }
                currImg = img;
                for (int k = 0; k < depth; ++k) {
                    output.setData(pix + k * width * height, currImg);
                }
                source[pix] = -4;
            }
            currImg = -4;
        }
    }

    @Override
    public void updateHeader(Header h) {
        try {
            h.insertHistory("");
            h.insertHistory("Image mosaicking using skyview.process.IDMosaic");
            h.insertHistory("");
            h.insertHistory("************************************");
            h.insertHistory("** Images used                    **");
            h.insertHistory("************************************");
            h.insertHistory("");
            for (int i = 0; i < this.counts.length; ++i) {
                String res = i + " (" + this.counts[i] + "): ";
                if (this.counts[i] <= 0) continue;
                String name = this.usedImageNames[i];
                int len = res.length();
                int used = len + 8;
                if (used + name.length() > 80) {
                    name = "..." + name.substring(used + name.length() - 77);
                }
                h.insertHistory(res + name);
            }
            h.insertHistory("");
            if (this.nocoverage > 0) {
                h.insertHistory("Uncovered pixels:" + this.nocoverage);
            }
            if (this.nonphysical > 0) {
                h.insertHistory("Pixels off projection:" + this.nonphysical);
            }
            h.insertHistory("");
        }
        catch (FitsException e) {
            System.err.println("Error updating FITS header:\n   " + e);
        }
    }
}

