/*
 * Decompiled with CFR 0.152.
 */
package skyview.executive;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import nom.tam.fits.Fits;
import nom.tam.fits.Header;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataOutputStream;
import skyview.executive.Samp;
import skyview.executive.Settings;
import skyview.executive.SettingsUpdater;
import skyview.geometry.Converter;
import skyview.geometry.CoordinateSystem;
import skyview.geometry.DepthSampler;
import skyview.geometry.Position;
import skyview.geometry.Projection;
import skyview.geometry.Sampler;
import skyview.geometry.Scaler;
import skyview.geometry.Util;
import skyview.geometry.WCS;
import skyview.process.ImageFinder;
import skyview.process.Processor;
import skyview.request.SourceCoordinates;
import skyview.survey.Image;
import skyview.survey.Survey;
import skyview.survey.SurveyFinder;
import skyview.survey.UserSurvey;
import skyview.util.Utilities;

public class Imager {
    static Pattern comma = Pattern.compile(",");
    static Pattern equal = Pattern.compile("=");
    private int[] match = null;
    private String lastSurvey = null;
    private static HashMap<String, SoftReference<ImageState>> doneImages = new HashMap();
    private double[] edgeAdjustments;
    int nx;
    int ny;
    int nz = 1;
    protected double bin0;
    protected double dBin;
    protected Scaler s;
    protected Projection p;
    protected CoordinateSystem c;
    protected Sampler samp;
    protected DepthSampler dsamp;
    protected double lon = Double.NaN;
    protected double lat = Double.NaN;
    protected Survey surv;
    protected Image[] cand;
    protected Image output;
    private static Imager lastImager;
    private static SurveyFinder finder;
    private ArrayList<Processor> processes;
    private WCS wcs;
    private static String version;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Imager.usage();
        } else {
            Imager im = Imager.getImager();
            Settings.addArgs(args);
            im.run();
        }
        if (!Settings.has("imagej") && !Settings.has("noexit")) {
            System.exit(0);
        }
    }

    public static String getVersion() {
        return version;
    }

    public Imager() {
        if (Settings.get("surveyfinder") == null) {
            Settings.put("surveyfinder", "XMLSurveyFinder");
        }
        lastImager = this;
    }

    private void cleanCache() {
        String cacheFiles;
        if (Settings.get("purgecache") != null && (cacheFiles = Settings.get("_cachedfile")) != null) {
            String[] files;
            for (String file : files = comma.split(cacheFiles)) {
                new File(file).delete();
            }
        }
    }

    public String getSamplerName() {
        return this.samp.getName();
    }

    public Scaler getScaler() {
        return this.s;
    }

    public Object getImageData() {
        return this.output.getDataArray();
    }

    public double getLon() {
        return this.lon;
    }

    public double getLat() {
        return this.lat;
    }

    public Survey getSurvey() {
        return this.surv;
    }

    public double[] getEdgeAdjustments() {
        return this.edgeAdjustments;
    }

    public Image[] getCandidates() {
        return this.cand;
    }

    public int getPixelDepth() {
        return this.output.getDepth();
    }

    public int getPixelWidth() {
        return this.output.getWidth();
    }

    public int getPixelHeight() {
        return this.output.getHeight();
    }

    private static void usage() {
        try {
            String line;
            BufferedReader rdr = new BufferedReader(new InputStreamReader(skyview.survey.Util.getResourceOrFile("onlineintro.txt")));
            while ((line = rdr.readLine()) != null) {
                System.err.println(line);
            }
            rdr.close();
        }
        catch (Exception e) {
            System.err.println("Error reading usage file:" + e);
        }
        SurveyFinder finder = (SurveyFinder)Utilities.newInstance(Settings.get("surveyfinder"), "skyview.survey");
        if (finder == null) {
            System.err.println("Error creating SurveyFinder: " + Settings.get("surveyfinder"));
            return;
        }
        System.err.println("\nAvailable surveys: (including all aliases)\n");
        Object[] surveys = finder.getSurveys();
        Arrays.sort(surveys);
        for (int i = 0; i < surveys.length; ++i) {
            System.err.println("  " + (String)surveys[i]);
        }
    }

    public void run(String[] args) throws Exception {
        Settings.addArgs(args);
        this.run();
    }

    public void checkUpdateSettings() {
        String[] updateClasses = Settings.getArray("settingsupdaters");
        for (int i = 0; i < updateClasses.length; ++i) {
            try {
                SettingsUpdater su = (SettingsUpdater)Utilities.newInstance(updateClasses[i], "skyview.executive");
                su.updateSettings();
                continue;
            }
            catch (Exception e) {
                System.err.println("Exception during attempt to update Settings:" + e + "\nProcessing continues");
            }
        }
    }

    public boolean init() throws Exception {
        String[] files = Settings.getArray("settings");
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals("-")) {
                Settings.readFile(new BufferedReader(new InputStreamReader(System.in)));
                continue;
            }
            Settings.updateFromFile(files[i]);
        }
        this.checkUpdateSettings();
        if (Settings.get("survey") == null && Settings.get("contour") == null) {
            System.err.println("No survey specified");
            return false;
        }
        if (!(Settings.has("position") || Settings.get("lon") != null && Settings.get("lat") != null || Settings.has("copywcs"))) {
            System.err.println("No position specified");
            return false;
        }
        if (finder == null) {
            finder = (SurveyFinder)Utilities.newInstance(Settings.get("surveyfinder"), "skyview.survey");
        }
        if (!Settings.has("output")) {
            Settings.put("output", "output");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (!this.init()) {
            return;
        }
        System.err.println("Imager starting v" + version + ".");
        String[] survs = Settings.getArray("survey");
        String output = Settings.get("output");
        int count = 1;
        for (String surv : survs) {
            if (survs.length > 1) {
                this.updateOutput(output, count);
            }
            try {
                Settings.save();
                Settings.put("_surveycount", "" + count);
                System.err.println("\nProcessing survey:" + surv);
                this.processSurvey(surv);
            }
            finally {
                String scale = null;
                if (count == 1 && Settings.has("rgb") && Settings.has("scale")) {
                    scale = Settings.get("scale");
                }
                Settings.restore();
                if (scale != null) {
                    Settings.put("scale", scale);
                }
            }
            ++count;
        }
    }

    private void updateOutput(String output, int count) {
        int off;
        if (output.equals("-") || output.toLowerCase().equals("stdout")) {
            return;
        }
        File fil = new File(output);
        String path = fil.getName();
        if (path == null || path.length() == 0) {
            path = "output";
        }
        path = (off = path.indexOf(46)) == 0 ? "" + count + path : (off > 0 ? path.substring(0, off) + "_" + count + path.substring(off) : path + "_" + count);
        String parent = fil.getParent();
        if (parent == null) {
            parent = "";
        }
        if (parent.length() > 0) {
            path = parent + "/" + path;
        }
        Settings.put("output", path);
    }

    protected Survey loadSurvey(String surveyID) throws Exception {
        Survey surv;
        if (surveyID.toLowerCase().equals("user")) {
            surv = new UserSurvey();
        } else {
            surv = finder.find(surveyID);
            if (surv == null) {
                System.err.println("  Unable to find requested survey:" + surveyID);
                return surv;
            }
        }
        surv.updateSettings();
        return surv;
    }

    protected WCS loadWCS() throws Exception {
        WCS wcs = null;
        if (Settings.has("UseDSSWCS")) {
            WCS.setPreferDSS(true);
        }
        if (Settings.has("CopyWCS")) {
            wcs = this.copyWCS(Settings.get("CopyWCS"));
            this.s = wcs.getScaler();
            int[] axes = wcs.getHeaderNaxis();
            this.nx = axes[0];
            this.ny = axes[1];
        } else {
            if (Settings.get("Pixels") != null && Settings.get("Pixels").length() > 0) {
                String[] pix = comma.split(Settings.get("Pixels"));
                try {
                    this.nx = Integer.parseInt(pix[0].trim());
                }
                catch (Exception e) {
                    Settings.put("errormsg", "Invalid pixels setting:" + Settings.get("pixels"));
                    throw new Exception("Invalid pixels setting:" + Settings.get("Pixels"));
                }
                if (pix.length > 1) {
                    try {
                        this.ny = Integer.parseInt(pix[1].trim());
                    }
                    catch (Exception e) {
                        Settings.put("errormsg", "Invalid pixels setting:" + Settings.get("pixels"));
                        throw new Exception("Invalid pixels setting:" + Settings.get("Pixels"));
                    }
                } else {
                    this.ny = this.nx;
                }
            } else {
                this.nx = 300;
                this.ny = 300;
            }
            wcs = this.specifyWCS(this.nx, this.ny);
        }
        Header h = new Header();
        wcs.updateHeader(h, this.getScaler(), new double[]{this.getLon(), this.getLat()}, Settings.get("Projection"), Settings.get("Coordinates"));
        Settings.put("_CRPIX1", h.getDoubleValue("CRPIX1") + "");
        Settings.put("_CRPIX2", h.getDoubleValue("CRPIX2") + "");
        Settings.put("_CRVAL1", h.getDoubleValue("CRVAL1") + "");
        Settings.put("_CRVAL2", h.getDoubleValue("CRVAL2") + "");
        Settings.put("_CDELT1", h.getDoubleValue("CDELT1") + "");
        Settings.put("_CDELT2", h.getDoubleValue("CDELT2") + "");
        Settings.put("_CD1_1", h.getDoubleValue("CD1_1") + "");
        Settings.put("_CD1_2", h.getDoubleValue("CD1_2") + "");
        Settings.put("_CD2_1", h.getDoubleValue("CD2_1") + "");
        Settings.put("_CD2_2", h.getDoubleValue("CD2_2") + "");
        return wcs;
    }

    protected Position loadPosition() throws Exception {
        double[] cpix = new double[]{(double)this.nx / 2.0, (double)this.ny / 2.0};
        double[] cunit = new double[3];
        this.wcs.inverse().transform(cpix, cunit);
        cpix = Util.coord(cunit);
        cpix[0] = Math.toDegrees(cpix[0]);
        cpix[1] = Math.toDegrees(cpix[1]);
        if (cpix[0] != cpix[0] || cpix[1] != cpix[1]) {
            System.err.println("  Unable to locate center position in projection -- rounding error at edge?");
            return null;
        }
        return new Position(cpix[0], cpix[1], "J2000");
    }

    protected Image loadImage() throws Exception {
        double[] data = new double[this.nx * this.ny * this.nz];
        return new Image(data, this.wcs, this.nx, this.ny, this.nz);
    }

    protected Image[] loadCandidates(Position pos) throws Exception {
        double maxSize = (double)Math.max(this.nx, this.ny) * this.wcs.getScale() * 180.0 / Math.PI;
        if (maxSize <= 0.0) {
            throw new Exception("Ouput region has nil size");
        }
        Image[] cand = this.surv.getImages(pos, maxSize);
        if (cand.length == 0 && !Settings.has("nullimages")) {
            String msg = "Survey: " + Settings.get("_currentSurvey") + " No candidate images were found in the region.  Position may be outside the coverage area.";
            Settings.put("ErrorMsg", msg);
            System.err.println("  No candidate images.  Processing of this survey is completed.");
            this.output = null;
        } else {
            System.err.println("  Number of candidate source images is " + cand.length + ".");
        }
        return cand;
    }

    protected void loadSamplers() throws Exception {
        String sampling = Settings.get("Sampler");
        this.samp = Sampler.factory(sampling);
        if (Settings.get("Ebins") != null) {
            this.dsamp = new DepthSampler(this.bin0, this.dBin, this.nz);
        }
    }

    protected int[] reuseMatch(String surveyID) {
        String primary;
        if (this.match != null && Settings.get("GeometryTwin") != null && Pattern.compile(primary = "(^|.*,)" + this.lastSurvey + "($|,.*)", 2).matcher(Settings.get("GeometryTwin")).find()) {
            System.err.println("  Reusing geometry match from:" + this.lastSurvey);
            return this.match;
        }
        return null;
    }

    protected int[] loadMatch(String surveyID) throws Exception {
        ImageFinder imFin = ImageFinder.factory(Settings.get("imagefinder"));
        imFin.setStrict(Settings.has("StrictGeometry"));
        this.match = imFin.findImages(this.cand, this.output);
        this.lastSurvey = surveyID;
        if (this.match == null) {
            if (!Settings.has("NullImages")) {
                Settings.put("ErrorMsg", "No images in FOV");
                this.output = null;
            } else {
                this.match = new int[this.output.getWidth() * this.output.getHeight()];
                Arrays.fill(this.match, -2);
            }
        }
        return this.match;
    }

    protected void doProcess(String type) throws Exception {
        String[] procNames = Settings.getArray(type);
        for (int i = 0; i < procNames.length; ++i) {
            this.dynoProcess(procNames[i]);
        }
    }

    public void dynoProcess(String name) throws Exception {
        Processor proc = (Processor)Class.forName(name).newInstance();
        proc.process(this.cand, this.output, this.match, this.samp, this.dsamp);
        this.processes.add(proc);
    }

    public void clearImageCache() {
        doneImages.clear();
    }

    protected ImageState haveImage(String surveyID, WCS wcs) {
        ImageState oldImage = null;
        SoftReference<ImageState> wr = doneImages.get(surveyID.toLowerCase());
        if (wr != null) {
            oldImage = wr.get();
        }
        if (oldImage != null && oldImage.output.getWCS().getScale() == wcs.getScale()) {
            System.err.println("  Using cached image for " + surveyID);
            return oldImage;
        }
        return null;
    }

    public void processSurvey(String surveyID) throws Exception {
        Settings.put("_currentSurvey", surveyID);
        this.output = this.loadAndProcessSurvey(surveyID);
        this.postprocessSurvey();
        if (this.match != null && this.output != null && !Settings.has("nofits")) {
            this.createFitsFile();
        }
    }

    public static double getSum(double[] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i];
        }
        return sum;
    }

    public Image loadAndProcessSurvey(String surveyID) throws Exception {
        this.processes = new ArrayList();
        this.surv = this.loadSurvey(surveyID);
        if (this.surv == null) {
            return null;
        }
        this.wcs = this.loadWCS();
        if (this.wcs == null) {
            return null;
        }
        if (this.haveImage(surveyID, this.wcs) != null) {
            ImageState is = this.haveImage(surveyID, this.wcs);
            this.cand = is.sources;
            this.samp = is.samp;
            this.dsamp = is.dsamp;
            this.processes = is.procs;
            return is.output;
        }
        Position pos = this.loadPosition();
        if (pos == null) {
            return null;
        }
        this.parseEbins();
        this.output = this.loadImage();
        this.cand = this.loadCandidates(pos);
        this.match = this.reuseMatch(surveyID);
        if (this.match == null && this.cand != null && this.cand.length > 0 || Settings.has("NullImages")) {
            this.loadMatch(surveyID);
        }
        if (this.match != null) {
            this.loadSamplers();
            this.doProcess("Preprocessor");
            if (Settings.get("mosaicker") == null) {
                Settings.put("mosaicker", "skyview.process.Mosaicker");
            }
            this.doProcess("Mosaicker");
        }
        if (this.output != null) {
            doneImages.put(surveyID, new SoftReference<ImageState>(new ImageState(this.cand, this.output, this.match, this.samp, this.dsamp, this.processes)));
        }
        return this.output;
    }

    public void postprocessSurvey() throws Exception {
        this.doProcess("Deedger");
        this.doProcess("Postprocessor");
        this.cleanCache();
        this.dsamp = null;
    }

    private void parseEbins() {
        if (!Settings.has("Ebins")) {
            return;
        }
        String[] tokens = comma.split(Settings.get("Ebins"));
        if (tokens.length != 3) {
            throw new Error("Invalid energy bin setting:" + Settings.get("Ebins"));
        }
        this.bin0 = Double.parseDouble(tokens[0]);
        this.dBin = Double.parseDouble(tokens[1]);
        this.nz = Integer.parseInt(tokens[2]);
        if (this.nz < 0 || this.bin0 < 0.0 || this.dBin < 0.0) {
            throw new Error("Invalid energy bin setting:" + Settings.get("Ebins"));
        }
    }

    public void createFitsFile() throws Exception {
        Scaler scaler = this.getScaler();
        Object data = this.getImageData();
        if (data == null) {
            System.err.println("  Unexpected error: No image data found!");
            return;
        }
        if (Settings.get("float") != null) {
            data = ArrayFuncs.convertArray(data, Float.TYPE);
        }
        int nx = this.getPixelWidth();
        int ny = this.getPixelHeight();
        int nz = this.getPixelDepth();
        int[] outDims = nz == 1 ? new int[]{ny, nx} : new int[]{nz, ny, nx};
        double[] edgeAdjustments = this.getEdgeAdjustments();
        Image[] cand = this.getCandidates();
        Header h = new Header();
        h.addValue("SIMPLE", true, "Written by SkyView " + new Date());
        if (Settings.has("float")) {
            h.addValue("BITPIX", -32L, "4 byte floating point");
        } else {
            h.addValue("BITPIX", -64L, "8 byte floating point");
        }
        if (nz == 1) {
            h.addValue("NAXIS", 2L, "Two dimensional image");
        } else {
            h.addValue("NAXIS", 3L, "Three dimensional image");
        }
        h.addValue("NAXIS1", nx, "Width of image");
        h.addValue("NAXIS2", ny, "Height of image");
        if (nz != 1) {
            h.addValue("NAXIS3", nz, "Depth of image");
        }
        if (Settings.has("copywcs")) {
            this.wcs.copyToHeader(h);
        } else {
            this.wcs.updateHeader(h, scaler, new double[]{this.getLon(), this.getLat()}, Settings.get("Projection"), Settings.get("Coordinates"));
        }
        Survey surv = this.getSurvey();
        surv.updateHeader(h);
        h.insertHistory("");
        h.insertHistory(" Settings used in processing:");
        h.insertHistory("");
        Object[] keys = Settings.getKeys();
        Arrays.sort(keys);
        for (Object key : keys) {
            if (((String)key).charAt(0) == '_') continue;
            String val = Settings.get((String)key);
            if (val == null) {
                h.insertHistory((String)key + " is null");
                continue;
            }
            if (val.equals("1")) {
                h.insertHistory((String)key);
                continue;
            }
            h.insertHistory((String)key + " = " + val);
        }
        h.insertHistory("");
        h.insertHistory(" Map generated at: " + new Date());
        h.insertHistory("");
        h.insertHistory(" Resampler used: " + this.getSamplerName());
        h.insertHistory("");
        for (Processor p : this.processes) {
            p.updateHeader(h);
        }
        this.writeFits(h, data);
        if (Settings.has("samp")) {
            Samp.notifyFile();
        }
    }

    private void writeFits(Header h, Object data) throws Exception {
        OutputStream base;
        String out;
        String suffix = "";
        if (Settings.get("Compress") != null) {
            suffix = ".gz";
        }
        if ((out = Settings.get("output")).equals("-") || out.equalsIgnoreCase("stdout")) {
            System.err.println("  Sending output to standard output stream");
            base = System.out;
        } else {
            String path = new File(out).getName();
            if (path.indexOf(46) < 0) {
                out = out + ".fits";
            }
            out = out + suffix;
            Settings.put("output_fits", out);
            System.err.println("  Opening FITS file: " + out);
            base = new FileOutputStream(out);
        }
        if (Settings.get("Compress") != null) {
            base = new GZIPOutputStream(base);
        }
        BufferedDataOutputStream bds = new BufferedDataOutputStream(base);
        h.write(bds);
        bds.writeArray(data);
        int len = ArrayFuncs.computeSize(data);
        int need = 2880 - len % 2880;
        if (need != 2880) {
            byte[] buf = new byte[need];
            bds.write(buf);
        }
        bds.close();
    }

    private WCS specifyWCS(int nx, int ny) throws Exception {
        SourceCoordinates sc;
        String csys = Settings.get("Coordinates");
        String proj = Settings.get("Projection");
        String equin = Settings.get("Equinox");
        this.c = CoordinateSystem.factory(csys, equin);
        if (this.c == null) {
            System.err.println("Invalid coordinates:" + csys + " " + Settings.get("equinox"));
            Settings.put("errormsg", "Invalid coordinates or equinox:" + csys + " " + Settings.get("equinox"));
            return null;
        }
        Settings.put("coordinates", this.c.getName());
        csys = this.c.getName();
        double[] posn = null;
        if (Settings.get("Position") != null) {
            sc = new SourceCoordinates(Settings.get("position"), csys, Double.parseDouble(equin), Settings.get("resolver"));
            sc.convertToCoords();
            Position ps = sc.getPosition();
            if (ps == null) {
                throw new Exception("Unable to recognize target/position: " + Settings.get("position"));
            }
            posn = ps.getCoordinates(csys);
            Settings.put("ReqXPos", "" + posn[0]);
            Settings.put("ReqYPos", "" + posn[1]);
        } else if (Settings.has("Lon") && Settings.has("Lat")) {
            sc = SourceCoordinates.factory(Settings.get("lon"), Settings.get("lat"), Settings.get("coordinates"));
            if (sc == null) {
                System.err.println("Invalid coordinates:" + Settings.get("lon") + ", " + Settings.get("lat") + " in " + Settings.get("coordinates"));
                return null;
            }
            posn = sc.getPosition().getCoordinates(csys);
            Settings.put("position", Settings.get("lon") + ", " + Settings.get("lat"));
        } else {
            System.err.println("Error: No position specified");
            return null;
        }
        this.lon = posn[0];
        this.lat = posn[1];
        if (this.lon == Double.NaN || this.lat == Double.NaN) {
            throw new Error("Invalid position/coordinates specified.");
        }
        double xscale = 2.777777777777778E-4;
        double yscale = 2.777777777777778E-4;
        String sz = Settings.get("Size");
        if (sz != null && sz.length() > 0 && !sz.toLowerCase().equals("default")) {
            String[] sizes = comma.split(sz);
            try {
                double xsize;
                double ysize = xsize = Double.parseDouble(sizes[0]);
                if (sizes.length > 1) {
                    ysize = Double.parseDouble(sizes[1]);
                }
                xscale = xsize / (double)nx;
                yscale = ysize / (double)ny;
            }
            catch (Exception e) {
                Settings.put("errormsg", "Invalid size setting:" + sz);
                throw new Exception("Invalid size setting:" + sz);
            }
        } else if (Settings.get("Scale") != null) {
            String[] scales = comma.split(Settings.get("Scale"));
            xscale = Double.parseDouble(scales[0]);
            yscale = scales.length > 1 ? Double.parseDouble(scales[1]) : xscale;
        } else {
            yscale = xscale = 2.777777777777778E-4;
        }
        Settings.put("size", xscale * (double)nx + "," + yscale * (double)ny);
        double[] center = Projection.fixedPoint(proj);
        if (center != null) {
            this.p = new Projection(proj);
            if (Settings.has("RefCoords")) {
                String[] coords = Settings.getArray("RefCoords");
                try {
                    double lon = Math.toRadians(Double.parseDouble(coords[0]));
                    double lat = Math.toRadians(Double.parseDouble(coords[1]));
                    if (lon != center[0] || lat != center[1]) {
                        this.p.setReference(lon, lat);
                        System.err.println("  Using non-standard image center:" + Settings.get("RefCoords"));
                    } else {
                        System.err.println("  New reference center matches original");
                    }
                }
                catch (Exception e) {
                    System.err.println("Error resetting reference coordinates to:" + Settings.get("RefCoords") + "\nProcessing continues  with defaults.");
                }
            }
            Converter cvt = new Converter();
            cvt.add(this.p.getRotater());
            cvt.add(this.p.getProjecter());
            double[] uv = Util.unit(Math.toRadians(this.lon), Math.toRadians(this.lat));
            double[] coords = cvt.transform(uv);
            this.s = new Scaler(0.5 * (double)nx + coords[0] / Math.toRadians(xscale), 0.5 * (double)ny - coords[1] / Math.toRadians(yscale), -1.0 / Math.toRadians(xscale), 0.0, 0.0, 1.0 / Math.toRadians(yscale));
        } else {
            this.p = new Projection(proj, new double[]{Math.toRadians(this.lon), Math.toRadians(this.lat)});
            this.s = new Scaler(0.5 * (double)nx, 0.5 * (double)ny, -1.0 / Math.toRadians(xscale), 0.0, 0.0, 1.0 / Math.toRadians(yscale));
        }
        String rot = Settings.get("rotation");
        if (rot != null && rot.length() > 0) {
            double angle;
            try {
                angle = Math.toRadians(Double.parseDouble(rot));
            }
            catch (Exception e) {
                throw new Exception("Invalid rotation setting:" + rot);
            }
            Scaler rScale = new Scaler(0.0, 0.0, Math.cos(angle), Math.sin(angle), -Math.sin(angle), Math.cos(angle));
            this.s = rScale.add(this.s);
        }
        if (Settings.has("offset")) {
            double[] deltas = new double[2];
            try {
                String[] offsets = Settings.getArray("offset");
                if (offsets.length == 2) {
                    deltas[0] = -Double.parseDouble(offsets[0]);
                    deltas[1] = -Double.parseDouble(offsets[1]);
                } else {
                    deltas[0] = -Double.parseDouble(offsets[0]);
                    deltas[1] = deltas[0];
                }
                Scaler translate = new Scaler(deltas[0], deltas[1], 1.0, 0.0, 0.0, 1.0);
                this.s = this.s.add(translate);
            }
            catch (Exception e) {
                System.err.println("Error parsing/applying offset:" + Settings.get("Offset"));
            }
        }
        return new WCS(this.c, this.p, this.s);
    }

    private WCS copyWCS(String file) throws Exception {
        Header hdr = new Header(new Fits(file).getStream());
        return new WCS(hdr);
    }

    public static Imager getImager() {
        if (lastImager == null) {
            new Imager();
        }
        return lastImager;
    }

    static {
        version = "2.6";
    }

    private class ImageState {
        private Image[] sources;
        private Image output;
        private int[] match;
        private Sampler samp;
        private DepthSampler dsamp;
        private ArrayList<Processor> procs;

        ImageState(Image[] sources, Image output, int[] match, Sampler samp, DepthSampler dsamp, ArrayList<Processor> procs) {
            this.sources = sources;
            this.output = output;
            this.match = match;
            this.samp = samp;
            this.dsamp = dsamp;
            this.procs = (ArrayList)procs.clone();
        }
    }
}

