/*
 * Decompiled with CFR 0.152.
 */
package skyview.data;

import java.util.HashMap;
import skyview.data.BoxSmoother;
import skyview.executive.Imager;
import skyview.executive.Settings;
import skyview.survey.Image;

public class Contourer {
    private double min = 0.25;
    private double max = 1.0;
    private double delta = 0.25;
    private int nContour = 4;
    private double[] data;
    private int nx;
    private int ny;
    private double minGt0 = -1.0;
    private double[] copy = null;
    private Image img;
    private CFunc func = null;

    public void setLimits(double min, double max, int n) {
        this.setLimits(min, max, n, 1.0);
    }

    public void setLimits(double min, double max, int n, double fraction) {
        this.min = min;
        this.max = max;
        if (this.func != null) {
            this.min = this.func.func(this.min);
            this.max = this.func.func(this.max);
        }
        this.delta = n > 1 ? (this.max - this.min) / (double)(n - 1) : 1.0;
        if (fraction < 1.0 && fraction > 0.0) {
            double dfrac = (1.0 - fraction) / 2.0 * this.delta;
            this.min += dfrac;
            this.max -= dfrac;
            this.delta *= fraction;
        }
        this.nContour = n;
    }

    public void putImage(Image img) {
        this.data = img.getDataArray();
        this.nx = img.getWidth();
        this.ny = img.getHeight();
        this.img = img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getData(String survey) {
        String scale = Settings.get("scale");
        HashMap<String, String> oldSettings = Settings.pop();
        boolean hadScale = Settings.has("scale");
        if (!hadScale) {
            Settings.put("scale", scale);
        }
        Imager imager = new Imager();
        try {
            System.err.println("  Contour requesting image from survey " + survey);
            Settings.put("preprocessor", "null");
            this.img = imager.loadAndProcessSurvey(survey);
            String[] posts = Settings.getArray("postprocessor");
            String[] fposts = Settings.getArray("finalpostprocessor");
            for (int i = 0; i < posts.length; ++i) {
                boolean match = false;
                for (int j = 0; j < fposts.length; ++j) {
                    if (!posts[i].equals(fposts[j])) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                if (this.copy == null) {
                    this.copy = (double[])this.img.getDataArray().clone();
                }
                imager.dynoProcess(posts[i]);
            }
            if (this.img == null) {
                boolean bl = false;
                return bl;
            }
            this.putImage(this.img);
        }
        catch (Exception e) {
            System.err.println("  Error getting contour image for " + survey);
            e.printStackTrace();
            System.err.println("  Continuing without contour\n");
            boolean bl = false;
            return bl;
        }
        finally {
            Settings.push(oldSettings);
        }
        return true;
    }

    public double[] getRange() {
        if (this.data == null) {
            return null;
        }
        double[] range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] > 0.0 && this.data[i] < this.minGt0) {
                this.minGt0 = this.data[i];
            }
            if (this.data[i] < range[0]) {
                range[0] = this.data[i];
            }
            if (!(this.data[i] > range[1])) continue;
            range[1] = this.data[i];
        }
        return range;
    }

    public void setFunction(String funcName) {
        if (funcName == null) {
            this.func = null;
            return;
        }
        this.func = (funcName = funcName.toLowerCase()).equals("null") ? null : (funcName.equals("log") ? new CLog() : (funcName.equals("sqrt") ? new CSqrt() : null));
    }

    public int[] contour() {
        int line;
        int mx;
        int mn;
        int iv1;
        double v1;
        int iv0;
        if (Settings.has("contourSmooth")) {
            int boxWidth = 3;
            int boxHeight = 3;
            String[] cs = Settings.getArray("contourSmooth");
            if (cs.length > 0 || cs[0].length() > 0) {
                try {
                    boxHeight = boxWidth = Integer.parseInt(cs[0]);
                    if (cs.length > 1) {
                        boxHeight = Integer.parseInt(cs[1]);
                    }
                }
                catch (Exception e) {
                    System.err.println("  Error parsing contour smoothing:" + Settings.get("contourSmooth"));
                }
            }
            double[] xdata = (double[])this.data.clone();
            this.data = xdata;
            BoxSmoother.smooth(this.data, this.nx, this.ny, 1, boxHeight, boxWidth);
        }
        int[] result = new int[this.nx * this.ny];
        int[] counts = new int[this.nContour + 1];
        for (int i = 0; i < this.ny; ++i) {
            double v0 = this.get(this.data[i * this.nx]);
            int n = iv0 = (int)v0;
            counts[n] = counts[n] + 1;
            for (int j = 1; j < this.nx; ++j) {
                v1 = this.get(this.data[j + i * this.nx]);
                int n2 = iv1 = (int)v1;
                counts[n2] = counts[n2] + 1;
                mn = iv0;
                mx = iv1;
                if (iv0 > iv1) {
                    mn = iv1;
                    mx = iv0;
                }
                if (iv0 != iv1) {
                    for (line = mn + 1; line <= mx; ++line) {
                        if (Math.abs((double)line - v0) < Math.abs((double)line - v1)) {
                            result[j - 1 + i * this.nx] = line;
                            continue;
                        }
                        result[j + i * this.nx] = line;
                    }
                }
                v0 = v1;
                iv0 = iv1;
            }
        }
        for (int j = 0; j < this.nx; ++j) {
            double v0 = this.get(this.data[j]);
            iv0 = (int)v0;
            for (int i = 1; i < this.ny; ++i) {
                v1 = this.get(this.data[j + i * this.nx]);
                iv1 = (int)v1;
                if (iv0 != iv1) {
                    mn = iv0;
                    mx = iv1;
                    if (iv0 > iv1) {
                        mn = iv1;
                        mx = iv0;
                    }
                    for (line = mn + 1; line <= mx; ++line) {
                        if (Math.abs((double)line - v0) < Math.abs((double)line - v1)) {
                            result[j + (i - 1) * this.nx] = line;
                            continue;
                        }
                        result[j + i * this.nx] = line;
                    }
                }
                v0 = v1;
                iv0 = iv1;
            }
        }
        if (!Settings.has("NoContourPrint")) {
            double basis;
            double val0 = basis = this.min;
            double val1 = -1.0;
            if (this.func != null) {
                val0 = this.func.ifunc(basis);
            }
            System.err.println("  Contour histogram");
            System.err.printf("  %8d counts below contour 1 (%.3g) %n", counts[0], val0);
            for (int i = 1; i < this.nContour; ++i) {
                val1 = basis += this.delta;
                if (this.func != null) {
                    val1 = this.func.ifunc(basis);
                }
                System.err.printf("  %8d counts between contours %d (%.3g) and %d (%.3g) %n", counts[i], i, val0, i + 1, val1);
                val0 = val1;
            }
            System.err.printf("  %8d counts above contour %d (%.3g)%n", counts[this.nContour], this.nContour, val1);
        }
        if (this.copy != null) {
            this.img.setDataArray(this.copy);
        }
        return result;
    }

    private double get(double input) {
        double val;
        if (this.func != null) {
            input = this.func.func(input);
        }
        if ((val = (input - this.min) / this.delta + 1.0) < 0.5) {
            val = 0.5;
        }
        if (val > (double)this.nContour + 0.5) {
            val = (double)this.nContour + 0.5;
        }
        return val;
    }

    public class CSqrt
    implements CFunc {
        @Override
        public double func(double input) {
            if (input < 0.0) {
                return 0.0;
            }
            return Math.sqrt(input);
        }

        @Override
        public double ifunc(double input) {
            return input * input;
        }
    }

    private class CLog
    implements CFunc {
        private CLog() {
        }

        @Override
        public double func(double input) {
            if (input <= 0.0) {
                if (Contourer.this.minGt0 > 0.0) {
                    return Math.log10(Contourer.this.minGt0);
                }
                return -10.0;
            }
            return Math.log10(input);
        }

        @Override
        public double ifunc(double input) {
            return Math.pow(10.0, input);
        }
    }

    private static interface CFunc {
        public double func(double var1);

        public double ifunc(double var1);
    }
}

