/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.test;

import java.util.Arrays;
import nom.tam.util.ByteFormatter;
import nom.tam.util.ByteParser;
import nom.tam.util.TruncationException;
import org.junit.Assert;
import org.junit.Test;

public class ByteFormatParseTester {
    byte[] buffer = new byte[100000];
    ByteFormatter bf = new ByteFormatter();
    ByteParser bp = new ByteParser(this.buffer);
    int offset = 0;
    int cnt = 0;

    @Test
    public void testInt() throws Exception {
        int i;
        int chk;
        int i2;
        for (int i3 = 0; i3 < 10; ++i3) {
            this.buffer[i3] = 32;
        }
        this.bp.setOffset(0);
        Assert.assertEquals((String)"IntBlank", (Object)0, (Object)this.bp.getInt(10));
        this.bf.setAlign(true);
        this.bf.setTruncationThrow(false);
        int[] tint = new int[100];
        tint[0] = Integer.MIN_VALUE;
        tint[1] = Integer.MAX_VALUE;
        tint[2] = 0;
        for (int i4 = 0; i4 < tint.length; ++i4) {
            tint[i4] = (int)(2.147483647E9 * (2.0 * (Math.random() - 0.5)));
        }
        int colSize = 12;
        while (this.cnt < tint.length) {
            this.offset = this.bf.format(tint[this.cnt], this.buffer, this.offset, colSize);
            ++this.cnt;
            if (this.cnt % 8 != 0) continue;
            this.offset = this.bf.format("\n", this.buffer, this.offset, 1);
        }
        this.bp.setOffset(0);
        for (i2 = 0; i2 < tint.length; ++i2) {
            chk = this.bp.getInt(colSize);
            Assert.assertEquals((String)"IntegersRA", (Object)chk, (Object)tint[i2]);
            if ((i2 + 1) % 8 != 0) continue;
            this.bp.skip(1);
        }
        this.bf.setAlign(false);
        this.bp.setFillFields(true);
        this.offset = 0;
        colSize = 12;
        this.cnt = 0;
        this.offset = 0;
        while (this.cnt < tint.length) {
            int oldOffset = this.offset;
            this.offset = this.bf.format(tint[this.cnt], this.buffer, this.offset, colSize);
            int nb = colSize - (this.offset - oldOffset);
            if (nb > 0) {
                this.offset = this.bf.alignFill(this.buffer, this.offset, nb);
            }
            ++this.cnt;
            if (this.cnt % 8 != 0) continue;
            this.offset = this.bf.format("\n", this.buffer, this.offset, 1);
        }
        this.bp.setOffset(0);
        for (i2 = 0; i2 < tint.length; ++i2) {
            chk = this.bp.getInt(colSize);
            Assert.assertEquals((String)"IntegersLA", (Object)chk, (Object)tint[i2]);
            if ((i2 + 1) % 8 != 0) continue;
            this.bp.skip(1);
        }
        this.offset = 0;
        colSize = 12;
        this.cnt = 0;
        this.offset = 0;
        while (this.cnt < tint.length) {
            this.offset = this.bf.format(tint[this.cnt], this.buffer, this.offset, colSize);
            ++this.cnt;
            if (this.cnt % 8 != 0) continue;
            this.offset = this.bf.format("\n", this.buffer, this.offset, 1);
        }
        String myStr = new String(this.buffer, 0, this.offset);
        Assert.assertEquals((String)"No spaces", (Object)-1, (Object)myStr.indexOf(" "));
        this.bf.setAlign(false);
        this.offset = 0;
        colSize = 12;
        this.cnt = 0;
        this.offset = 0;
        while (this.cnt < tint.length) {
            this.offset = this.bf.format(tint[this.cnt], this.buffer, this.offset, colSize);
            this.offset = this.bf.format(" ", this.buffer, this.offset, 1);
            ++this.cnt;
        }
        myStr = new String(this.buffer, 0, this.offset);
        String[] array = myStr.split(" ");
        Assert.assertEquals((String)"Split size", (Object)100, (Object)array.length);
        for (int i5 = 0; i5 < array.length; ++i5) {
            Assert.assertEquals((String)"Parse token", (Object)tint[i5], (Object)Integer.parseInt(array[i5]));
        }
        this.bf.setTruncationThrow(false);
        int val = 1;
        Arrays.fill(this.buffer, (byte)32);
        for (i = 0; i < 10; ++i) {
            this.offset = this.bf.format(val, this.buffer, 0, 6);
            String test = (val + "      ").substring(0, 6);
            if (i < 6) {
                Assert.assertEquals((String)("TestTrunc" + i), (Object)test, (Object)new String(this.buffer, 0, 6));
            } else {
                Assert.assertEquals((String)("TestTrunc" + i), (Object)"******", (Object)new String(this.buffer, 0, 6));
            }
            val *= 10;
        }
        this.bf.setTruncationThrow(true);
        val = 1;
        for (i = 0; i < 10; ++i) {
            boolean thrown = false;
            try {
                this.offset = this.bf.format(val, this.buffer, 0, 6);
            }
            catch (TruncationException e) {
                thrown = true;
            }
            if (i < 6) {
                Assert.assertEquals((String)("TestTruncThrow" + i), (Object)false, (Object)thrown);
            } else {
                Assert.assertEquals((String)("TestTruncThrow" + i), (Object)true, (Object)thrown);
            }
            val *= 10;
        }
    }

    @Test
    public void testLong() throws Exception {
        int i;
        for (int i2 = 0; i2 < 10; ++i2) {
            this.buffer[i2] = 32;
        }
        this.bp.setOffset(0);
        Assert.assertEquals((String)"LongBlank", (Object)0L, (Object)this.bp.getLong(10));
        long[] lng = new long[100];
        for (i = 0; i < lng.length; ++i) {
            lng[i] = (long)(9.223372036854776E18 * (2.0 * (Math.random() - 0.5)));
        }
        lng[0] = Long.MAX_VALUE;
        lng[1] = Long.MIN_VALUE;
        lng[2] = 0L;
        this.bf.setTruncationThrow(false);
        this.bp.setFillFields(true);
        this.bf.setAlign(true);
        this.offset = 0;
        for (i = 0; i < lng.length; ++i) {
            this.offset = this.bf.format(lng[i], this.buffer, this.offset, 20);
            if ((i + 1) % 4 != 0) continue;
            this.offset = this.bf.format("\n", this.buffer, this.offset, 1);
        }
        this.bp.setOffset(0);
        for (i = 0; i < lng.length; ++i) {
            Assert.assertEquals((String)"Long check", (Object)lng[i], (Object)this.bp.getLong(20));
            if ((i + 1) % 4 != 0) continue;
            this.bp.skip(1);
        }
    }

    @Test
    public void testFloat() throws Exception {
        int i;
        for (int i2 = 0; i2 < 10; ++i2) {
            this.buffer[i2] = 32;
        }
        this.bp.setOffset(0);
        Assert.assertEquals((String)"FloatBlank", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(this.bp.getFloat(10)));
        float[] flt = new float[100];
        for (i = 6; i < flt.length; ++i) {
            flt[i] = (float)(2.0 * (Math.random() - 0.5) * Math.pow(10.0, 60.0 * (Math.random() - 0.5)));
        }
        flt[0] = Float.MAX_VALUE;
        flt[1] = Float.MIN_VALUE;
        flt[2] = 0.0f;
        flt[3] = Float.NaN;
        flt[4] = Float.POSITIVE_INFINITY;
        flt[5] = Float.NEGATIVE_INFINITY;
        this.bf.setTruncationThrow(false);
        this.bf.setAlign(true);
        this.offset = 0;
        this.cnt = 0;
        while (this.cnt < flt.length) {
            this.offset = this.bf.format(flt[this.cnt], this.buffer, this.offset, 24);
            ++this.cnt;
            if (this.cnt % 4 != 0) continue;
            this.offset = this.bf.format("\n", this.buffer, this.offset, 1);
        }
        this.bp.setOffset(0);
        for (i = 0; i < flt.length; ++i) {
            float chk = this.bp.getFloat(24);
            float dx = Math.abs(chk - flt[i]);
            if (flt[i] != 0.0f) {
                dx /= Math.abs(flt[i]);
            }
            if (Float.isNaN(flt[i])) {
                Assert.assertEquals((String)("Float check:" + i), (Object)true, (Object)Float.isNaN(chk));
            } else if (Float.isInfinite(flt[i])) {
                Assert.assertEquals((String)("Float check:" + i), (Object)Float.valueOf(flt[i]), (Object)Float.valueOf(chk));
            } else {
                Assert.assertEquals((String)("Float check:" + i), (double)0.0, (double)dx, (double)1.0E-6);
            }
            if ((i + 1) % 4 != 0) continue;
            this.bp.skip(1);
        }
    }

    @Test
    public void testDouble() throws Exception {
        int i;
        for (int i2 = 0; i2 < 10; ++i2) {
            this.buffer[i2] = 32;
        }
        this.bp.setOffset(0);
        Assert.assertEquals((String)"DoubBlank", (Object)0.0, (Object)this.bp.getDouble(10));
        double[] dbl = new double[100];
        for (i = 6; i < dbl.length; ++i) {
            dbl[i] = 2.0 * (Math.random() - 0.5) * Math.pow(10.0, 60.0 * (Math.random() - 0.5));
        }
        dbl[0] = Double.MAX_VALUE;
        dbl[1] = Double.MIN_VALUE;
        dbl[2] = 0.0;
        dbl[3] = Double.NaN;
        dbl[4] = Double.POSITIVE_INFINITY;
        dbl[5] = Double.NEGATIVE_INFINITY;
        this.bf.setTruncationThrow(false);
        this.bf.setAlign(true);
        this.offset = 0;
        this.cnt = 0;
        while (this.cnt < dbl.length) {
            this.offset = this.bf.format(dbl[this.cnt], this.buffer, this.offset, 25);
            ++this.cnt;
            if (this.cnt % 4 != 0) continue;
            this.offset = this.bf.format("\n", this.buffer, this.offset, 1);
        }
        this.bp.setOffset(0);
        for (i = 0; i < dbl.length; ++i) {
            double chk = this.bp.getDouble(25);
            double dx = Math.abs(chk - dbl[i]);
            if (dbl[i] != 0.0) {
                dx /= Math.abs(dbl[i]);
            }
            if (Double.isNaN(dbl[i])) {
                Assert.assertEquals((String)("Double check:" + i), (Object)true, (Object)Double.isNaN(chk));
            } else if (Double.isInfinite(dbl[i])) {
                Assert.assertEquals((String)("Double check:" + i), (Object)dbl[i], (Object)chk);
            } else {
                Assert.assertEquals((String)("Double check:" + i), (double)0.0, (double)dx, (double)1.0E-14);
            }
            if ((i + 1) % 4 != 0) continue;
            this.bp.skip(1);
        }
    }

    @Test
    public void testBoolean() throws Exception {
        int i;
        boolean[] btst = new boolean[100];
        for (i = 0; i < btst.length; ++i) {
            btst[i] = Math.random() > 0.5;
        }
        this.offset = 0;
        for (i = 0; i < btst.length; ++i) {
            this.offset = this.bf.format(btst[i], this.buffer, this.offset, 1);
            this.offset = this.bf.format(" ", this.buffer, this.offset, 1);
        }
        this.bp.setOffset(0);
        for (i = 0; i < btst.length; ++i) {
            Assert.assertEquals((String)("Boolean:" + i), (Object)btst[i], (Object)this.bp.getBoolean());
        }
    }

    @Test
    public void testString() throws Exception {
        int i;
        this.offset = 0;
        String bigStr = "abcdefghijklmnopqrstuvwxyz";
        for (i = 0; i < 100; ++i) {
            this.offset = this.bf.format(bigStr.substring(i % 27), this.buffer, this.offset, 13);
            this.offset = this.bf.format(" ", this.buffer, this.offset, 1);
        }
        this.bp.setOffset(0);
        for (i = 0; i < 100; ++i) {
            String want;
            int ind = i % 27;
            if (ind > 13) {
                ind = 13;
            }
            if ((want = bigStr.substring(i % 27)).length() > 13) {
                want = want.substring(0, 13);
            }
            String s = this.bp.getString(want.length());
            Assert.assertEquals((String)("String:" + i), (Object)want, (Object)s);
            this.bp.skip(1);
        }
    }
}

