/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.ivoa.util.SettingsMatcher;
import net.ivoa.util.ShowError;

public class SettingsFilter {
    public static void filter(String file) throws IOException {
        SettingsFilter.filter(file, false);
    }

    public static void filter(String file, boolean skip) throws IOException {
        if (file != null) {
            String line;
            BufferedReader bf = new BufferedReader(new InputStreamReader(SettingsFilter.getResourceOrFile(file)));
            if (bf == null) {
                throw new FileNotFoundException("File/Resource not found:" + file);
            }
            while ((line = bf.readLine()) != null) {
                if ((line = SettingsMatcher.replaceSettings(line, skip)) == null) continue;
                System.out.println(line);
            }
        } else {
            new ShowError().fail("Null form template");
        }
    }

    static InputStream getResourceOrFile(String name) throws IOException {
        if (new File(name).exists()) {
            return new FileInputStream(name);
        }
        return ClassLoader.getSystemClassLoader().getResourceAsStream(name);
    }
}

