/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class SpecifyROI
implements PlugInFilter,
TextListener,
ItemListener {
    int iX;
    int iY;
    int iXROI;
    int iYROI;
    int iSlice;
    int iWidth;
    int iHeight;
    boolean bAbort;
    ImagePlus imp;
    static boolean oval;
    static boolean centered;
    Vector fields;
    Vector checkboxes;
    int stackSize;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        this.stackSize = imp != null ? imp.getStackSize() : 0;
        return 159;
    }

    public void run(ImageProcessor ip) {
        Roi roi = this.imp.getRoi();
        Rectangle r = roi != null ? roi.getBounds() : ip.getRoi();
        this.iWidth = r.width;
        this.iHeight = r.height;
        this.iXROI = r.x;
        this.iYROI = r.y;
        if (roi == null) {
            this.iWidth /= 2;
            this.iHeight /= 2;
            this.iXROI += this.iWidth / 2;
            this.iYROI += this.iHeight / 2;
        }
        this.iSlice = this.imp.getCurrentSlice();
        if (!this.showDialog()) {
            return;
        }
        if (this.stackSize > 1 && this.iSlice > 0 && this.iSlice <= this.stackSize) {
            this.imp.setSlice(this.iSlice);
        }
        this.drawRoi();
        IJ.register(SpecifyROI.class);
    }

    boolean showDialog() {
        int i;
        boolean rectOrOval;
        Roi roi = this.imp.getRoi();
        boolean bl = rectOrOval = roi != null && (roi.getType() == 0 || roi.getType() == 1);
        if (roi == null || !rectOrOval) {
            this.drawRoi();
        }
        GenericDialog gd = new GenericDialog("Specify");
        gd.addNumericField("Width:", this.iWidth, 0);
        gd.addNumericField("Height:", this.iHeight, 0);
        gd.addNumericField("X Coordinate:", this.iXROI, 0);
        gd.addNumericField("Y Coordinate:", this.iYROI, 0);
        if (this.stackSize > 1) {
            gd.addNumericField("Slice:", this.iSlice, 0);
        }
        gd.addCheckbox("Oval", oval);
        gd.addCheckbox("Centered", centered);
        this.fields = gd.getNumericFields();
        for (i = 0; i < this.fields.size(); ++i) {
            ((TextField)this.fields.elementAt(i)).addTextListener(this);
        }
        this.checkboxes = gd.getCheckboxes();
        for (i = 0; i < this.checkboxes.size(); ++i) {
            ((Checkbox)this.checkboxes.elementAt(i)).addItemListener(this);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (roi == null) {
                this.imp.killRoi();
            } else if (!rectOrOval) {
                this.imp.setRoi(roi);
            }
            return false;
        }
        this.iWidth = (int)gd.getNextNumber();
        this.iHeight = (int)gd.getNextNumber();
        this.iXROI = (int)gd.getNextNumber();
        this.iYROI = (int)gd.getNextNumber();
        if (this.stackSize > 1) {
            this.iSlice = (int)gd.getNextNumber();
        }
        oval = gd.getNextBoolean();
        centered = gd.getNextBoolean();
        return true;
    }

    void drawRoi() {
        if (centered) {
            this.iX = this.iXROI - this.iWidth / 2;
            this.iY = this.iYROI - this.iHeight / 2;
        } else {
            this.iX = this.iXROI;
            this.iY = this.iYROI;
        }
        if (oval) {
            this.imp.setRoi(new OvalRoi(this.iX, this.iY, this.iWidth, this.iHeight, this.imp));
        } else {
            this.imp.setRoi(this.iX, this.iY, this.iWidth, this.iHeight);
        }
    }

    public void textValueChanged(TextEvent e) {
        int width = (int)Tools.parseDouble(((TextField)this.fields.elementAt(0)).getText(), -99.0);
        int height = (int)Tools.parseDouble(((TextField)this.fields.elementAt(1)).getText(), -99.0);
        int x = (int)Tools.parseDouble(((TextField)this.fields.elementAt(2)).getText(), -99.0);
        int y = (int)Tools.parseDouble(((TextField)this.fields.elementAt(3)).getText(), -99.0);
        if (width == -99 || height == -99 || x == -99 || y == -99) {
            return;
        }
        if (width != this.iWidth || height != this.iHeight || x != this.iXROI || y != this.iYROI) {
            this.iWidth = width;
            this.iHeight = height;
            this.iXROI = x;
            this.iYROI = y;
            this.drawRoi();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        block3: {
            boolean centered;
            boolean oval;
            block2: {
                Checkbox cb = (Checkbox)this.checkboxes.elementAt(0);
                oval = cb.getState();
                cb = (Checkbox)this.checkboxes.elementAt(1);
                centered = cb.getState();
                if (oval != SpecifyROI.oval) break block2;
                if (centered == SpecifyROI.centered) break block3;
            }
            SpecifyROI.oval = oval;
            SpecifyROI.centered = centered;
            this.drawRoi();
        }
    }
}

