/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class BinaryFiller
implements PlugInFilter {
    protected boolean backgroundIsZero;

    public int setup(String arg, ImagePlus imp) {
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        ImageStatistics stats = imp.getStatistics();
        if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
            IJ.error("8-bit binary image (0 and 255) required.");
            return 4096;
        }
        this.backgroundIsZero = Prefs.blackBackground;
        if (imp.isInvertedLut()) {
            this.backgroundIsZero = !this.backgroundIsZero;
        }
        return IJ.setupDialog(imp, 1);
    }

    public void run(ImageProcessor ip) {
        int x;
        int y;
        int xe = ip.getWidth();
        int ye = ip.getHeight();
        int[][] pixel = new int[xe][ye];
        if (!this.backgroundIsZero) {
            ip.invert();
        }
        for (y = 0; y < ye; ++y) {
            for (x = 0; x < xe; ++x) {
                pixel[x][y] = ip.getPixel(x, y);
            }
        }
        for (y = 0; y < ye; ++y) {
            if (ip.getPixel(0, y) == 0) {
                ip.putPixel(0, y, 127);
            }
            if (ip.getPixel(xe - 1, y) != 0) continue;
            ip.putPixel(xe - 1, y, 127);
        }
        for (x = 0; x < xe; ++x) {
            if (ip.getPixel(x, 0) == 0) {
                ip.putPixel(x, 0, 127);
            }
            if (ip.getPixel(x, ye - 1) != 0) continue;
            ip.putPixel(x, ye - 1, 127);
        }
        boolean b = true;
        while (b) {
            b = false;
            for (y = 1; y < ye - 1; ++y) {
                for (x = 1; x < xe - 1; ++x) {
                    if (ip.getPixel(x, y) != 0 || ip.getPixel(x, y - 1) != 127 && ip.getPixel(x - 1, y) != 127) continue;
                    ip.putPixel(x, y, 127);
                    b = true;
                }
            }
            for (y = ye - 2; y >= 1; --y) {
                for (x = xe - 2; x >= 1; --x) {
                    if (ip.getPixel(x, y) != 0 || ip.getPixel(x + 1, y) != 127 && ip.getPixel(x, y + 1) != 127) continue;
                    ip.putPixel(x, y, 127);
                    b = true;
                }
            }
        }
        for (y = 0; y < ye; ++y) {
            for (x = 0; x < xe; ++x) {
                if (ip.getPixel(x, y) == 0) {
                    ip.putPixel(x, y, 255);
                    continue;
                }
                ip.putPixel(x, y, pixel[x][y]);
            }
        }
        if (!this.backgroundIsZero) {
            ip.invert();
        }
    }
}

