/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.gui.YesNoCancelDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DragAndDrop
implements PlugIn,
DropTargetListener,
Runnable {
    private Iterator iterator;

    public void run(String arg) {
        ImageJ ij = IJ.getInstance();
        ij.setDropTarget(null);
        DropTarget dropTarget = new DropTarget(ij, this);
    }

    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(1);
        try {
            Transferable t = dtde.getTransferable();
            this.iterator = null;
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
                this.iterator = ((List)data).iterator();
            } else {
                DataFlavor[] flavors = t.getTransferDataFlavors();
                for (int i = 0; i < flavors.length; ++i) {
                    String tmp;
                    Object ob;
                    if (!flavors[i].getRepresentationClass().equals(String.class) || !((ob = t.getTransferData(flavors[i])) instanceof String)) continue;
                    String s = ob.toString().trim();
                    BufferedReader br = new BufferedReader(new StringReader(s));
                    ArrayList<File> list = new ArrayList<File>();
                    while (null != (tmp = br.readLine())) {
                        if ((tmp = URLDecoder.decode(tmp, "UTF-8")).startsWith("file://")) {
                            tmp = tmp.substring(7);
                        }
                        list.add(new File(tmp));
                    }
                    this.iterator = list.iterator();
                    break;
                }
            }
            if (null != this.iterator) {
                Thread thread = new Thread((Runnable)this, "DrawAndDrop");
                thread.setPriority(Math.max(thread.getPriority() - 1, 1));
                thread.start();
            }
        }
        catch (Exception e) {
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(1);
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void run() {
        Iterator iterator = this.iterator;
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.openFile(file);
        }
    }

    private void openFile(File f) {
        try {
            if (null == f) {
                return;
            }
            String tmp = f.getCanonicalPath();
            if (f.exists()) {
                if (f.isDirectory()) {
                    String[] names = f.list();
                    YesNoCancelDialog yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Open folder?", "Open all " + names.length + " images in \"" + f.getName() + "\" as a stack?");
                    if (yn.yesPressed()) {
                        IJ.run("Image Sequence...", "open=" + tmp + "/");
                    } else if (!yn.cancelPressed()) {
                        for (int k = 0; k < names.length; ++k) {
                            IJ.redirectErrorMessages();
                            if (names[k].startsWith(".")) continue;
                            new Opener().open(tmp + "/" + names[k]);
                        }
                    }
                } else {
                    new Opener().openAndAddToRecent(tmp);
                }
            } else {
                IJ.log("File not found: " + tmp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

