/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RoiEncoder {
    String path;
    OutputStream f;
    static final int HEADER_SIZE = 64;
    static final int VERSION = 217;
    final int polygon = 0;
    final int rect = 1;
    final int oval = 2;
    final int line = 3;
    final int freeline = 4;
    final int polyline = 5;
    final int noRoi = 6;
    final int freehand = 7;
    final int traced = 8;
    final int angle = 9;
    final int point = 10;
    byte[] data;

    public RoiEncoder(String path) {
        this.path = path;
    }

    public RoiEncoder(OutputStream f) {
        this.f = f;
    }

    public void write(Roi roi) throws IOException {
        if (this.f != null) {
            this.write(roi, this.f);
        } else {
            this.f = new FileOutputStream(this.path);
            this.write(roi, this.f);
            this.f.close();
        }
    }

    void write(Roi roi, OutputStream f) throws IOException {
        int roiType = roi.getType();
        int type = 1;
        switch (roiType) {
            case 2: {
                type = 0;
                break;
            }
            case 3: {
                type = 7;
                break;
            }
            case 4: {
                type = 8;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 5: {
                type = 3;
                break;
            }
            case 6: {
                type = 5;
                break;
            }
            case 7: {
                type = 4;
                break;
            }
            case 8: {
                type = 9;
                break;
            }
            case 9: {
                type = 1;
                break;
            }
            case 10: {
                type = 10;
                break;
            }
            default: {
                type = 1;
            }
        }
        if (roiType == 9) {
            this.saveShapeRoi(roi, type, f);
            return;
        }
        int n = 0;
        int[] x = null;
        int[] y = null;
        if (roi instanceof PolygonRoi) {
            PolygonRoi p = (PolygonRoi)roi;
            n = p.getNCoordinates();
            x = p.getXCoordinates();
            y = p.getYCoordinates();
        }
        this.data = new byte[64 + n * 4];
        Rectangle r = roi.getBounds();
        this.data[0] = 73;
        this.data[1] = 111;
        this.data[2] = 117;
        this.data[3] = 116;
        this.putShort(4, 217);
        this.data[6] = (byte)type;
        this.putShort(8, r.y);
        this.putShort(10, r.x);
        this.putShort(12, r.y + r.height);
        this.putShort(14, r.x + r.width);
        this.putShort(16, n);
        if (roi instanceof Line) {
            Line l = (Line)roi;
            this.putFloat(18, l.x1);
            this.putFloat(22, l.y1);
            this.putFloat(26, l.x2);
            this.putFloat(30, l.y2);
        }
        if (n > 0) {
            int base1 = 64;
            int base2 = base1 + 2 * n;
            for (int i = 0; i < n; ++i) {
                this.putShort(base1 + i * 2, x[i]);
                this.putShort(base2 + i * 2, y[i]);
            }
        }
        f.write(this.data);
    }

    void saveShapeRoi(Roi roi, int type, OutputStream f) throws IOException {
        float[] shapeArray = ((ShapeRoi)roi).getShapeAsArray();
        if (shapeArray == null) {
            return;
        }
        BufferedOutputStream bout = new BufferedOutputStream(f);
        Rectangle r = roi.getBounds();
        this.data = new byte[64 + shapeArray.length * 4];
        this.data[0] = 73;
        this.data[1] = 111;
        this.data[2] = 117;
        this.data[3] = 116;
        this.putShort(4, 217);
        this.data[6] = (byte)type;
        this.putShort(8, r.y);
        this.putShort(10, r.x);
        this.putShort(12, r.y + r.height);
        this.putShort(14, r.x + r.width);
        this.putInt(36, shapeArray.length);
        int base = 64;
        for (int i = 0; i < shapeArray.length; ++i) {
            this.putFloat(base, shapeArray[i]);
            base += 4;
        }
        bout.write(this.data, 0, this.data.length);
        bout.flush();
    }

    void putShort(int base, int v) {
        this.data[base] = (byte)(v >>> 8);
        this.data[base + 1] = (byte)v;
    }

    void putFloat(int base, float v) {
        int tmp = Float.floatToIntBits(v);
        this.data[base] = (byte)(tmp >> 24);
        this.data[base + 1] = (byte)(tmp >> 16);
        this.data[base + 2] = (byte)(tmp >> 8);
        this.data[base + 3] = (byte)tmp;
    }

    void putInt(int base, int i) {
        this.data[base] = (byte)(i >> 24);
        this.data[base + 1] = (byte)(i >> 16);
        this.data[base + 2] = (byte)(i >> 8);
        this.data[base + 3] = (byte)i;
    }
}

