/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import ij.gui.StackWindow;
import ij.gui.YesNoCancelDialog;
import ij.io.FileSaver;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;

public class ImageWindow
extends Frame
implements FocusListener,
WindowListener,
WindowStateListener,
MouseWheelListener {
    public static final int MIN_WIDTH = 128;
    public static final int MIN_HEIGHT = 32;
    protected ImagePlus imp;
    protected ImageJ ij;
    protected ImageCanvas ic;
    private double initialMagnification = 1.0;
    private int newWidth;
    private int newHeight;
    protected boolean closed;
    private boolean newCanvas;
    private static Rectangle maxWindow;
    Rectangle maxBounds;
    private static final int XINC = 8;
    private static final int YINC = 12;
    private static final int TEXT_GAP = 10;
    private static int xbase;
    private static int ybase;
    private static int xloc;
    private static int yloc;
    private static int count;
    private static boolean centerOnScreen;
    private int textGap;
    public boolean running;
    public boolean running2;

    public ImageWindow(String title) {
        super(title);
        this.textGap = centerOnScreen ? 0 : 10;
    }

    public ImageWindow(ImagePlus imp) {
        this(imp, null);
    }

    public ImageWindow(ImagePlus imp, ImageCanvas ic) {
        super(imp.getTitle());
        int n = this.textGap = centerOnScreen ? 0 : 10;
        if (Prefs.blackCanvas && this.getClass().getName().equals("ij.gui.ImageWindow")) {
            this.setForeground(Color.white);
            this.setBackground(Color.black);
        } else {
            this.setForeground(Color.black);
            this.setBackground(Color.white);
        }
        this.ij = IJ.getInstance();
        this.imp = imp;
        if (ic == null) {
            ic = new ImageCanvas(imp);
            this.newCanvas = true;
        }
        this.ic = ic;
        ImageWindow previousWindow = imp.getWindow();
        this.setLayout(new ImageLayout(ic));
        this.add(ic);
        this.addFocusListener(this);
        this.addWindowListener(this);
        this.addWindowStateListener(this);
        this.addKeyListener(this.ij);
        this.setFocusTraversalKeysEnabled(false);
        if (!(this instanceof StackWindow)) {
            this.addMouseWheelListener(this);
        }
        this.setResizable(true);
        WindowManager.addWindow(this);
        imp.setWindow(this);
        if (previousWindow != null) {
            if (this.newCanvas) {
                this.setLocationAndSize(false);
            } else {
                ic.update(previousWindow.getCanvas());
            }
            Point loc = previousWindow.getLocation();
            this.setLocation(loc.x, loc.y);
            if (!(this instanceof StackWindow)) {
                this.pack();
                this.show();
            }
            boolean unlocked = imp.lockSilently();
            boolean changes = imp.changes;
            imp.changes = false;
            previousWindow.close();
            imp.changes = changes;
            if (unlocked) {
                imp.unlock();
            }
            WindowManager.setCurrentWindow(this);
        } else {
            Image img;
            this.setLocationAndSize(false);
            if (this.ij != null && !IJ.isMacintosh() && (img = this.ij.getIconImage()) != null) {
                try {
                    this.setIconImage(img);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (centerOnScreen) {
                GUI.center(this);
                centerOnScreen = false;
            }
            if (Interpreter.isBatchMode()) {
                WindowManager.setTempCurrentImage(imp);
                Interpreter.addBatchModeImage(imp);
            } else {
                this.show();
            }
        }
    }

    private void setLocationAndSize(boolean updating) {
        double mag2;
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        if (maxWindow == null) {
            maxWindow = this.getMaxWindow();
        }
        if (WindowManager.getWindowCount() <= 1) {
            xbase = -1;
        }
        if (width > ImageWindow.maxWindow.width / 2 && xbase > ImageWindow.maxWindow.x + 5 + 48) {
            xbase = -1;
        }
        if (xbase == -1) {
            count = 0;
            xbase = ImageWindow.maxWindow.x + 5;
            if (width * 2 <= ImageWindow.maxWindow.width) {
                xbase = ImageWindow.maxWindow.x + ImageWindow.maxWindow.width / 2 - width / 2;
            }
            ybase = ImageWindow.maxWindow.y;
            xloc = xbase;
            yloc = ybase;
        }
        int x = xloc;
        int y = yloc;
        xloc += 8;
        yloc += 12;
        if (++count % 6 == 0) {
            xloc = xbase;
            yloc = ybase;
        }
        int sliderHeight = this instanceof StackWindow ? 20 : 0;
        int screenHeight = ImageWindow.maxWindow.height - sliderHeight;
        double mag = 1.0;
        while (((double)(xbase + 32) + (double)width * mag > (double)ImageWindow.maxWindow.width || (double)ybase + (double)height * mag > (double)screenHeight) && (mag2 = ImageCanvas.getLowerZoomLevel(mag)) != mag) {
            mag = mag2;
        }
        if (mag < 1.0) {
            this.initialMagnification = mag;
            this.ic.setDrawingSize((int)((double)width * mag), (int)((double)height * mag));
        }
        this.ic.setMagnification(mag);
        if ((double)y + (double)height * mag > (double)screenHeight) {
            y = ybase;
        }
        if (!updating) {
            this.setLocation(x, y);
        }
        if (Prefs.open100Percent && this.ic.getMagnification() < 1.0) {
            while (this.ic.getMagnification() < 1.0) {
                this.ic.zoomIn(0, 0);
            }
            this.setSize(Math.min(width, ImageWindow.maxWindow.width - x), Math.min(height, screenHeight - y));
            this.validate();
        } else {
            this.pack();
        }
        this.maxBounds = this.getMaximumBounds();
        if (!IJ.isLinux()) {
            this.setMaximizedBounds(this.maxBounds);
        }
    }

    Rectangle getMaxWindow() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxWindow = ge.getMaximumWindowBounds();
        Dimension ijSize = this.ij != null ? this.ij.getSize() : new Dimension(0, 0);
        maxWindow.y += ijSize.height;
        maxWindow.height -= ijSize.height;
        return maxWindow;
    }

    public double getInitialMagnification() {
        return this.initialMagnification;
    }

    public Insets getInsets() {
        int extraHeight;
        Insets insets = super.getInsets();
        double mag = this.ic.getMagnification();
        int extraWidth = (int)((128.0 - (double)this.imp.getWidth() * mag) / 2.0);
        if (extraWidth < 0) {
            extraWidth = 0;
        }
        if ((extraHeight = (int)((32.0 - (double)this.imp.getHeight() * mag) / 2.0)) < 0) {
            extraHeight = 0;
        }
        insets = new Insets(insets.top + this.textGap + extraHeight, insets.left + extraWidth, insets.bottom + extraHeight, insets.right + extraWidth);
        return insets;
    }

    public void drawInfo(Graphics g) {
        if (this.textGap == 0) {
            return;
        }
        String s = "";
        Insets insets = super.getInsets();
        int nSlices = this.imp.getStackSize();
        if (nSlices > 1) {
            ImageStack stack = this.imp.getStack();
            int currentSlice = this.imp.getCurrentSlice();
            s = s + currentSlice + "/" + nSlices;
            boolean isLabel = false;
            String label = stack.getShortSliceLabel(currentSlice);
            if (label != null && label.length() > 0) {
                s = s + " (" + label + ")";
            }
            if (this instanceof StackWindow && this.running2) {
                g.drawString(s, 5, insets.top + 10);
                return;
            }
            s = s + "; ";
        }
        int type = this.imp.getType();
        Calibration cal = this.imp.getCalibration();
        s = cal.pixelWidth != 1.0 || cal.pixelHeight != 1.0 ? s + IJ.d2s((double)this.imp.getWidth() * cal.pixelWidth, 2) + "x" + IJ.d2s((double)this.imp.getHeight() * cal.pixelHeight, 2) + " " + cal.getUnits() + " (" + this.imp.getWidth() + "x" + this.imp.getHeight() + "); " : s + this.imp.getWidth() + "x" + this.imp.getHeight() + " pixels; ";
        int size = this.imp.getWidth() * this.imp.getHeight() * this.imp.getStackSize() / 1024;
        switch (type) {
            case 0: 
            case 3: {
                s = s + "8-bit";
                break;
            }
            case 1: {
                s = s + "16-bit";
                size *= 2;
                break;
            }
            case 2: {
                s = s + "32-bit";
                size *= 4;
                break;
            }
            case 4: {
                s = s + "RGB";
                size *= 4;
            }
        }
        if (this.imp.isInvertedLut()) {
            s = s + " (inverting LUT)";
        }
        if (size >= 10000) {
            s = s + "; " + (int)Math.round((double)size / 1024.0) + "MB";
        } else if (size >= 1024) {
            double size2 = (double)size / 1024.0;
            s = s + "; " + IJ.d2s(size2, (double)((int)size2) == size2 ? 0 : 1) + "MB";
        } else {
            s = s + "; " + size + "K";
        }
        g.drawString(s, 5, insets.top + 10);
    }

    public void paint(Graphics g) {
        this.drawInfo(g);
        Rectangle r = this.ic.getBounds();
        int extraWidth = 128 - r.width;
        int extraHeight = 32 - r.height;
        if (extraWidth <= 0 && extraHeight <= 0 && !IJ.isLinux()) {
            g.drawRect(r.x - 1, r.y - 1, r.width + 1, r.height + 1);
        }
    }

    public boolean close() {
        boolean isRunning = this.running || this.running2;
        this.running2 = false;
        this.running = false;
        if (isRunning) {
            IJ.wait(500);
        }
        if (this.ij == null || IJ.getApplet() != null || Interpreter.isBatchMode() || IJ.macroRunning()) {
            this.imp.changes = false;
        }
        if (this.imp.changes) {
            FileSaver fs;
            String name = this.imp.getTitle();
            String msg = name.length() > 22 ? "Save changes to\n\"" + name + "\"?" : "Save changes to \"" + name + "\"?";
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "ImageJ", msg);
            if (d.cancelPressed()) {
                return false;
            }
            if (d.yesPressed() && !(fs = new FileSaver(this.imp)).save()) {
                return false;
            }
        }
        this.closed = true;
        if (WindowManager.getWindowCount() == 0) {
            xloc = 0;
            yloc = 0;
        }
        WindowManager.removeWindow(this);
        this.setVisible(false);
        if (this.ij != null && this.ij.quitting()) {
            return true;
        }
        this.dispose();
        this.imp.flush();
        return true;
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    void setImagePlus(ImagePlus imp) {
        this.imp = imp;
        this.repaint();
    }

    public void updateImage(ImagePlus imp) {
        if (imp != this.imp) {
            throw new IllegalArgumentException("imp!=this.imp");
        }
        this.imp = imp;
        this.ic.updateImage(imp);
        this.setLocationAndSize(true);
        this.pack();
        this.repaint();
    }

    public ImageCanvas getCanvas() {
        return this.ic;
    }

    static ImagePlus getClipboard() {
        return ImagePlus.getClipboard();
    }

    public Rectangle getMaximumBounds() {
        int wHeight;
        int wWidth;
        double maxHeight;
        double maxWidth;
        double mAspectRatio;
        double iAspectRatio;
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        maxWindow = this.getMaxWindow();
        Insets insets = this.getInsets();
        int extraHeight = insets.top + insets.bottom;
        if (this instanceof StackWindow) {
            extraHeight += 25;
        }
        if ((iAspectRatio = (double)width / (double)height) >= (mAspectRatio = (maxWidth = (double)ImageWindow.maxWindow.width) / (maxHeight = (double)(ImageWindow.maxWindow.height - extraHeight)))) {
            wWidth = (int)maxWidth;
            wHeight = (int)(maxWidth / iAspectRatio);
        } else {
            wHeight = (int)maxHeight;
            wWidth = (int)(maxHeight * iAspectRatio);
        }
        int xloc = (int)(maxWidth - (double)wWidth) / 2;
        if (xloc < 0) {
            xloc = 0;
        }
        return new Rectangle(xloc, ImageWindow.maxWindow.y, wWidth, wHeight + extraHeight);
    }

    public void maximize() {
        if (this.maxBounds == null) {
            return;
        }
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        Insets insets = this.getInsets();
        int extraHeight = insets.top + insets.bottom + 5;
        if (this instanceof StackWindow) {
            extraHeight += 25;
        }
        double mag = Math.floor((double)(this.maxBounds.height - extraHeight) * 100.0 / (double)height) / 100.0;
        this.ic.setMagnification2(mag);
        this.ic.setSrcRect(new Rectangle(0, 0, width, height));
        this.ic.setDrawingSize((int)((double)width * mag), (int)((double)height * mag));
        this.validate();
    }

    public void minimize() {
        this.ic.unzoom();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void focusGained(FocusEvent e) {
        if (!Interpreter.isBatchMode() && this.ij != null && !this.ij.quitting()) {
            WindowManager.setCurrentWindow(this);
        }
    }

    public void windowActivated(WindowEvent e) {
        boolean quitting;
        ImageJ ij = IJ.getInstance();
        boolean bl = quitting = ij != null && ij.quitting();
        if (IJ.isMacintosh() && ij != null && !quitting) {
            IJ.wait(10);
            this.setMenuBar(Menus.getMenuBar());
        }
        this.imp.setActivated();
        if (!(this.closed || quitting || Interpreter.isBatchMode())) {
            WindowManager.setCurrentWindow(this);
        }
    }

    public void windowClosing(WindowEvent e) {
        if (this.closed) {
            return;
        }
        if (this.ij != null) {
            WindowManager.setCurrentWindow(this);
            IJ.doCommand("Close");
        } else {
            this.setVisible(false);
            this.dispose();
            WindowManager.removeWindow(this);
        }
    }

    public void windowStateChanged(WindowEvent e) {
        int oldState = e.getOldState();
        int newState = e.getNewState();
        if ((oldState & 6) == 0 && (newState & 6) != 0) {
            this.maximize();
        } else if ((oldState & 6) != 0 && (newState & 6) == 0) {
            this.minimize();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        int rotation = event.getWheelRotation();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        Rectangle srcRect = this.ic.getSrcRect();
        int xstart = srcRect.x;
        int ystart = srcRect.y;
        if (IJ.spaceBarDown() || srcRect.height == height) {
            srcRect.x += rotation * Math.max(width / 200, 1);
            if (srcRect.x < 0) {
                srcRect.x = 0;
            }
            if (srcRect.x + srcRect.width > width) {
                srcRect.x = width - srcRect.width;
            }
        } else {
            srcRect.y += rotation * Math.max(height / 200, 1);
            if (srcRect.y < 0) {
                srcRect.y = 0;
            }
            if (srcRect.y + srcRect.height > height) {
                srcRect.y = height - srcRect.height;
            }
        }
        if (srcRect.x != xstart || srcRect.y != ystart) {
            this.ic.repaint();
        }
    }

    public void copy(boolean cut) {
        this.imp.copy(cut);
    }

    public void paste() {
        this.imp.paste();
    }

    public void mouseMoved(int x, int y) {
        this.imp.mouseMoved(x, y);
    }

    public String toString() {
        return this.imp.getTitle();
    }

    public static void centerNextImage() {
        centerOnScreen = true;
    }

    static {
        xbase = -1;
    }
}

