/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.starlink.util.SourceReader;
import uk.ac.starlink.util.gui.StoreFileUtils;

public class StoreConfiguration
extends AbstractTableModel {
    protected Document document = null;
    protected Element rootElement = null;
    protected String applicationName = null;
    protected String storeName = null;

    public StoreConfiguration(String applicationName, String storeName) {
        this.applicationName = applicationName;
        this.storeName = storeName;
        this.initFromBackingStore();
    }

    public StoreConfiguration(InputStream inputStream) {
        this.initFromBackingStore(inputStream);
    }

    public void initFromBackingStore(InputStream inputStream) {
        StreamSource saxSource = new StreamSource(inputStream);
        try {
            this.document = (Document)new SourceReader().getDOM(saxSource);
        }
        catch (Exception e) {
            this.document = null;
            e.printStackTrace();
        }
        if (this.document == null) {
            this.createEmptyDoc();
        } else {
            this.rootElement = this.document.getDocumentElement();
        }
        this.fireTableDataChanged();
    }

    public void initFromBackingStore() {
        File backingStore = StoreFileUtils.getConfigFile(this.applicationName, this.storeName);
        if (backingStore.canRead()) {
            try {
                FileInputStream inputStream = new FileInputStream(backingStore);
                this.initFromBackingStore(inputStream);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            this.createEmptyDoc();
        }
    }

    protected void createEmptyDoc() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.document = builder.newDocument();
            this.rootElement = this.document.createElement("configs");
            this.document.appendChild(this.rootElement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List getChildElements(Element element) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Node> elementList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            elementList.add(nodeList.item(i));
        }
        return elementList;
    }

    public int getCount() {
        return StoreConfiguration.getChildElements(this.rootElement).size();
    }

    public Element getState(int index) {
        return (Element)StoreConfiguration.getChildElements(this.rootElement).get(index);
    }

    public Element reGetState(int index) {
        Element parent = (Element)StoreConfiguration.getChildElements(this.rootElement).get(index);
        List children = StoreConfiguration.getChildElements(parent);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            parent.removeChild((Element)children.get(i));
        }
        return parent;
    }

    public String getDescription(int index) {
        return this.getState(index).getAttribute("description");
    }

    public void setDescription(int index, String value) {
        this.getState(index).getAttributeNode("description").setValue(value);
        this.fireTableRowsUpdated(index, index);
    }

    public String getDateStamp(int index) {
        return this.getState(index).getAttribute("date-stamp");
    }

    public void setDateStamp(int index) {
        this.getState(index).getAttributeNode("date-stamp").setValue(new Date().toString());
        this.fireTableRowsUpdated(index, index);
    }

    public void stateCompleted(Element newState) {
        this.rootElement.appendChild(newState);
        this.fireTableDataChanged();
    }

    public Element newState(String elementName, String description) {
        Element newRoot = this.document.createElement(elementName);
        newRoot.setAttribute("description", description);
        newRoot.setAttribute("date-stamp", new Date().toString());
        return newRoot;
    }

    public void removeState(int index) {
        Element child = this.getState(index);
        this.rootElement.removeChild(child);
        this.fireTableRowsDeleted(index, index);
    }

    public void writeToBackingStore() {
        if (this.applicationName == null || this.storeName == null) {
            return;
        }
        File backingStore = StoreFileUtils.getConfigFile(this.applicationName, this.storeName);
        FileOutputStream f = null;
        try {
            f = new FileOutputStream(backingStore);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        StreamResult out = new StreamResult(f);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = null;
        try {
            t = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return;
        }
        t.setOutputProperty("encoding", "ISO-8859-1");
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("standalone", "yes");
        try {
            t.transform(new DOMSource(this.document), out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getRowCount() {
        return this.getCount();
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.getDescription(row);
        }
        return this.getDateStamp(row);
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Description";
        }
        return "Date";
    }

    public void setValueAt(Object value, int row, int column) {
        this.setDescription(row, (String)value);
    }

    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }
}

