/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.starlink.util.ProxySetup;
import uk.ac.starlink.util.gui.GridBagLayouter;
import uk.ac.starlink.util.images.ImageHolder;

public class ProxySetupFrame
extends JFrame {
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenu fileMenu = new JMenu();
    protected JMenuItem closeFileMenu = new JMenuItem();
    protected JCheckBox needProxy = new JCheckBox();
    protected JTextField hostName = new JTextField(15);
    protected JTextField portNumber = new JTextField(15);
    protected JTextField nonHostNames = new JTextField(15);
    protected JButton acceptButton = new JButton();
    protected JButton cancelButton = new JButton();
    private ProxySetup proxySetup = ProxySetup.getInstance();

    public ProxySetupFrame() {
        this.initUI();
        this.initMenus();
        this.initFrame();
        this.matchToProperties();
    }

    protected void initUI() {
        JComponent pane = (JComponent)this.getContentPane();
        GridBagLayouter layouter = new GridBagLayouter(pane, 3);
        pane.setBorder(BorderFactory.createTitledBorder("Configure your proxy server:"));
        JLabel needLabel = new JLabel("Use proxy server:");
        layouter.add((Component)needLabel, false);
        layouter.add((Component)this.needProxy, true);
        this.needProxy.setToolTipText("Select if your connection to the internet needs a proxy server");
        this.needProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxySetupFrame.this.checkEntryStates();
            }
        });
        JLabel hostLabel = new JLabel("Proxy server:");
        layouter.add((Component)hostLabel, false);
        layouter.add((Component)this.hostName, true);
        this.hostName.setToolTipText("Name of proxy server, e.g. wwwcache.mydomain");
        JLabel portLabel = new JLabel("Port:");
        layouter.add((Component)portLabel, false);
        layouter.add((Component)this.portNumber, true);
        this.portNumber.setToolTipText("Port number of proxy server, e.g. 8080");
        JLabel nonHostsLabel = new JLabel("Do not proxy:");
        layouter.add((Component)nonHostsLabel, false);
        layouter.add((Component)this.nonHostNames, true);
        this.nonHostNames.setToolTipText("List of names to not proxy, e.g, *.mydomain|*.other.domain|localhost");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.acceptButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.acceptButton.setToolTipText("Press to accept changes and close window");
        this.cancelButton.setToolTipText("Press to cancel changes and close window");
        layouter.add((Component)buttonPanel, true);
    }

    protected void initFrame() {
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setTitle("Set proxy server");
        this.setVisible(true);
    }

    protected void initMenus() {
        this.setJMenuBar(this.menuBar);
        this.fileMenu.setText("File");
        this.fileMenu.setMnemonic(70);
        this.menuBar.add(this.fileMenu);
        ImageIcon cancelImage = new ImageIcon(ImageHolder.class.getResource("close.gif"));
        CancelAction cancelAction = new CancelAction("Cancel", cancelImage);
        this.fileMenu.add(cancelAction);
        this.cancelButton.setAction(cancelAction);
        ImageIcon acceptImage = new ImageIcon(ImageHolder.class.getResource("accept.gif"));
        AcceptAction acceptAction = new AcceptAction("Accept", acceptImage);
        this.fileMenu.add(acceptAction);
        this.acceptButton.setAction(acceptAction);
    }

    protected void matchToProperties() {
        String nonProxyHosts;
        String proxyPort;
        this.needProxy.setSelected(this.proxySetup.isProxySet());
        String proxyHost = this.proxySetup.getProxyHost();
        if (proxyHost != null) {
            this.hostName.setText(proxyHost);
        }
        if ((proxyPort = this.proxySetup.getProxyPort()) != null) {
            this.portNumber.setText(proxyPort);
        }
        if ((nonProxyHosts = this.proxySetup.getNonProxyHosts()) != null) {
            this.nonHostNames.setText(nonProxyHosts);
        }
        this.checkEntryStates();
    }

    protected void matchToInterface() {
        this.proxySetup.setProxySet(this.needProxy.isSelected());
        this.proxySetup.setProxyHost(this.hostName.getText());
        this.proxySetup.setProxyPort(this.portNumber.getText());
        this.proxySetup.setNonProxyHosts(this.nonHostNames.getText());
        this.checkEntryStates();
    }

    protected void checkEntryStates() {
        this.hostName.setEnabled(this.needProxy.isSelected());
        this.nonHostNames.setEnabled(this.needProxy.isSelected());
        this.portNumber.setEnabled(this.needProxy.isSelected());
    }

    protected void closeWindowEvent(boolean accept) {
        if (accept) {
            this.matchToInterface();
        } else {
            this.matchToProperties();
        }
        this.proxySetup.store();
        this.hide();
    }

    public static void restore(ProxySetupFrame target) {
        ProxySetup.getInstance().restore();
        if (target != null) {
            target.matchToProperties();
        }
    }

    public static void store(ProxySetupFrame target) {
        if (target != null) {
            target.matchToInterface();
        }
        ProxySetup.getInstance().store();
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction(String name, Icon icon) {
            super(name, icon);
        }

        public void actionPerformed(ActionEvent ae) {
            ProxySetupFrame.this.closeWindowEvent(false);
        }
    }

    protected class AcceptAction
    extends AbstractAction {
        public AcceptAction(String name, Icon icon) {
            super(name, icon);
        }

        public void actionPerformed(ActionEvent ae) {
            ProxySetupFrame.this.closeWindowEvent(true);
        }
    }
}

