/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class FileNameListCellRenderer
extends DefaultListCellRenderer {
    protected JComboBox parent = null;
    protected static final String ELLIPSIS = "...";

    public FileNameListCellRenderer() {
    }

    public FileNameListCellRenderer(JComboBox parent) {
        this.parent = parent;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.parent != null) {
            int boxWidth = this.parent.getWidth();
            int listWidth = list.getFixedCellWidth();
            if (listWidth != boxWidth && boxWidth != 0) {
                list.setFixedCellWidth(boxWidth);
            }
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value instanceof String) {
            this.setText((String)value);
        } else {
            this.setText(value.toString());
        }
        return this;
    }

    public void paintComponent(Graphics g) {
        String text = this.getText();
        this.setText(" ");
        super.paintComponent(g);
        this.setText(text);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setPaint(this.getForeground());
        FontMetrics fm = g2D.getFontMetrics();
        int x = 0;
        int y = fm.getMaxAscent() + 1;
        int width = fm.stringWidth(text);
        int compWidth = 0;
        compWidth = this.parent != null ? this.parent.getWidth() - this.parent.getInsets().left - this.parent.getInsets().right : this.getWidth();
        if (width > compWidth) {
            int nChars;
            int totalWidth = fm.stringWidth(ELLIPSIS);
            int length = text.length();
            Object buf = null;
            for (nChars = 0; nChars < length; ++nChars) {
                if ((totalWidth += fm.charWidth(text.charAt(nChars))) < compWidth) continue;
                --nChars;
                if (this.parent == null) break;
                nChars -= 2;
                break;
            }
            text = ELLIPSIS + text.substring(length - nChars, length);
        }
        g2D.drawString(text, x, y);
    }
}

