/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class BasicFileFilter
extends FileFilter
implements FilenameFilter {
    private Hashtable filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public BasicFileFilter() {
    }

    public BasicFileFilter(String extension) {
        this(extension, null);
    }

    public BasicFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public BasicFileFilter(String[] filters) {
        this(filters, null);
    }

    public BasicFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = BasicFileFilter.getExtension(f);
            if (extension != null && this.filters.get(extension) != null) {
                return true;
            }
        }
        return false;
    }

    public static String getExtension(String name) {
        int i;
        if (name != null && (i = name.lastIndexOf(46)) > 0 && i < name.length() - 1) {
            return name.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public static String getExtension(File f) {
        if (f != null) {
            return BasicFileFilter.getExtension(f.getName());
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description;
                this.fullDescription = this.description != null ? this.fullDescription + " (" : " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + " ." + (String)extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", ." + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public boolean accept(File dir, String name) {
        if (dir != null) {
            String extension = BasicFileFilter.getExtension(name);
            if (extension != null && this.filters.get(extension) != null) {
                return true;
            }
            File maybeDir = new File(dir, name);
            if (maybeDir.isDirectory()) {
                return true;
            }
        }
        return false;
    }
}

