/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.PrintStream;
import java.util.LinkedList;

public class XmlWriter {
    private PrintStream out_;
    private int level_;
    private LinkedList stack_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XmlWriter() {
        this(System.out);
    }

    public XmlWriter(PrintStream out) {
        this.out_ = out;
        this.stack_ = new LinkedList();
    }

    public void writeDeclaration() {
        this.out_.println("<?xml version='1.0' encoding='utf-8'?>");
    }

    public void startElement(String elName) {
        this.startElement(elName, "");
    }

    public void startElement(String elName, String attList) {
        this.out_.println(this.getIndent(this.level_++) + "<" + elName + attList + ">");
        this.stack_.add(elName);
        if (!$assertionsDisabled && this.level_ != this.stack_.size()) {
            throw new AssertionError();
        }
    }

    public void endElement(String elName) {
        String openElName = (String)this.stack_.removeLast();
        if (!openElName.equals(elName)) {
            throw new IllegalArgumentException("Start/end tag mismatch: " + elName + " != " + openElName);
        }
        this.out_.println(this.getIndent(--this.level_) + "</" + elName + ">");
    }

    public void addElement(String elName, String attList, String content) {
        if (content != null && content.trim().length() > 0) {
            this.out_.println(this.getIndent(this.level_) + "<" + elName + attList + ">" + content + "</" + elName + ">");
        } else {
            this.out_.println(this.getIndent(this.level_) + "<" + elName + attList + "/>");
        }
    }

    public void print(String txt) {
        this.out_.print(txt);
    }

    public void setOut(PrintStream out) {
        this.out_ = out;
    }

    public void println(String txt) {
        this.out_.println(txt);
    }

    public int getLevel() {
        return this.level_;
    }

    public static String formatAttribute(String name, String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        return ' ' + name + '=' + '\"' + value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;") + '\"';
    }

    public static String formatText(String text) {
        int leng = text.length();
        StringBuffer sbuf = new StringBuffer(leng);
        block5: for (int i = 0; i < leng; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sbuf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block5;
                }
                default: {
                    sbuf.append(c);
                }
            }
        }
        return sbuf.toString();
    }

    public String getIndent(int level) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            sbuf.append("  ");
        }
        return sbuf.toString();
    }

    static {
        $assertionsDisabled = !XmlWriter.class.desiredAssertionStatus();
    }
}

