/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.util.CustomURLStreamHandlerFactory;

public class URLUtils {
    private static final Logger logger_;
    private static URL defaultContext;
    private static final Pattern FILE_URL_REGEX;
    static final /* synthetic */ boolean $assertionsDisabled;

    private URLUtils() {
    }

    public static URL makeURL(String location) {
        if (location == null || location.trim().length() == 0) {
            return null;
        }
        try {
            return new URL(location);
        }
        catch (MalformedURLException e) {
            try {
                URI uri = new File(location).toURI();
                return uri.toURL();
            }
            catch (MalformedURLException e2) {
                throw URLUtils.protestFileProtocolIsLegal(e2);
            }
        }
        catch (SecurityException e) {
            try {
                return new URL("file:" + location);
            }
            catch (MalformedURLException e2) {
                throw URLUtils.protestFileProtocolIsLegal(e2);
            }
        }
    }

    public static URL makeURL(String context, String location) {
        URL contextURL = context == null || context.trim().length() == 0 ? defaultContext : URLUtils.makeURL(context);
        try {
            return new URL(contextURL, location);
        }
        catch (MalformedURLException e) {
            try {
                return new URL(contextURL, URLUtils.makeURL(location).toString());
            }
            catch (MalformedURLException e2) {
                return URLUtils.makeURL(location);
            }
        }
    }

    private static AssertionError protestFileProtocolIsLegal(MalformedURLException e) {
        AssertionError ae = new AssertionError((Object)"Illegal \"file:\" protocol in URL??");
        ((Throwable)((Object)ae)).initCause(e);
        return ae;
    }

    public static URI urlToUri(URL url) throws MalformedURLException {
        if (url == null) {
            return null;
        }
        try {
            return new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), url.getRef());
        }
        catch (URISyntaxException e) {
            MalformedURLException newEx = new MalformedURLException("URL " + url + " was malformed");
            newEx.initCause(e);
            throw newEx;
        }
    }

    public static URL makeFileURL(File file) {
        try {
            return URLUtils.fixURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
    }

    public static URL fixURL(URL url) {
        Matcher matcher = FILE_URL_REGEX.matcher(url.toString());
        if (matcher.matches()) {
            String scheme = matcher.group(1);
            String slashes = matcher.group(2);
            String path = matcher.group(3);
            if (!$assertionsDisabled && !"file:".equals(scheme)) {
                throw new AssertionError();
            }
            try {
                switch (slashes.length()) {
                    case 0: {
                        return URLUtils.fixURL(new File(path).getAbsoluteFile().toURI().toURL());
                    }
                    case 1: {
                        return new URL(scheme + "//localhost" + slashes + path);
                    }
                    case 2: {
                        return url;
                    }
                }
                return url;
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return url;
    }

    public static boolean sameResource(URL url1, URL url2) {
        if (url1 == null && url2 == null) {
            return true;
        }
        if (url1 == null || url2 == null) {
            return false;
        }
        if (url1.equals(url2)) {
            return true;
        }
        if (url1.getProtocol().equals("file") && url2.getProtocol().equals("file")) {
            String[] strings = new String[]{url1.toString(), url2.toString()};
            for (int i = 0; i < 2; ++i) {
                strings[i] = strings[i].replaceFirst("^file:/*(localhost)?/*", "");
            }
            return strings[0].equals(strings[1]);
        }
        return false;
    }

    public static File urlToFile(String url) {
        URL u;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (u.getProtocol().equals("file") && u.getRef() == null && u.getQuery() == null) {
            String path = u.getPath();
            try {
                path = URLDecoder.decode(path);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            String filename = File.separatorChar == '/' ? path : path.replace('/', File.separatorChar);
            return new File(filename);
        }
        return null;
    }

    public static void installCustomHandlers() {
        boolean hasPkgProp;
        String pkgProp = "java.protocol.handler.pkgs";
        try {
            hasPkgProp = System.getProperty(pkgProp, "").length() > 0;
        }
        catch (SecurityException e) {
            hasPkgProp = false;
        }
        if (hasPkgProp) {
            logger_.config(pkgProp + " is set - don't further configure " + "URL protocol handlers");
            return;
        }
        HashMap<String, String> handlerMap = new HashMap<String, String>();
        String[] protos = new String[]{"ivo", "myspace"};
        for (int i = 0; i < protos.length; ++i) {
            String proto = protos[i];
            handlerMap.put(proto, "uk.ac.starlink.astrogrid.protocols." + proto + ".Handler");
        }
        CustomURLStreamHandlerFactory fact = new CustomURLStreamHandlerFactory(handlerMap);
        try {
            URL.setURLStreamHandlerFactory(fact);
            logger_.config("Set up URL custom protocol handlers " + Arrays.asList(protos));
        }
        catch (Throwable e) {
            logger_.warning("Can't set custom URL protocol handlers: " + e);
        }
    }

    static {
        $assertionsDisabled = !URLUtils.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.util");
        try {
            defaultContext = new URL("file:.");
        }
        catch (MalformedURLException e) {
            throw URLUtils.protestFileProtocolIsLegal(e);
        }
        catch (SecurityException e) {
            defaultContext = null;
        }
        FILE_URL_REGEX = Pattern.compile("(file:)(/*)(.*)");
    }
}

