/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class SuperJar {
    private static Set doneJars = new HashSet();
    private static JarOutputStream jarOut;
    private static PrintStream logStrm;
    private static Set jarExcludes;
    private static Set fileExcludes;
    private static Set dirExcludes;

    public static void main(String[] args) throws IOException {
        String usage = "SuperJar [-o out-jar]\n         [-xjar jar [-xjar jar] ..]\n         [-xent entry [-xent entry] ..]\n         jarfile [jarfile ..]";
        ArrayList<String> arglist = new ArrayList<String>(Arrays.asList(args));
        ArrayList<String> jarlist = new ArrayList<String>();
        File outfile = new File("superjar.jar");
        Iterator it = arglist.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.startsWith("-h")) {
                logStrm.println(usage);
                System.exit(0);
                continue;
            }
            if (arg.equals("-o")) {
                it.remove();
                outfile = new File((String)it.next());
                it.remove();
                continue;
            }
            if (arg.equals("-x") || arg.equals("-xjar")) {
                it.remove();
                jarExcludes.add((String)it.next());
                it.remove();
                continue;
            }
            if (arg.equals("-xent")) {
                it.remove();
                String name = (String)it.next();
                it.remove();
                (name.endsWith("/") ? dirExcludes : fileExcludes).add(name);
                continue;
            }
            jarlist.add(arg);
        }
        if (jarlist.size() == 0) {
            logStrm.println(usage);
            System.exit(1);
        }
        FileInputStream istrm = new FileInputStream((String)jarlist.get(0));
        JarInputStream primaryJar = new JarInputStream((InputStream)istrm, false);
        Manifest manifest = primaryJar.getManifest();
        ((InputStream)istrm).close();
        Attributes mainAtts = manifest.getMainAttributes();
        Iterator<Map.Entry<Object, Object>> it2 = mainAtts.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry<Object, Object> entry = it2.next();
            if (entry.getKey().equals(Attributes.Name.CLASS_PATH)) {
                it2.remove();
                continue;
            }
            logStrm.println(entry.getKey() + ": " + entry.getValue());
        }
        BufferedOutputStream ostrm = new BufferedOutputStream(new FileOutputStream(outfile));
        jarOut = new JarOutputStream((OutputStream)ostrm, manifest);
        Iterator it3 = jarlist.iterator();
        while (it3.hasNext()) {
            SuperJar.processJar(new File((String)it3.next()), 0);
        }
        jarOut.close();
    }

    private static void processJar(File jfile, int level) throws IOException {
        Attributes atts;
        String classpath;
        JarEntry jent;
        if (jfile.isDirectory()) {
            throw new IllegalArgumentException(jfile + " is a directory, " + "only jarfiles allowed");
        }
        String name = jfile.toString();
        String cname = jfile.getCanonicalPath();
        if (doneJars.contains(cname)) {
            logStrm.println("        Duplicate: " + name);
            return;
        }
        doneJars.add(cname);
        logStrm.println(SuperJar.levelPrefix(level) + name);
        BufferedInputStream istrm = new BufferedInputStream(new FileInputStream(jfile));
        JarInputStream jstrm = new JarInputStream((InputStream)istrm, false);
        Manifest manifest = jstrm.getManifest();
        byte[] buffer = new byte[4096];
        while ((jent = jstrm.getNextJarEntry()) != null) {
            if (!SuperJar.excludeEntry(jent)) {
                int nbyte;
                jarOut.putNextEntry(jent);
                while ((nbyte = jstrm.read(buffer)) >= 0) {
                    jarOut.write(buffer, 0, nbyte);
                }
            }
            jstrm.closeEntry();
        }
        jstrm.close();
        if (manifest != null && (classpath = (atts = manifest.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) != null && classpath.trim().length() > 0) {
            File dir = jfile.getParentFile();
            String[] cpents = classpath.trim().split(" +");
            for (int i = 0; i < cpents.length; ++i) {
                File jf = new File(dir, cpents[i]);
                if (SuperJar.excludeJar(jf)) {
                    logStrm.println(SuperJar.levelPrefix(level) + "        Excluding: " + jf);
                    continue;
                }
                SuperJar.processJar(jf, level + 1);
            }
        }
    }

    private static boolean excludeJar(File file) throws IOException {
        String cname = file.getCanonicalPath();
        Iterator it = jarExcludes.iterator();
        while (it.hasNext()) {
            String excl = (String)it.next();
            if (!cname.equals(excl) && !cname.endsWith(File.separator + excl)) continue;
            return true;
        }
        return false;
    }

    private static boolean excludeEntry(JarEntry entry) {
        if (entry.isDirectory()) {
            return true;
        }
        String name = entry.getName();
        if (fileExcludes.contains(name)) {
            return true;
        }
        Iterator it = dirExcludes.iterator();
        while (it.hasNext()) {
            String exclude = (String)it.next();
            if (!name.startsWith(exclude)) continue;
            return true;
        }
        return false;
    }

    private static String levelPrefix(int level) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            sbuf.append("");
        }
        return sbuf.toString();
    }

    static {
        logStrm = System.err;
        jarExcludes = new HashSet();
        fileExcludes = new HashSet();
        dirExcludes = new HashSet();
        dirExcludes.add("META-INF/");
    }
}

