/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.util.prefs.Preferences;

public class ProxySetup {
    private static ProxySetup instance = null;
    private static Preferences prefs = Preferences.userNodeForPackage(ProxySetup.class);
    private static final String PROXYSET = "http.proxySet";
    private static final String PROXYHOST = "http.proxyHost";
    private static final String PROXYPORT = "http.proxyPort";
    private static final String NONPROXYHOSTS = "http.nonProxyHosts";

    public static ProxySetup getInstance() {
        if (instance == null) {
            instance = new ProxySetup();
        }
        return instance;
    }

    private ProxySetup() {
        this.restore();
    }

    public boolean isProxySet() {
        String proxySet = System.getProperty(PROXYSET);
        return proxySet != null && proxySet.compareToIgnoreCase("true") == 0;
    }

    public void setProxySet(boolean set) {
        prefs.putBoolean(PROXYSET, set);
        System.setProperty(PROXYSET, "" + set);
    }

    public String getProxyHost() {
        return System.getProperty(PROXYHOST);
    }

    public void setProxyHost(String host) {
        prefs.put(PROXYHOST, host);
        System.setProperty(PROXYHOST, host);
    }

    public String getProxyPort() {
        return System.getProperty(PROXYPORT);
    }

    public void setProxyPort(String port) {
        prefs.put(PROXYPORT, port);
        System.setProperty(PROXYPORT, port);
    }

    public String getNonProxyHosts() {
        return System.getProperty(NONPROXYHOSTS);
    }

    public void setNonProxyHosts(String nohosts) {
        prefs.put(NONPROXYHOSTS, nohosts);
        System.setProperty(NONPROXYHOSTS, nohosts);
    }

    public void restore() {
        String nonProxyHosts;
        String proxyPort;
        String proxyHost;
        String proxySet = prefs.get(PROXYSET, null);
        if (proxySet != null) {
            System.setProperty(PROXYSET, proxySet);
        }
        if ((proxyHost = prefs.get(PROXYHOST, null)) != null) {
            System.setProperty(PROXYHOST, proxyHost);
        }
        if ((proxyPort = prefs.get(PROXYPORT, null)) != null) {
            System.setProperty(PROXYPORT, proxyPort);
        }
        if ((nonProxyHosts = prefs.get(NONPROXYHOSTS, null)) != null) {
            System.setProperty(NONPROXYHOSTS, nonProxyHosts);
        }
    }

    public void store() {
        String nonProxyHosts;
        String proxyPort;
        String proxyHost;
        String proxySet = System.getProperty(PROXYSET);
        if (proxySet != null) {
            prefs.put(PROXYSET, proxySet);
        }
        if ((proxyHost = this.getProxyHost()) != null) {
            prefs.put(PROXYHOST, proxyHost);
        }
        if ((proxyPort = this.getProxyPort()) != null) {
            prefs.put(PROXYPORT, proxyPort);
        }
        if ((nonProxyHosts = this.getNonProxyHosts()) != null) {
            prefs.put(NONPROXYHOSTS, nonProxyHosts);
        }
        try {
            prefs.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

