/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private static final int WOULD_BLOCK = -2;
    private static int[] table;
    private int prev;
    private int savedPrev;
    private int state = 1;
    private int savedState;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Base64InputStream(InputStream in) {
        super(in);
    }

    public long skip(long n) throws IOException {
        long count;
        for (count = 0L; count < n && this.read() != -1; ++count) {
        }
        return count;
    }

    private int read(boolean block) throws IOException {
        int ret = 0;
        boolean done = false;
        block6: while (!done) {
            if (this.in.available() < 1 && !block) {
                return -2;
            }
            int cur = this.in.read();
            switch (this.state) {
                case 1: {
                    if (cur == -1) {
                        return -1;
                    }
                    if (cur == 61) {
                        throw new IOException("Invalid pad character");
                    }
                    if (table[cur] == -1) continue block6;
                    this.prev = cur;
                    this.state = 2;
                    continue block6;
                }
                case 2: {
                    if (cur == -1) {
                        throw new EOFException("Unexpected end-of-file");
                    }
                    if (cur == 61) {
                        throw new IOException("Invalid pad character");
                    }
                    if (table[cur] == -1) continue block6;
                    ret = table[this.prev] << 2 | (table[cur] & 0x30) >> 4;
                    this.prev = cur;
                    this.state = 3;
                    done = true;
                    continue block6;
                }
                case 3: {
                    if (cur == -1) {
                        throw new EOFException("Unexpected end-of-file");
                    }
                    if (cur == 61) {
                        return -1;
                    }
                    if (table[cur] == -1) continue block6;
                    ret = (table[this.prev] & 0xF) << 4 | (table[cur] & 0x3C) >> 2;
                    this.prev = cur;
                    this.state = 4;
                    done = true;
                    continue block6;
                }
                case 4: {
                    if (cur == -1) {
                        throw new EOFException("Unexpected end-of-file");
                    }
                    if (cur == 61) {
                        return -1;
                    }
                    if (table[cur] == -1) continue block6;
                    ret = (table[this.prev] & 3) << 6 | table[cur];
                    this.state = 1;
                    done = true;
                    continue block6;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        return ret;
    }

    public int read() throws IOException {
        return this.read(true);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = 0;
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off is negative");
        }
        while (count < len) {
            int cur = this.read(count == 0);
            if (cur == -1) {
                if (count == 0) {
                    return -1;
                }
                return count;
            }
            if (cur == -2) {
                if (!$assertionsDisabled && count <= 0) {
                    throw new AssertionError();
                }
                return count;
            }
            if (!($assertionsDisabled || cur >= 0 && cur <= 255)) {
                throw new AssertionError();
            }
            b[off + count++] = (byte)cur;
        }
        return count;
    }

    public int available() throws IOException {
        return 0;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.savedPrev = this.prev;
        this.savedState = this.state;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void reset() throws IOException {
        this.in.reset();
        this.prev = this.savedPrev;
        this.state = this.savedState;
    }

    static {
        int c;
        int i;
        $assertionsDisabled = !Base64InputStream.class.desiredAssertionStatus();
        table = new int[256];
        for (i = 0; i < 256; ++i) {
            Base64InputStream.table[i] = -1;
        }
        i = 0;
        for (c = 65; c <= 90; ++c) {
            Base64InputStream.table[c] = i++;
        }
        for (c = 97; c <= 122; ++c) {
            Base64InputStream.table[c] = i++;
        }
        for (c = 48; c <= 57; ++c) {
            Base64InputStream.table[c] = i++;
        }
        Base64InputStream.table[43] = 62;
        Base64InputStream.table[47] = 63;
    }
}

