/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.registry.search;

import net.ivoa.registry.search.Capability;
import net.ivoa.registry.search.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VOResource
extends Metadata {
    private String title = null;
    private String identifier = null;
    private String shortName = null;
    private String restype = null;

    public VOResource(Element el) {
        super(el);
    }

    public String getResourceClass() {
        int c;
        if (this.restype != null) {
            return this.restype;
        }
        String out = ((Element)this.getDOMNode()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (out == null) {
            out = "Resource";
        }
        if ((c = out.indexOf(":")) >= 0) {
            out = out.substring(c + 1);
        }
        this.restype = out;
        return out;
    }

    void cacheIdentityData(String name) {
        for (Node child = this.getDOMNode().getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            if (this.title == null && child.getNodeName().equals("title")) {
                this.title = child.getNodeValue();
                if (!name.equals("title")) continue;
                break;
            }
            if (this.shortName == null && child.getNodeName().equals("shortName")) {
                this.shortName = child.getNodeValue();
                if (!name.equals("shortName")) continue;
                break;
            }
            if (this.identifier != null || !child.getNodeName().equals("identifier")) continue;
            this.identifier = child.getNodeValue();
            if (name.equals("identifier")) break;
        }
    }

    public String getTitle() {
        if (this.title == null) {
            this.cacheIdentityData("title");
        }
        return this.title;
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            this.cacheIdentityData("identifier");
        }
        return this.identifier;
    }

    public String getShortName() {
        if (this.shortName == null) {
            this.cacheIdentityData("shortName");
        }
        return this.shortName;
    }

    public Capability findCapabilityByType(String type) {
        Metadata[] out = this.getBlocks("capability");
        if (out == null) {
            return null;
        }
        for (int i = 0; i < out.length; ++i) {
            String xsitype = out[i].getXSIType();
            if (!type.equals(xsitype)) continue;
            return new Capability((Element)out[i].getDOMNode(), xsitype, null);
        }
        return null;
    }

    public Capability findCapabilityByID(String id) {
        Metadata[] out = this.getBlocks("capability");
        if (out == null) {
            return null;
        }
        for (int i = 0; i < out.length; ++i) {
            String stdid = ((Element)out[i].getDOMNode()).getAttribute("standardID");
            if (!id.equals(stdid)) continue;
            return new Capability((Element)out[i].getDOMNode(), null, stdid);
        }
        return null;
    }
}

