/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.registry.search;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.soap.SOAPException;
import net.ivoa.registry.RegistryServiceException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

abstract class Searcher {
    int max = 50;
    int from = 1;
    Method method = null;
    Object[] args = null;
    Object service = null;

    Searcher(Object searchojb, Method searchmeth, int from, int max) {
        this.service = searchojb;
        this.method = searchmeth;
        this.from = from;
        this.max = max;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int pos) {
        this.from = pos;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int count) {
        this.max = count;
    }

    public Element exec() throws RegistryServiceException, SOAPException, DOMException {
        this.updateArgs();
        try {
            return (Element)this.method.invoke(this.service, this.args);
        }
        catch (ClassCastException ex) {
            throw new InternalError("programmer error: search method has wrong return type: " + this.method.getName());
        }
        catch (IllegalAccessException ex) {
            throw new InternalError("programmer error: inaccessible search method: " + this.method.getName());
        }
        catch (IllegalArgumentException ex) {
            throw new InternalError("programmer error: incorrect arguments to search method: " + this.method.getName());
        }
        catch (InvocationTargetException ex) {
            Throwable tex = ex.getTargetException();
            if (tex instanceof SOAPException) {
                throw (SOAPException)tex;
            }
            if (tex instanceof RegistryServiceException) {
                throw (RegistryServiceException)tex;
            }
            if (tex instanceof DOMException) {
                throw (DOMException)tex;
            }
            String name = tex.getClass().getName();
            int dot = name.lastIndexOf(".");
            if (dot >= 0) {
                name = name.substring(dot + 1);
            }
            throw new RegistryServiceException(name + ": " + tex.getMessage());
        }
    }

    public abstract void updateArgs();
}

