/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.adql.app;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class Validate
extends DefaultHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String EXTERNAL_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = true;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = true;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = true;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_MEMORY_USAGE = false;
    protected static final boolean DEFAULT_TAGGINESS = false;
    protected long fElements;
    protected long fAttributes;
    protected long fCharacters;
    protected long fIgnorableWhitespace;
    protected long fTagCharacters;
    protected long fOtherCharacters;
    protected LinkedList schemaPath = null;
    protected Properties schemaLocations = null;

    public Validate() {
        Properties defsloc = new Properties();
        String dsf = System.getProperty("adql.defaultSchemaFiles");
        if (dsf != null) {
            String ns = null;
            String loc = null;
            StringTokenizer tok = new StringTokenizer(dsf);
            while (tok.hasMoreTokens()) {
                ns = tok.nextToken();
                if (!tok.hasMoreTokens()) break;
                loc = tok.nextToken();
                defsloc.setProperty(ns, loc);
            }
        }
        this.schemaLocations = new Properties(defsloc);
        this.setSchemaPath(System.getProperty("adql.schemaPath"));
        this.prependSchemaPath(System.getProperty("adql.schemaDir"));
    }

    public void setSchemaDir(String dir) throws FileNotFoundException {
        File sdir = new File(dir);
        if (!sdir.exists()) {
            throw new FileNotFoundException("Directory not found: " + dir);
        }
        if (!sdir.isDirectory()) {
            throw new FileNotFoundException("Not a directory: " + dir);
        }
        this.prependSchemaPath(dir);
    }

    public String getSchemaDir() {
        return this.schemaPath.size() > 0 ? this.schemaPath.getFirst() : null;
    }

    public void prependSchemaPath(String directory) {
        if (directory != null) {
            this.schemaPath.addFirst(directory);
        }
    }

    public void appendSchemaPath(String directory) {
        if (directory != null) {
            this.schemaPath.addLast(directory);
        }
    }

    public void setSchemaPath(String path) {
        this.schemaPath = new LinkedList();
        if (path == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(path, ":");
        while (st.hasMoreTokens()) {
            this.schemaPath.addLast(st.nextToken().trim());
        }
    }

    public void addSchemaLocation(String nsuri, String location) {
        this.schemaLocations.setProperty(nsuri, location);
    }

    public void addSchemaLocation(String schemaLocation) {
        String ns = null;
        String loc = null;
        StringTokenizer tok = new StringTokenizer(schemaLocation);
        while (tok.hasMoreTokens()) {
            ns = tok.nextToken();
            if (!tok.hasMoreTokens()) break;
            loc = tok.nextToken();
            this.addSchemaLocation(ns, loc);
        }
    }

    public String getSchemaLocation() {
        String ns = null;
        String loc = null;
        File dir = null;
        StringBuffer out = new StringBuffer();
        ArrayList<File> schemaDirs = new ArrayList<File>(this.schemaPath.size());
        Iterator iter = this.schemaPath.iterator();
        while (iter.hasNext()) {
            dir = new File((String)iter.next());
            if (!dir.exists() || !dir.isDirectory()) continue;
            schemaDirs.add(dir.getAbsoluteFile());
        }
        Enumeration<?> e = this.schemaLocations.propertyNames();
        while (e.hasMoreElements()) {
            ns = (String)e.nextElement();
            loc = this.schemaLocations.getProperty(ns);
            if (loc.indexOf(58) < 0 && !new File(loc).isAbsolute()) {
                loc = this.findFile(schemaDirs, loc);
            }
            out.append(ns).append(' ').append(loc);
            if (!e.hasMoreElements()) continue;
            out.append(' ');
        }
        return out.toString();
    }

    private String findFile(ArrayList dirs, String loc) {
        String out = loc;
        File f = null;
        Iterator iter = dirs.iterator();
        while (f == null && iter.hasNext()) {
            f = new File((File)iter.next(), loc);
            if (f.exists()) continue;
            f = null;
        }
        if (f != null) {
            loc = f.getAbsolutePath();
        }
        return loc;
    }

    public void printResults(PrintWriter out, String uri, long time, long memory, boolean tagginess, int repetition) {
        out.print(uri);
        out.print(": ");
        if (repetition == 1) {
            out.print(time);
        } else {
            out.print(time);
            out.print('/');
            out.print(repetition);
            out.print('=');
            out.print(time / (long)repetition);
        }
        out.print(" ms");
        if (memory != Long.MIN_VALUE) {
            out.print(", ");
            out.print(memory);
            out.print(" bytes");
        }
        out.print(" (");
        out.print(this.fElements);
        out.print(" elems, ");
        out.print(this.fAttributes);
        out.print(" attrs, ");
        out.print(this.fIgnorableWhitespace);
        out.print(" spaces, ");
        out.print(this.fCharacters);
        out.print(" chars)");
        if (tagginess) {
            out.print(' ');
            long totalCharacters = this.fTagCharacters + this.fOtherCharacters + this.fCharacters + this.fIgnorableWhitespace;
            long tagValue = this.fTagCharacters * 100L / totalCharacters;
            out.print(tagValue);
            out.print("% tagginess");
        }
        out.println();
        out.flush();
    }

    public void startDocument() throws SAXException {
        this.fElements = 0L;
        this.fAttributes = 0L;
        this.fCharacters = 0L;
        this.fIgnorableWhitespace = 0L;
        this.fTagCharacters = 0L;
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        ++this.fElements;
        ++this.fTagCharacters;
        this.fTagCharacters += (long)raw.length();
        if (attrs != null) {
            int attrCount = attrs.getLength();
            this.fAttributes += (long)attrCount;
            for (int i = 0; i < attrCount; ++i) {
                ++this.fTagCharacters;
                this.fTagCharacters += (long)attrs.getQName(i).length();
                ++this.fTagCharacters;
                ++this.fTagCharacters;
                this.fOtherCharacters += (long)attrs.getValue(i).length();
                ++this.fTagCharacters;
            }
        }
        ++this.fTagCharacters;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.fCharacters += (long)length;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.fIgnorableWhitespace += (long)length;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.fTagCharacters += 2L;
        this.fTagCharacters += (long)target.length();
        if (data != null && data.length() > 0) {
            ++this.fTagCharacters;
            this.fOtherCharacters += (long)data.length();
        }
        this.fTagCharacters += 2L;
    }

    public void warning(SAXParseException ex) throws SAXException {
        this.printError("Warning", ex);
    }

    public void error(SAXParseException ex) throws SAXException {
        this.printError("Error", ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.printError("Fatal Error", ex);
    }

    protected void printError(String type, SAXParseException ex) {
        String systemId;
        System.err.print("[");
        System.err.print(type);
        System.err.print("] ");
        if (ex == null) {
            System.out.println("!!!");
        }
        if ((systemId = ex.getSystemId()) != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            System.err.print(systemId);
        }
        System.err.print(':');
        System.err.print(ex.getLineNumber());
        System.err.print(':');
        System.err.print(ex.getColumnNumber());
        System.err.print(": ");
        System.err.print(ex.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            Validate.printUsage();
            System.exit(1);
        }
        Validate validater = new Validate();
        PrintWriter out = new PrintWriter(System.out);
        XMLReader parser = null;
        int repetition = 1;
        boolean namespaces = true;
        boolean namespacePrefixes = false;
        boolean validation = true;
        boolean schemaValidation = true;
        boolean schemaFullChecking = true;
        boolean dynamicValidation = false;
        boolean memoryUsage = false;
        boolean tagginess = false;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.startsWith("-")) {
                String option = arg.substring(1);
                if (option.equals("p")) {
                    if (++i == argv.length) {
                        System.err.println("error: Missing argument to -p option.");
                        continue;
                    }
                    String parserName = argv[i];
                    try {
                        parser = XMLReaderFactory.createXMLReader(parserName);
                    }
                    catch (Exception e) {
                        try {
                            Parser sax1Parser = ParserFactory.makeParser(parserName);
                            parser = new ParserAdapter(sax1Parser);
                            System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                        }
                        catch (Exception ex) {
                            parser = null;
                            System.err.println("error: Unable to instantiate parser (" + parserName + ")");
                        }
                    }
                    continue;
                }
                if (option.equals("x")) {
                    if (++i == argv.length) {
                        System.err.println("error: Missing argument to -x option.");
                        continue;
                    }
                    String number = argv[i];
                    try {
                        int value = Integer.parseInt(number);
                        if (value < 1) {
                            System.err.println("error: Repetition must be at least 1.");
                            continue;
                        }
                        repetition = value;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("error: invalid number (" + number + ").");
                    }
                    continue;
                }
                if (option.equals("l")) {
                    if (++i == argv.length) {
                        System.err.println("error: Missing argument to -l option.");
                        continue;
                    }
                    try {
                        validater.setSchemaDir(argv[i]);
                    }
                    catch (FileNotFoundException ex) {
                        System.err.println("error: no such directory with read permission: " + argv[i]);
                    }
                }
                if (option.equals("sl")) {
                    if (++i == argv.length) {
                        System.err.println("error: Missing argument to -sl option.");
                        continue;
                    }
                    validater.addSchemaLocation(argv[i]);
                }
                if (option.equalsIgnoreCase("n")) {
                    namespaces = option.equals("n");
                    continue;
                }
                if (option.equalsIgnoreCase("np")) {
                    namespacePrefixes = option.equals("np");
                    continue;
                }
                if (option.equalsIgnoreCase("v")) {
                    validation = option.equals("v");
                    continue;
                }
                if (option.equalsIgnoreCase("s")) {
                    schemaValidation = option.equals("s");
                    continue;
                }
                if (option.equalsIgnoreCase("f")) {
                    schemaFullChecking = option.equals("f");
                    continue;
                }
                if (option.equalsIgnoreCase("dv")) {
                    dynamicValidation = option.equals("dv");
                    continue;
                }
                if (option.equalsIgnoreCase("m")) {
                    memoryUsage = option.equals("m");
                    continue;
                }
                if (option.equalsIgnoreCase("t")) {
                    tagginess = option.equals("t");
                    continue;
                }
                if (option.equals("-rem")) {
                    if (++i == argv.length) {
                        System.err.println("error: Missing argument to -# option.");
                        continue;
                    }
                    System.out.print("# ");
                    System.out.println(argv[i]);
                    continue;
                }
                if (option.equals("h")) {
                    Validate.printUsage();
                    continue;
                }
                System.err.println("error: unknown option (" + option + ").");
                continue;
            }
            if (parser == null) {
                try {
                    parser = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
                }
                catch (Exception e) {
                    System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                    continue;
                }
            }
            try {
                parser.setFeature(NAMESPACES_FEATURE_ID, namespaces);
            }
            catch (SAXException e) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
            }
            try {
                parser.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, namespacePrefixes);
            }
            catch (SAXException e) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespace-prefixes)");
            }
            try {
                parser.setFeature(VALIDATION_FEATURE_ID, validation);
            }
            catch (SAXException e) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
            }
            try {
                parser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, schemaValidation);
            }
            catch (SAXNotRecognizedException e) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
            }
            catch (SAXNotSupportedException e) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
            }
            try {
                parser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, schemaFullChecking);
            }
            catch (SAXNotRecognizedException e) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException e) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                parser.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, dynamicValidation);
            }
            catch (SAXNotRecognizedException e) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
            }
            catch (SAXNotSupportedException e) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
            }
            try {
                parser.setProperty(EXTERNAL_SCHEMA_LOCATION, validater.getSchemaLocation());
            }
            catch (SAXNotSupportedException e) {
                System.err.println("warning: Parser does not support property (http://apache.org/xml/properties/schema/external-schemaLocation)");
            }
            catch (SAXNotRecognizedException e) {
                System.err.println("warning: Parser does not recognize property (http://apache.org/xml/properties/schema/external-schemaLocation)");
            }
            parser.setContentHandler(validater);
            parser.setErrorHandler(validater);
            try {
                long timeBefore = System.currentTimeMillis();
                long memoryBefore = Runtime.getRuntime().freeMemory();
                for (int j = 0; j < repetition; ++j) {
                    parser.parse(arg);
                }
                long memoryAfter = Runtime.getRuntime().freeMemory();
                long timeAfter = System.currentTimeMillis();
                long time = timeAfter - timeBefore;
                long memory = memoryUsage ? memoryBefore - memoryAfter : Long.MIN_VALUE;
                validater.printResults(out, arg, time, memory, tagginess, repetition);
                continue;
            }
            catch (SAXParseException e) {
                continue;
            }
            catch (Exception e) {
                System.err.println("error: Parse error occurred - " + e.getMessage());
                Exception se = e;
                if (e instanceof SAXException) {
                    se = ((SAXException)e).getException();
                }
                if (se != null) {
                    se.printStackTrace(System.err);
                    continue;
                }
                e.printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java net.ivoa.adql.apps.Validater (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -x number   Select number of repetitions.");
        System.err.println("  -n  | -N    Turn on/off namespace processing(default: on).");
        System.err.println("  -np | -NP   Turn on/off namespace prefixes(default: false).");
        System.err.println("              NOTE: Requires use of -n.");
        System.err.println("  -v  | -V    Turn on/off validation.(default: on).");
        System.err.println("  -s  | -S    Turn on/off Schema validation support (default: on).");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking(default: on).");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Requires use of -v and not supported by all parsers.");
        System.err.println("  -m  | -M    Turn on/off memory usage report(default: on).");
        System.err.println("  -t  | -T    Turn on/off \"tagginess\" report.(default: on).");
        System.err.println("  --rem text  Output user defined comment before next parse.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.println("  Repetition: 1");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Prefixes:   ");
        System.err.println("off");
        System.err.print("  Validation: ");
        System.err.println("on");
        System.err.print("  Schema:     ");
        System.err.println("on");
        System.err.print("  Schema full checking:     ");
        System.err.println("on");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  Memory:     ");
        System.err.println("off");
        System.err.print("  Tagginess:  ");
        System.err.println("off");
        System.err.println();
        System.err.println("notes:");
        System.err.println("  The speed and memory results from this program should NOT be used as the");
        System.err.println("  basis of parser performance comparison! Real analytical methods should be");
        System.err.println("  used. For better results, perform multiple document parses within the same");
        System.err.println("  virtual machine to remove class loading from parse time and memory usage.");
        System.err.println();
        System.err.println("  The \"tagginess\" measurement gives a rough estimate of the percentage of");
        System.err.println("  markup versus content in the XML document. The percent tagginess of a ");
        System.err.println("  document is equal to the minimum amount of tag characters required for ");
        System.err.println("  elements, attributes, and processing instructions divided by the total");
        System.err.println("  amount of characters (characters, ignorable whitespace, and tag characters)");
        System.err.println("  in the document.");
        System.err.println();
        System.err.println("  Not all features are supported by different parsers.");
    }
}

