/*
 * Decompiled with CFR 0.152.
 */
package ncsa.horizon.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class CmdLine {
    protected String config = null;
    protected Hashtable options = null;
    protected Vector argList = null;
    protected int flags = 0;
    protected Character stopchar = null;
    public static final int NULLFLAG = 0;
    public static final int RELAX = 1;
    public static final int USRWARN = 2;
    public static final int WARN = 6;

    public CmdLine(String configuration, int flags, String[] args) throws UnrecognizedOptionException {
        this(configuration, flags);
        if (args != null) {
            this.setCmdLine(args);
        }
    }

    public CmdLine(String configuration, int flags) {
        this.flags = flags;
        this.setConfig(configuration);
    }

    public CmdLine(String configuration) {
        this(configuration, 0);
    }

    public CmdLine(String configuration, String[] args) throws UnrecognizedOptionException {
        this(configuration, 0, args);
    }

    public synchronized void setConfig(String configuration) {
        if (this.config != null && (this.flags & 6) > 0) {
            System.err.println("Warning: Resetting Command Line configuration");
        }
        this.config = configuration;
        this.options = new Hashtable();
        char[] conchr = this.config.toCharArray();
        Character chr = null;
        Serializable state = null;
        Integer zero = new Integer(0);
        for (int i = 0; i < conchr.length; ++i) {
            if (!Character.isLetterOrDigit(conchr[i]) && (this.flags & 6) > 0) {
                System.err.println("Warning: ignoring non-letter in configuration string: " + this.config + " ('" + conchr[i] + "' at pos. " + i + ").");
                continue;
            }
            chr = new Character(conchr[i]);
            state = null;
            if (this.options.containsKey(chr) && (this.flags & 6) > 0) {
                System.err.println("Warning: option redefined: " + chr);
            }
            if (i + 1 < conchr.length) {
                if (conchr[i + 1] == '-') {
                    this.stopchar = chr;
                    ++i;
                } else if (conchr[i + 1] == ':') {
                    state = new Stack();
                    ++i;
                }
            }
            if (state == null) {
                state = zero;
            }
            this.options.put(chr, state);
        }
    }

    public synchronized void setCmdLine(String[] args) throws UnrecognizedOptionException {
        if (args == null) {
            return;
        }
        boolean more = true;
        this.argList = new Vector(args.length);
        StringBuffer unrec = new StringBuffer();
        char[] argary = null;
        Character opt = null;
        Integer state = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (more && !args[i].equals("-") && args[i].startsWith("-")) {
                argary = args[i].toCharArray();
                for (int j = 1; j < argary.length; ++j) {
                    opt = new Character(argary[j]);
                    if (!this.options.containsKey(opt)) {
                        String told;
                        if ((this.flags & 1) == 0) {
                            throw new UnrecognizedOptionException(opt);
                        }
                        if ((this.flags & 2) > 0 && (told = unrec.toString()).indexOf(argary[j]) < 0) {
                            System.err.println("Warning: unrecognized option: -" + opt + "; ignoring");
                        }
                        unrec.append(opt);
                        continue;
                    }
                    state = (Integer)this.options.get(opt);
                    if (state instanceof Integer) {
                        state = new Integer((Integer)state + 1);
                        this.options.put(opt, state);
                    } else if (state instanceof Stack) {
                        Stack list = (Stack)((Object)state);
                        if (j + 1 < argary.length) {
                            list.push(args[i].substring(j + 1));
                            j = argary.length;
                        } else if (i + 1 < args.length) {
                            list.push(args[++i]);
                        } else if ((this.flags & 2) > 0) {
                            System.err.println("Warning: missing argument to -" + opt + " option; ignoring.");
                        }
                    }
                    if (!opt.equals(this.stopchar)) continue;
                    more = false;
                }
                continue;
            }
            this.argList.addElement(args[i]);
        }
    }

    public synchronized String getConfig() {
        return this.config;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void addFlags(int flags) {
        this.flags |= flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isSet(char c) {
        return this.getNumSet(c) > 0;
    }

    public boolean isAnOption(char c) {
        return this.getNumSet(c) >= 0;
    }

    public synchronized boolean isSwitched(char c) {
        Character ch = new Character(c);
        Object state = this.options.get(ch);
        if (state == null) {
            return false;
        }
        return state instanceof Integer;
    }

    public synchronized int getNumSet(char c) {
        Character ch = new Character(c);
        Object state = this.options.get(ch);
        if (state == null) {
            return -1;
        }
        if (state instanceof Integer) {
            return (Integer)state;
        }
        if (state instanceof Stack) {
            return ((Stack)state).size();
        }
        return -1;
    }

    public synchronized String getValue(char c) {
        Character ch = new Character(c);
        Object state = this.options.get(ch);
        if (state == null) {
            return null;
        }
        if (state instanceof Integer) {
            Boolean yes = new Boolean((Integer)state > 0);
            return yes.toString();
        }
        if (state instanceof Stack) {
            Stack vals = (Stack)state;
            return vals.size() > 0 ? (String)vals.lastElement() : null;
        }
        return null;
    }

    public synchronized Stack getAllValues(char c) {
        Character ch = new Character(c);
        Object state = this.options.get(ch);
        if (state == null) {
            return new Stack();
        }
        Stack<String> out = new Stack<String>();
        if (state instanceof Integer) {
            int n = (Integer)state;
            out.ensureCapacity(n);
            Boolean yes = new Boolean(n > 0);
            for (int i = 0; i < n; ++i) {
                out.push(yes.toString());
            }
        } else if (state instanceof Stack) {
            return (Stack)((Stack)state).clone();
        }
        return new Stack();
    }

    public synchronized Enumeration options() {
        return this.options.keys();
    }

    public synchronized Enumeration arguments() {
        return this.argList.elements();
    }

    public synchronized int getNumArgs() {
        return this.argList.size();
    }

    public static String[] parseStringList(String input, String delim) {
        StringTokenizer t = new StringTokenizer(input, delim);
        Vector<String> parts = new Vector<String>(t.countTokens());
        while (t.hasMoreTokens()) {
            parts.addElement(t.nextToken());
        }
        Object[] out = new String[parts.size()];
        parts.copyInto(out);
        return out;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        String[] use = new String[args.length - 1];
        if (use.length > 0) {
            System.arraycopy(args, 1, use, 0, use.length);
        }
        CmdLine cl = null;
        int flags = 1;
        try {
            cl = new CmdLine("XS", flags, use);
        }
        catch (UnrecognizedOptionException e) {
            throw new InternalError();
        }
        flags = 0;
        if (!cl.isSet('X')) {
            flags = 1;
        }
        if (!cl.isSet('S')) {
            flags |= 6;
        }
        cl.setFlags(flags);
        cl.setConfig("XS" + args[0]);
        try {
            cl.setCmdLine(use);
        }
        catch (UnrecognizedOptionException ex) {
            System.err.println("Error: " + ex.getMessage());
            return;
        }
        String type = null;
        String switched = "switch";
        String parm = "parameter";
        String id = null;
        Character o = null;
        Enumeration e = cl.options();
        while (e.hasMoreElements()) {
            int n;
            o = (Character)e.nextElement();
            type = cl.isSwitched(o.charValue()) ? switched : parm;
            id = new String("-" + o + " (" + type + "): ");
            if (!cl.isSet(o.charValue())) {
                System.out.println(id + "not set");
                continue;
            }
            if (cl.isSwitched(o.charValue())) {
                int n2 = cl.getNumSet(o.charValue());
                System.out.println(id + "set " + n2 + " times");
                continue;
            }
            Stack parms = cl.getAllValues(o.charValue());
            StringBuffer line = new StringBuffer(id + n + " arguments");
            for (n = parms.size(); n > 0; --n) {
                String item = (String)parms.pop();
                line.append("\n  \"" + item + "\"");
                if (item.indexOf(44) < 0) continue;
                String[] list = CmdLine.parseStringList(item, ", ");
                line.append(" => ");
                if (list.length > 0) {
                    line.append("\"" + list[0] + "\"");
                }
                for (int i = 1; i < list.length; ++i) {
                    line.append(", \"" + list[i] + "\"");
                }
            }
            System.out.println(line);
        }
        System.out.println("Non-option arguments (" + cl.getNumArgs() + "): ");
        e = cl.arguments();
        while (e.hasMoreElements()) {
            System.out.println("    \"" + e.nextElement() + "\"");
        }
    }

    public class UnrecognizedOptionException
    extends Exception {
        private Character c;

        public UnrecognizedOptionException() {
            this.c = null;
        }

        public UnrecognizedOptionException(char c) {
            this.c = null;
            this.c = new Character(c);
        }

        public UnrecognizedOptionException(Character C) {
            this.c = null;
            this.c = C;
        }

        public UnrecognizedOptionException(String str) {
            super(str);
            this.c = null;
        }

        public String toString() {
            return this.getMessage();
        }

        public String getMessage() {
            if (this.c == null) {
                return super.getMessage();
            }
            return new String("Unrecognized option: -" + this.c);
        }
    }
}

