/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.idlgen;

import alma.tools.idlgen.AcsXmlNamingExpert;
import alma.tools.idlgen.JacorbVisitor;
import alma.tools.idlgen.comphelpgen.ComponentHelperGeneratorProxy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jacorb.idl.AcsAdapterForOldJacorb;
import org.jacorb.idl.AcsInterfacePrinter;
import org.jacorb.idl.AcsJacorbParser;
import org.jacorb.idl.AcsStructPrinter;
import org.jacorb.idl.AcsTypedefPrinter;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.Interface;
import org.jacorb.idl.StructType;

public class XmlIdlCompiler {
    public static final String PROP_DO_GENERATE_COMP_HELPERS = "alma.acs.tools.comphelpergen.doGenerate";
    public static final String PROP_COMP_HELPERS_OUTDIR = "alma.acs.tools.comphelpergen.outRootDir";
    private boolean verbose = false;
    private final AcsXmlNamingExpert namingExpert = new AcsXmlNamingExpert();

    public void generateCode(JacorbVisitor jacorbVisitor) throws Exception {
        Object object;
        String string = System.getProperty("ACS.idl2jbind");
        this.namingExpert.setIdlStruct2JavaBindingClassMappings(string);
        boolean bl = Boolean.getBoolean(PROP_DO_GENERATE_COMP_HELPERS);
        String string2 = System.getProperty(PROP_COMP_HELPERS_OUTDIR);
        if (this.verbose) {
            System.out.println("\nXML typedefs found: ");
            for (AliasTypeSpec object2 : jacorbVisitor.xmlTypedefs) {
                System.out.println("\t" + object2.name());
            }
            System.out.println("\nXML-aware Structs found: ");
            for (StructType structType : jacorbVisitor.xmlAwareStructs) {
                System.out.println("\t" + structType.name());
            }
            System.out.println("\nXML-aware IFs found: ");
            for (Interface interface_ : jacorbVisitor.xmlAwareIFs) {
                System.out.println("\t" + interface_.name());
            }
            System.out.println("\nXmlIdl options (non-JacORB):\n  idl2jbindMapping = " + string + "\n  doGenerateCompHelpers = " + bl + "\n  compHelperOutDir = " + string2);
        }
        if (bl && string2 == null) {
            System.err.println("\nCan't generate component helper class(es) because no output directory is given in alma.acs.tools.comphelpergen.outRootDir");
            bl = false;
        }
        Iterator<StructType> iterator = null;
        if (bl) {
            iterator = new ComponentHelperGeneratorProxy(string2, this.verbose);
            try {
                ((ComponentHelperGeneratorProxy)((Object)iterator)).setOriginalParseTree(jacorbVisitor.acsCompIFs);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("failed to parse Java packages:");
                System.err.println(runtimeException.toString());
                System.err.println("Will disable component helper generation.");
                iterator = null;
                bl = false;
            }
        } else if (this.verbose) {
            System.out.println("no code generation for component helper classes was selected...");
        }
        if (this.verbose) {
            System.out.println("\n**** Java code generation ****");
        }
        for (Interface interface_ : jacorbVisitor.xmlAwareIFs) {
            interface_.set_name(interface_.name() + "J");
        }
        for (AliasTypeSpec aliasTypeSpec : jacorbVisitor.xmlTypedefs) {
            object = new AcsTypedefPrinter(aliasTypeSpec, this.namingExpert);
            ((AcsTypedefPrinter)object).printHolderClass();
        }
        for (StructType structType : jacorbVisitor.xmlAwareStructs) {
            object = new AcsStructPrinter(structType, jacorbVisitor.xmlTypedefs, jacorbVisitor.xmlAwareStructs, jacorbVisitor.xmlAwareIFs, this.namingExpert);
            ((AcsStructPrinter)object).printStructClass();
            ((AcsStructPrinter)object).printHolderClass();
        }
        for (Interface interface_ : jacorbVisitor.xmlAwareIFs) {
            object = new AcsInterfacePrinter(interface_, jacorbVisitor.xmlTypedefs, jacorbVisitor.xmlAwareStructs, jacorbVisitor.xmlAwareIFs, this.namingExpert);
            ((AcsInterfacePrinter)object).printAcsJInterface();
        }
        if (this.verbose) {
            System.out.println("\n**** done with Java code generation ****");
        }
        if (iterator != null) {
            System.out.println("ALMA IDL compiler done, now invoking component helper code generator...");
            ((ComponentHelperGeneratorProxy)((Object)iterator)).generateComponentHelperCode();
        }
    }

    public static File createFile(String string, String string2) throws IOException {
        String string3 = string2 + ".java";
        String string4 = AcsAdapterForOldJacorb.getParserOutDir() + File.separatorChar + string.replace('.', File.separatorChar);
        File file = new File(string4);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Unable to create " + string4);
        }
        File file2 = new File(file, string3);
        return file2;
    }

    public static void main(String[] stringArray) {
        try {
            XmlIdlCompiler xmlIdlCompiler = new XmlIdlCompiler();
            String[] stringArray2 = xmlIdlCompiler.processAndPruneAcsArgs(stringArray);
            JacorbVisitor jacorbVisitor = new JacorbVisitor();
            AcsJacorbParser acsJacorbParser = new AcsJacorbParser();
            acsJacorbParser.init(stringArray2, jacorbVisitor);
            System.out.println("ACS IDL compilation for " + acsJacorbParser.idlFile);
            acsJacorbParser.parse();
            xmlIdlCompiler.generateCode(jacorbVisitor);
        }
        catch (Throwable throwable) {
            System.err.println("ACS IDL compilation failed!");
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private String[] processAndPruneAcsArgs(String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.equals("-verbose")) {
                this.verbose = true;
                int n = 1;
                arrayList.add("-W");
                arrayList.add(Integer.toString(n));
                continue;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

