/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.alarmsystem.source;

import alma.acs.concurrent.ThreadLoopRunner;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class AlarmsMap {
    public static final int ALARM_ACTIVITY_TIME = 30;
    private final Map<String, AlarmInfo> alarms = new ConcurrentHashMap<String, AlarmInfo>();
    private final ThreadLoopRunner loopRunner;
    private final Logger logger;

    public AlarmsMap(ThreadFactory threadFactory, Logger logger) {
        this.logger = logger;
        this.loopRunner = new ThreadLoopRunner((Runnable)((Object)new AlarmsMapRunnable()), 30L, TimeUnit.SECONDS, threadFactory, logger, "alarm_timer");
    }

    public Collection<String> getActiveAlarms() {
        Vector<String> ret = new Vector<String>();
        Set<String> keys = this.alarms.keySet();
        for (String key : keys) {
            if (!this.alarms.get((Object)key).active) continue;
            ret.add(key);
        }
        return ret;
    }

    public boolean raise(String alarmID) {
        AlarmInfo info = this.alarms.get(alarmID);
        boolean ret = info != null && info.active;
        this.alarms.put(alarmID, new AlarmInfo(true));
        return ret;
    }

    public boolean clear(String alarmID) {
        AlarmInfo info = this.alarms.get(alarmID);
        boolean ret = info != null && !info.active;
        this.alarms.put(alarmID, new AlarmInfo(false));
        return ret;
    }

    public void start() {
        this.loopRunner.setDelayMode(ThreadLoopRunner.ScheduleDelayMode.FIXED_DELAY);
        this.loopRunner.runLoop();
    }

    public void shutdown() {
        try {
            if (this.loopRunner.shutdown(1L, TimeUnit.SECONDS)) {
                this.logger.finest("Thread shut down");
            } else {
                this.logger.warning("Failed to cleanly shut down the AlarmsMap thread");
            }
        }
        catch (InterruptedException ie) {
            this.logger.warning("AlarmsMap thread interrupted while shutting down.");
        }
        this.clear();
    }

    public int size() {
        return this.alarms.size();
    }

    public boolean containsKey(Object key) {
        return this.alarms.containsKey(key);
    }

    private void clear() {
        this.alarms.clear();
    }

    public AlarmInfo get(Object key) {
        return this.alarms.get(key);
    }

    public Set<String> keySet() {
        return this.alarms.keySet();
    }

    public class AlarmsMapRunnable
    extends ThreadLoopRunner.CancelableRunnable {
        public void run() {
            for (String key : AlarmsMap.this.alarms.keySet()) {
                if (this.shouldTerminate) {
                    return;
                }
                AlarmInfo info = AlarmsMap.this.alarms.get(key);
                if (info == null || System.currentTimeMillis() - 30000L <= info.time) continue;
                AlarmsMap.this.alarms.remove(key);
            }
        }
    }

    public static class AlarmInfo {
        public final long time;
        public final boolean active;

        public AlarmInfo(boolean active) {
            this.active = active;
            this.time = System.currentTimeMillis();
        }
    }
}

