/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.alarmsystem.source;

import alma.acs.alarmsystem.source.AlarmSource;
import alma.acs.alarmsystem.source.AlarmSourceImpl;
import alma.acs.container.ContainerServicesBase;
import alma.acs.logging.AcsLogLevel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class AlarmSourceFactory {
    private ContainerServicesBase contSvcs;
    private final Map<String, AlarmSource> alarmSources = new ConcurrentHashMap<String, AlarmSource>();
    private volatile boolean closed = false;

    public AlarmSourceFactory(ContainerServicesBase contSvcs) {
        if (contSvcs == null) {
            throw new IllegalArgumentException("The ContainerServices can't be null");
        }
        this.contSvcs = contSvcs;
    }

    public AlarmSource getAlarmSource(ContainerServicesBase containerServices) {
        if (containerServices == null) {
            throw new IllegalArgumentException("The ContainerServices can't be null");
        }
        return this.getAlarmSource(containerServices.getName());
    }

    public AlarmSource getAlarmSource(String componentName) {
        if (this.closed) {
            throw new IllegalStateException("The AlarmSourceFactory has already been closed!");
        }
        if (componentName == null | componentName.isEmpty()) {
            throw new IllegalArgumentException("The name can't be null nor empty");
        }
        AlarmSource ret = this.alarmSources.get(componentName);
        if (ret == null) {
            this.contSvcs.getLogger().log((Level)AcsLogLevel.DELOUSE, "Instantiating the AlarmSource for " + componentName);
            ret = new AlarmSourceImpl(this.contSvcs);
            this.alarmSources.put(componentName, ret);
            ret.start();
        }
        return ret;
    }

    public void releaseAlarmSource(ContainerServicesBase containerServices) {
        if (containerServices == null) {
            throw new IllegalArgumentException("The ContainerServices can't be null");
        }
        this.releaseAlarmSource(containerServices.getName());
    }

    public void releaseAlarmSource(String componentName) {
        if (this.closed) {
            throw new IllegalStateException("The AlarmSourceFactory has already been closed!");
        }
        if (componentName == null | componentName.isEmpty()) {
            throw new IllegalArgumentException("The name can't be null nor empty");
        }
        AlarmSource alarmSrc = this.alarmSources.remove(componentName);
        if (alarmSrc != null) {
            this.contSvcs.getLogger().log((Level)AcsLogLevel.DELOUSE, "Releasing the AlarmSource of " + componentName);
            alarmSrc.tearDown();
        }
    }

    public void tearDown() {
        if (this.closed) {
            this.contSvcs.getLogger().log((Level)AcsLogLevel.WARNING, "AlarmSourceFactory already closed");
            return;
        }
        this.closed = true;
        this.contSvcs.getLogger().log((Level)AcsLogLevel.DELOUSE, "Closing the AlarmSourceFactory");
        Set<String> sourceNames = this.alarmSources.keySet();
        for (String sourceName : sourceNames) {
            AlarmSource source = this.alarmSources.get(sourceName);
            if (source == null) continue;
            this.contSvcs.getLogger().log((Level)AcsLogLevel.DELOUSE, "Closing AlarmSource with name " + sourceName);
            source.tearDown();
        }
        this.alarmSources.clear();
        this.contSvcs.getLogger().log((Level)AcsLogLevel.DEBUG, "AlarmSourceFactory closed");
    }
}

