/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.alarmsystem.source;

import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AlarmQueue
extends ConcurrentHashMap<String, AlarmToQueue> {
    public void add(String faultFamily, String faultMember, int faultCode, Properties properties, boolean active) {
        this.put(faultFamily + ":" + faultMember + ":" + faultCode, new AlarmToQueue(faultFamily, faultMember, faultCode, properties, active));
    }

    public static class AlarmToQueue {
        public final String faultFamily;
        public final String faultMember;
        public final int faultCode;
        private final Properties properties;
        public final boolean active;

        public AlarmToQueue(String faultFamily, String faultMember, int faultCode, Properties properties, boolean active) {
            this.faultFamily = faultFamily;
            this.faultMember = faultMember;
            this.faultCode = faultCode;
            this.active = active;
            if (properties == null) {
                this.properties = null;
            } else {
                this.properties = new Properties();
                this.copyProperties(properties, this.properties);
            }
        }

        public Properties getProperties() {
            if (this.properties == null) {
                return null;
            }
            Properties ret = new Properties();
            this.copyProperties(this.properties, ret);
            return ret;
        }

        private void copyProperties(Properties src, Properties dest) {
            if (src == null) {
                throw new NullPointerException("Invalid null source properties");
            }
            if (dest == null) {
                throw new NullPointerException("Invalid null destintaion properties");
            }
            Set<String> names = src.stringPropertyNames();
            for (String propertyName : names) {
                String value = src.getProperty(propertyName);
                dest.setProperty(propertyName, value);
            }
        }
    }
}

