/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.LineWord;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.util.LineReader;

public class LineEnvironment
implements Environment {
    private boolean promptAll_;
    private boolean interactive_ = true;
    private int numberedArgs_;
    private Argument[] arguments_;
    private PrintStream out_ = System.out;
    private PrintStream err_ = System.err;
    private final Set clearedParams_ = new HashSet();
    private final List acquiredValues_ = new ArrayList();
    static final String NULL_STRING = "";
    public static final char INDIRECTION_CHAR = '@';
    public static final int NUM_TRIES = 3;

    public LineEnvironment() {
    }

    public LineEnvironment(String[] args, Parameter[] params) throws UsageException {
        this();
        LineWord[] words = new LineWord[args.length];
        for (int i = 0; i < args.length; ++i) {
            words[i] = new LineWord(args[i]);
        }
        this.setWords(words);
        this.checkParameters(params);
    }

    public void setWords(LineWord[] words) {
        if (this.arguments_ != null) {
            throw new IllegalStateException("Arguments already set");
        }
        this.arguments_ = new Argument[words.length];
        for (int i = 0; i < words.length; ++i) {
            this.arguments_[i] = new Argument(words[i]);
        }
    }

    public String getParamHelp(Parameter param) {
        return param.getPrompt();
    }

    public boolean isHidden(Parameter param) {
        return false;
    }

    public void checkParameters(Parameter[] params) throws UsageException {
        int narg = this.arguments_.length;
        HashSet<Parameter> paramSet = new HashSet<Parameter>(Arrays.asList(params));
        int position = 1;
        for (int ia = 0; ia < narg; ++ia) {
            LineWord word = this.arguments_[ia].word_;
            boolean found = false;
            Iterator it = paramSet.iterator();
            while (!found && it.hasNext()) {
                Parameter param = (Parameter)it.next();
                if (!found && this.paramNameMatches(word.getName(), param)) {
                    found = true;
                    if (!(param instanceof MultiParameter)) {
                        it.remove();
                    }
                }
                if (found || param.getName() != null || param.getPosition() != position) continue;
                found = true;
                it.remove();
                ++position;
            }
            if (found) continue;
            throw new UsageException("Unrecognised parameter " + word.getText());
        }
    }

    public String[] getNames() {
        int narg = this.arguments_.length;
        String[] names = new String[narg];
        for (int iarg = 0; iarg < narg; ++iarg) {
            names[iarg] = this.arguments_[iarg].word_.getName();
        }
        return names;
    }

    public void setInteractive(boolean interactive) {
        this.interactive_ = interactive;
    }

    public boolean getInteractive() {
        return this.interactive_;
    }

    public void setPromptAll(boolean prompt) {
        if (!this.interactive_) {
            throw new IllegalStateException("Not interactive");
        }
        this.promptAll_ = prompt;
    }

    public boolean getPromptAll() {
        return this.promptAll_;
    }

    private String findValue(Parameter param) throws TaskException {
        if (param instanceof MultiParameter) {
            char separator = ((MultiParameter)((Object)param)).getValueSeparator();
            ArrayList<String> valueList = new ArrayList<String>();
            for (int i = 0; i < this.arguments_.length; ++i) {
                Argument arg = this.arguments_[i];
                LineWord word = arg.word_;
                if (!this.paramNameMatches(word.getName(), param) && (arg.pos_ <= 0 || param.getPosition() != arg.pos_)) continue;
                arg.used_ = true;
                valueList.add(word.getValue());
            }
            if (valueList.size() == 1) {
                String value = (String)valueList.get(0);
                if (value.charAt(0) == '@') {
                    String[] lines;
                    try {
                        lines = LineEnvironment.readLines(value.substring(1));
                    }
                    catch (IOException e) {
                        throw new TaskException(e.getMessage(), e);
                    }
                    StringBuffer val = new StringBuffer();
                    for (int i = 0; i < lines.length; ++i) {
                        if (i > 0) {
                            val.append(separator);
                        }
                        val.append(lines[i].trim());
                    }
                    return val.toString();
                }
                return value;
            }
            if (valueList.size() > 1) {
                StringBuffer val = new StringBuffer();
                Iterator it = valueList.iterator();
                while (it.hasNext()) {
                    val.append((String)it.next());
                    if (!it.hasNext()) continue;
                    val.append(separator);
                }
                return val.toString();
            }
        } else {
            for (int i = 0; i < this.arguments_.length; ++i) {
                Argument arg = this.arguments_[i];
                LineWord word = arg.word_;
                if (!this.paramNameMatches(word.getName(), param) && (arg.pos_ <= 0 || param.getPosition() != arg.pos_)) continue;
                arg.used_ = true;
                return word.getValue();
            }
        }
        return null;
    }

    private String promptForValue(Parameter param) throws TaskException {
        String name = param.getName();
        String prompt = param.getPrompt();
        String dflt = param.getDefault();
        StringBuffer obuf = new StringBuffer(param.getName());
        if (prompt != null) {
            obuf.append(" - ").append(prompt);
        }
        if (dflt != null || param.isNullPermitted()) {
            obuf.append(" [").append(dflt).append("]");
        }
        obuf.append(": ");
        String promptLine = obuf.toString();
        for (int ntry = 0; ntry < 3; ++ntry) {
            String stringVal;
            String sval;
            try {
                PrintStream err = this.getErrorStream();
                sval = this.isHidden(param) ? LineReader.readMaskedString(promptLine, err) : LineReader.readString(promptLine, err);
            }
            catch (IOException e) {
                throw new TaskException("Prompt for value failed");
            }
            if ("?".equals(sval) || "help".equalsIgnoreCase(sval)) {
                this.getErrorStream().println();
                this.getErrorStream().println(this.getParamHelp(param));
                continue;
            }
            String string = stringVal = sval.length() == 0 ? param.getDefault() : LineEnvironment.readValue(sval);
            if (NULL_STRING.equals(stringVal)) {
                stringVal = null;
            }
            try {
                this.setValueFromString(param, stringVal);
                return stringVal;
            }
            catch (TaskException e) {
                this.getErrorStream().println(e.getMessage() + "\n");
            }
        }
        throw new ParameterValueException(param, "Too many tries");
    }

    public void clearValue(Parameter par) {
        this.clearedParams_.add(par);
    }

    public void setOutputStream(PrintStream out) {
        this.out_ = out;
    }

    public void setErrorStream(PrintStream err) {
        this.err_ = err;
    }

    public PrintStream getOutputStream() {
        return this.out_;
    }

    public PrintStream getErrorStream() {
        return this.err_;
    }

    public void acquireValue(Parameter param) throws TaskException {
        String stringVal;
        if (this.clearedParams_.contains(param)) {
            stringVal = null;
            this.clearedParams_.remove(param);
        } else {
            stringVal = this.findValue(param);
        }
        if (stringVal != null) {
            if (stringVal.equals(NULL_STRING)) {
                stringVal = null;
            }
            this.setValueFromString(param, stringVal);
        } else if (this.interactive_ && (this.promptAll_ || param.getDefault() == null && !param.isNullPermitted() || param.getPreferExplicit())) {
            stringVal = this.promptForValue(param);
        } else {
            stringVal = param.getDefault();
            this.setValueFromString(param, stringVal);
        }
        String word = this.formatAssignment(param, stringVal);
        if (!this.acquiredValues_.contains(word)) {
            this.acquiredValues_.add(word);
        }
    }

    private void setValueFromString(Parameter param, String sval) throws TaskException {
        if (sval == null && !param.isNullPermitted()) {
            throw new ParameterValueException(param, "null value not allowed");
        }
        param.setValueFromString(this, sval);
    }

    private String formatAssignment(Parameter param, String value) {
        if (value != null && value.indexOf(32) >= 0) {
            if (value.indexOf(39) < 0) {
                value = '\'' + value + '\'';
            } else if (value.indexOf(34) < 0) {
                value = '\"' + value + '\"';
            }
        }
        if (this.isHidden(param)) {
            value = "*";
        }
        return param.getName() + "=" + value;
    }

    public String[] getUnused() {
        ArrayList<String> unusedList = new ArrayList<String>();
        for (int i = 0; i < this.arguments_.length; ++i) {
            Argument arg = this.arguments_[i];
            if (arg.used_) continue;
            unusedList.add(arg.word_.getText());
        }
        return unusedList.toArray(new String[0]);
    }

    public String[] getAssignments() {
        return this.acquiredValues_.toArray(new String[0]);
    }

    public boolean paramNameMatches(String envName, Parameter param) {
        return param.getName().equalsIgnoreCase(envName);
    }

    private static String readValue(String sval) {
        if (sval.length() == 0 || sval.equals("null")) {
            return NULL_STRING;
        }
        return sval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readLines(String location) throws IOException {
        FileInputStream istrm = new FileInputStream(new File(location));
        BufferedReader rdr = new BufferedReader(new InputStreamReader(istrm));
        ArrayList<String> lineList = new ArrayList<String>();
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                lineList.add(line);
            }
        }
        finally {
            rdr.close();
        }
        return lineList.toArray(new String[0]);
    }

    private class Argument {
        final LineWord word_;
        int pos_;
        boolean used_;

        Argument(LineWord word) {
            this.word_ = word;
            this.pos_ = word.getName() == null ? ++LineEnvironment.this.numberedArgs_ : -1;
        }
    }
}

