/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.task.LineFormatter;
import uk.ac.starlink.task.Parameter;

public class InvokeUtils {
    public static void configureLogging(int verbosity, boolean debug) {
        Logger rootLogger = Logger.getLogger("");
        int verbInt = Math.max(Level.ALL.intValue(), Level.WARNING.intValue() - verbosity * (Level.WARNING.intValue() - Level.INFO.intValue()));
        Level verbLevel = Level.parse(Integer.toString(verbInt));
        Handler[] rootHandlers = rootLogger.getHandlers();
        if (rootHandlers.length > 0 && rootHandlers[0] instanceof ConsoleHandler) {
            rootHandlers[0].setLevel(verbLevel);
            rootHandlers[0].setFormatter(new LineFormatter(debug));
        }
        rootLogger.setLevel(verbLevel);
        Logger.getLogger("org.apache.axis.utils.JavaUtils").setLevel(Level.SEVERE);
    }

    public static String getJavaVersion() {
        try {
            return System.getProperty("java.version");
        }
        catch (SecurityException e) {
            return "???";
        }
    }

    public static String getJavaVM() {
        try {
            return System.getProperty("java.vm.name", "???") + " version " + System.getProperty("java.vm.version", "???");
        }
        catch (SecurityException e) {
            return "???";
        }
    }

    public static void summariseError(Throwable error, PrintStream out) {
        String msg = error.getMessage();
        if (msg == null || msg.trim().length() == 0) {
            msg = error.toString();
        } else {
            out.println(msg);
        }
        Throwable cause = error.getCause();
        if (cause != null) {
            InvokeUtils.summariseError(cause, out);
        }
    }

    public static Parameter[] sortParameters(Parameter[] params) {
        ArrayList<Parameter> numbered = new ArrayList<Parameter>();
        ArrayList unNumbered = new ArrayList();
        for (int i = 0; i < params.length; ++i) {
            Parameter param = params[i];
            (param.getPosition() > 0 ? numbered : unNumbered).add(param);
        }
        Collections.sort(numbered, new Comparator(){

            public int compare(Object o1, Object o2) {
                int pos2;
                int pos1 = ((Parameter)o1).getPosition();
                if (pos1 < (pos2 = ((Parameter)o2).getPosition())) {
                    return -1;
                }
                if (pos2 < pos1) {
                    return 1;
                }
                throw new IllegalArgumentException("Two params have same position");
            }
        });
        ArrayList<Parameter> paramList = numbered;
        paramList.addAll(unNumbered);
        return paramList.toArray(new Parameter[0]);
    }
}

