/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.util.DataSource;

public class InputStreamParameter
extends Parameter {
    public InputStreamParameter(String name) {
        super(name);
        this.setUsage("<location>");
    }

    public void setValueFromString(Environment env, String sval) throws TaskException {
        if (sval != null && !sval.equals("-") && !new File(sval).exists()) {
            try {
                new URL(sval);
            }
            catch (MalformedURLException e) {
                String msg = "Value " + sval + " is not a file, URL or \"-\"";
                throw new ParameterValueException((Parameter)this, msg);
            }
        }
        super.setValueFromString(env, sval);
    }

    public InputStream inputStreamValue(Environment env) throws TaskException {
        String loc = this.stringValue(env);
        try {
            return loc == null ? null : DataSource.getInputStream(this.stringValue(env));
        }
        catch (IOException e) {
            throw new TaskException(e.getMessage(), e);
        }
    }
}

