/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.nc.testsupport;

import alma.ACSErrTypeCommon.wrappers.AcsJIllegalStateEventEx;
import alma.acs.container.ContainerServicesBase;
import alma.acs.exceptions.AcsJException;
import alma.acs.nc.AcsEventPublisher;
import alma.acs.nc.AcsEventSubscriber;
import alma.acs.nc.testsupport.InMemoryPublisher;
import alma.acs.nc.testsupport.InMemorySubscriber;
import alma.acsnc.EventDescription;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public class InMemoryNcFake {
    private final String channelName;
    private final Logger logger;
    private final ContainerServicesBase services;
    private final List<InMemoryPublisher<?>> publishers;
    private final List<InMemorySubscriber<?>> subscribers;
    private final ReentrantReadWriteLock subscribersLock;

    public InMemoryNcFake(ContainerServicesBase services, String channelName) {
        this.channelName = channelName;
        this.services = services;
        this.logger = services.getLogger();
        this.publishers = new ArrayList();
        this.subscribers = new ArrayList();
        this.subscribersLock = new ReentrantReadWriteLock(true);
    }

    public synchronized <T> AcsEventPublisher<T> createPublisher(String publisherName, Class<T> eventType) {
        InMemoryPublisher ret = new InMemoryPublisher(this, publisherName, this.logger);
        this.publishers.add(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> AcsEventSubscriber<T> createSubscriber(String subscriberName, Class<T> eventType) throws AcsJException {
        InMemorySubscriber<T> ret = new InMemorySubscriber<T>(this, this.services, subscriberName, eventType);
        this.subscribersLock.writeLock().lock();
        try {
            this.subscribers.add(ret);
        }
        finally {
            this.subscribersLock.writeLock().unlock();
        }
        return ret;
    }

    void disconnectPublisher(InMemoryPublisher<?> publisher) {
        boolean done = this.publishers.remove(publisher);
        if (done) {
            this.logger.finer("Disconnected publisher " + publisher.publisherName);
        } else {
            this.logger.warning("Failed to disconnect publisher " + publisher.publisherName);
        }
    }

    void disconnectSubscriber(InMemorySubscriber<?> subscriber) {
        this.subscribersLock.writeLock().lock();
        try {
            boolean done = this.subscribers.remove(subscriber);
            if (done) {
                this.logger.finer("Disconnected subscriber " + subscriber.getClientName());
            } else {
                this.logger.warning("Failed to disconnect subscriber " + subscriber.getClientName());
            }
        }
        finally {
            this.subscribersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushData(Object data, EventDescription desc) {
        this.subscribersLock.readLock().lock();
        try {
            for (InMemorySubscriber<?> subscriber : this.subscribers) {
                try {
                    subscriber.pushData(data, desc);
                }
                catch (AcsJIllegalStateEventEx acsJIllegalStateEventEx) {}
            }
        }
        finally {
            this.subscribersLock.readLock().unlock();
        }
    }

    public int hashCode() {
        return this.channelName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InMemoryNcFake)) {
            return false;
        }
        InMemoryNcFake other = (InMemoryNcFake)obj;
        return this.channelName.equals(other.channelName);
    }
}

