/*
 * Decompiled with CFR 0.152.
 */
package alma.ssr.observingmodes;

import alma.ssr.observingmodes.Property;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ObservingScript
implements Serializable {
    private String name;
    private String file;
    private List<Property> propertyList = new ArrayList<Property>();

    public void addProperty(Property property) throws IndexOutOfBoundsException {
        this.propertyList.add(property);
    }

    public void addProperty(int n, Property property) throws IndexOutOfBoundsException {
        this.propertyList.add(n, property);
    }

    public Enumeration<? extends Property> enumerateProperty() {
        return Collections.enumeration(this.propertyList);
    }

    public String getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public Property getProperty(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.propertyList.size()) {
            throw new IndexOutOfBoundsException("getProperty: Index value '" + n + "' not in range [0.." + (this.propertyList.size() - 1) + "]");
        }
        return this.propertyList.get(n);
    }

    public Property[] getProperty() {
        Property[] propertyArray = new Property[]{};
        return this.propertyList.toArray(propertyArray);
    }

    public int getPropertyCount() {
        return this.propertyList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException validationException) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Property> iterateProperty() {
        return this.propertyList.iterator();
    }

    public void marshal(Writer writer) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)writer);
    }

    public void marshal(ContentHandler contentHandler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)contentHandler);
    }

    public void removeAllProperty() {
        this.propertyList.clear();
    }

    public boolean removeProperty(Property property) {
        boolean bl = this.propertyList.remove(property);
        return bl;
    }

    public Property removePropertyAt(int n) {
        Property property = this.propertyList.remove(n);
        return property;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setProperty(int n, Property property) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.propertyList.size()) {
            throw new IndexOutOfBoundsException("setProperty: Index value '" + n + "' not in range [0.." + (this.propertyList.size() - 1) + "]");
        }
        this.propertyList.set(n, property);
    }

    public void setProperty(Property[] propertyArray) {
        this.propertyList.clear();
        for (int i = 0; i < propertyArray.length; ++i) {
            this.propertyList.add(propertyArray[i]);
        }
    }

    public static ObservingScript unmarshalObservingScript(Reader reader) throws MarshalException, ValidationException {
        return (ObservingScript)Unmarshaller.unmarshal(ObservingScript.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

