/*
 * Decompiled with CFR 0.152.
 */
package alma.Control.LOSolutions;

import alma.BasebandNameMod.BasebandName;
import alma.Control.BasebandSpec;
import alma.Control.DSBbasebandSpec;
import alma.Control.SSBbasebandSpec;
import alma.Control.SidebandPreference;
import alma.Control.TuningParameters;
import alma.ReceiverBandMod.ReceiverBand;
import java.util.List;
import java.util.Map;

public interface LOSolutionsInterface {
    public TuningParameters computeSSBSolution(List<SSBbasebandSpec> var1) throws Exception;

    public TuningParameters computeSSBSolution(List<SSBbasebandSpec> var1, ReceiverBand var2) throws Exception;

    public TuningParameters computeDSBSolution(List<DSBbasebandSpec> var1) throws Exception;

    public TuningParameters computeDSBSolution(List<DSBbasebandSpec> var1, ReceiverBand var2) throws Exception;

    public String getHardwareParameters();

    public Map<BasebandName, Double> actualSkyFreq(TuningParameters var1);

    public double LO1Freq(TuningParameters var1);

    public Map<BasebandName, Double> LO2Freqs(TuningParameters var1);

    public static SSBbasebandSpec ssbBasebandSpec(double skyFreqHz) {
        return LOSolutionsInterface.ssbBasebandSpec(skyFreqHz, 100.0);
    }

    public static SSBbasebandSpec ssbBasebandSpec(double skyFreqHz, double weight) {
        return LOSolutionsInterface.ssbBasebandSpec(skyFreqHz, weight, 0.0, SidebandPreference.NoPreference);
    }

    public static SSBbasebandSpec ssbBasebandSpec(double skyFreqHz, double weight, SidebandPreference sidebandPref) {
        return LOSolutionsInterface.ssbBasebandSpec(skyFreqHz, weight, 0.0, sidebandPref);
    }

    public static SSBbasebandSpec ssbBasebandSpec(double skyFreqHz, double weight, double ifFreqHz, SidebandPreference sidebandPref) {
        SSBbasebandSpec spec = new SSBbasebandSpec();
        spec.skyFreqHz = skyFreqHz;
        spec.weight = weight;
        spec.ifFreqHz = ifFreqHz;
        spec.sidebandPref = sidebandPref;
        return spec;
    }

    public static DSBbasebandSpec dsbBasebandSpec(double skyFreqHzUpperOrLower) {
        return LOSolutionsInterface.dsbBasebandSpec(skyFreqHzUpperOrLower, 100.0, skyFreqHzUpperOrLower, 100.0);
    }

    public static DSBbasebandSpec dsbBasebandSpec(double skyFreqHzUpper, double skyFreqHzLower) {
        return LOSolutionsInterface.dsbBasebandSpec(skyFreqHzUpper, 100.0, skyFreqHzLower, 100.0);
    }

    public static DSBbasebandSpec dsbBasebandSpec(double skyFreqHzUpper, double weightUpper, double skyFreqHzLower, double weightLower) {
        return LOSolutionsInterface.dsbBasebandSpec(skyFreqHzUpper, weightUpper, 0.0, skyFreqHzLower, weightLower, 0.0);
    }

    public static DSBbasebandSpec dsbBasebandSpec(double skyFreqHzUpper, double weightUpper, double ifFreqHzUpper, double skyFreqHzLower, double weightLower, double ifFreqHzLower) {
        DSBbasebandSpec spec = new DSBbasebandSpec();
        spec.USB = new BasebandSpec();
        spec.LSB = new BasebandSpec();
        spec.USB.skyFreqHz = skyFreqHzUpper;
        spec.USB.weight = weightUpper;
        spec.USB.ifFreqHz = ifFreqHzUpper;
        spec.LSB.skyFreqHz = skyFreqHzLower;
        spec.LSB.weight = weightLower;
        spec.LSB.ifFreqHz = ifFreqHzLower;
        return spec;
    }
}

