/*
 * Decompiled with CFR 0.152.
 */
package alma.Correlator;

import alma.CorrelationBitMod.CorrelationBit;
import alma.CorrelationBitMod.CorrelationBitHelper;
import alma.Correlator.ChannelAverageRegionHelper;
import alma.Correlator.ChannelAverageRegionSeqHelper;
import alma.Correlator.SpectralWindow;
import alma.Correlator.StokesParameterSeqHelper;
import alma.NetSidebandMod.NetSideband;
import alma.NetSidebandMod.NetSidebandHelper;
import alma.StokesParameterMod.StokesParameterHelper;
import alma.SynthProfMod.SynthProf;
import alma.SynthProfMod.SynthProfHelper;
import alma.WindowFunctionMod.WindowFunction;
import alma.WindowFunctionMod.WindowFunctionHelper;
import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class SpectralWindowHelper {
    private static volatile TypeCode _type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCode type() {
        if (_type != null) return _type;
        Class<SpectralWindowHelper> clazz = SpectralWindowHelper.class;
        synchronized (SpectralWindowHelper.class) {
            if (_type != null) return _type;
            _type = ORB.init().create_struct_tc(SpectralWindowHelper.id(), "SpectralWindow", new StructMember[]{new StructMember("name", SpectralWindowHelper.nameFactory(), null), new StructMember("centerFrequencyMHz", SpectralWindowHelper.centerFrequencyMHzFactory(), null), new StructMember("effectiveBandwidthMHz", SpectralWindowHelper.effectiveBandwidthMHzFactory(), null), new StructMember("effectiveNumberOfChannels", SpectralWindowHelper.effectiveNumberOfChannelsFactory(), null), new StructMember("spectralAveragingFactor", SpectralWindowHelper.spectralAveragingFactorFactory(), null), new StructMember("sideBand", SpectralWindowHelper.sideBandFactory(), null), new StructMember("associatedSpectralWindowNumberInPair", SpectralWindowHelper.associatedSpectralWindowNumberInPairFactory(), null), new StructMember("useThisSpectralWindow", SpectralWindowHelper.useThisSpectralWindowFactory(), null), new StructMember("windowFunction", SpectralWindowHelper.windowFunctionFactory(), null), new StructMember("channelAverageRegions", SpectralWindowHelper.channelAverageRegionsFactory(), null), new StructMember("frqChProfReproduction", SpectralWindowHelper.frqChProfReproductionFactory(), null), new StructMember("synthProf", SpectralWindowHelper.synthProfFactory(), null), new StructMember("correlationBits", SpectralWindowHelper.correlationBitsFactory(), null), new StructMember("correlationNyquistOversampling", SpectralWindowHelper.correlationNyquistOversamplingFactory(), null), new StructMember("polnProductsSeq", SpectralWindowHelper.polnProductsSeqFactory(), null), new StructMember("quantizationCorrection", SpectralWindowHelper.quantizationCorrectionFactory(), null)});
            // ** MonitorExit[var0] (shouldn't be in output)
            return _type;
        }
    }

    private static TypeCode centerFrequencyMHzFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)7));
    }

    private static TypeCode correlationBitsFactory() {
        return ORB.init().create_enum_tc(CorrelationBitHelper.id(), "CorrelationBit", new String[]{"BITS_2x2", "BITS_3x3", "BITS_4x4"});
    }

    private static TypeCode sideBandFactory() {
        return ORB.init().create_enum_tc(NetSidebandHelper.id(), "NetSideband", new String[]{"NOSB", "LSB", "USB", "DSB"});
    }

    private static TypeCode correlationNyquistOversamplingFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode associatedSpectralWindowNumberInPairFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)3));
    }

    private static TypeCode effectiveNumberOfChannelsFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)3));
    }

    private static TypeCode polnProductsSeqFactory() {
        return ORB.init().create_alias_tc(StokesParameterSeqHelper.id(), "StokesParameterSeq", ORB.init().create_sequence_tc(0, ORB.init().create_enum_tc(StokesParameterHelper.id(), "StokesParameter", new String[]{"I", "Q", "U", "V", "RR", "RL", "LR", "LL", "XX", "XY", "YX", "YY", "RX", "RY", "LX", "LY", "XR", "XL", "YR", "YL", "PP", "PQ", "QP", "QQ", "RCIRCULAR", "LCIRCULAR", "LINEAR", "PTOTAL", "PLINEAR", "PFTOTAL", "PFLINEAR", "PANGLE"})));
    }

    private static TypeCode spectralAveragingFactorFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)3));
    }

    private static TypeCode channelAverageRegionsFactory() {
        return ORB.init().create_alias_tc(ChannelAverageRegionSeqHelper.id(), "ChannelAverageRegionSeq", ORB.init().create_sequence_tc(32, ORB.init().create_struct_tc(ChannelAverageRegionHelper.id(), "ChannelAverageRegion", new StructMember[]{new StructMember("startChannel", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null), new StructMember("numberChannels", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null)})));
    }

    private static TypeCode nameFactory() {
        return ORB.init().create_string_tc(0);
    }

    private static TypeCode useThisSpectralWindowFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode windowFunctionFactory() {
        return ORB.init().create_enum_tc(WindowFunctionHelper.id(), "WindowFunction", new String[]{"UNIFORM", "HANNING", "HAMMING", "BARTLETT", "BLACKMANN", "BLACKMANN_HARRIS", "WELCH"});
    }

    private static TypeCode synthProfFactory() {
        return ORB.init().create_enum_tc(SynthProfHelper.id(), "SynthProf", new String[]{"NOSYNTH", "ACACORR", "ACA_CDP"});
    }

    private static TypeCode quantizationCorrectionFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode effectiveBandwidthMHzFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)7));
    }

    private static TypeCode frqChProfReproductionFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    public static void insert(Any any, SpectralWindow s) {
        any.type(SpectralWindowHelper.type());
        SpectralWindowHelper.write(any.create_output_stream(), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpectralWindow extract(Any any) {
        InputStream in = any.create_input_stream();
        try {
            SpectralWindow spectralWindow = SpectralWindowHelper.read(in);
            return spectralWindow;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception " + e.toString());
            }
        }
    }

    public static String id() {
        return "IDL:alma/Correlator/SpectralWindow:1.0";
    }

    public static SpectralWindow read(InputStream in) {
        SpectralWindow result = new SpectralWindow();
        result.name = in.read_string();
        result.centerFrequencyMHz = in.read_double();
        result.effectiveBandwidthMHz = in.read_double();
        result.effectiveNumberOfChannels = in.read_long();
        result.spectralAveragingFactor = in.read_long();
        result.sideBand = NetSidebandHelper.read((InputStream)in);
        result.associatedSpectralWindowNumberInPair = in.read_long();
        result.useThisSpectralWindow = in.read_boolean();
        result.windowFunction = WindowFunctionHelper.read((InputStream)in);
        result.channelAverageRegions = ChannelAverageRegionSeqHelper.read(in);
        result.frqChProfReproduction = in.read_boolean();
        result.synthProf = SynthProfHelper.read((InputStream)in);
        result.correlationBits = CorrelationBitHelper.read((InputStream)in);
        result.correlationNyquistOversampling = in.read_boolean();
        result.polnProductsSeq = StokesParameterSeqHelper.read(in);
        result.quantizationCorrection = in.read_boolean();
        return result;
    }

    public static void write(OutputStream out, SpectralWindow s) {
        String tmpResult0 = s.name;
        out.write_string(tmpResult0);
        out.write_double(s.centerFrequencyMHz);
        out.write_double(s.effectiveBandwidthMHz);
        out.write_long(s.effectiveNumberOfChannels);
        out.write_long(s.spectralAveragingFactor);
        NetSidebandHelper.write((OutputStream)out, (NetSideband)s.sideBand);
        out.write_long(s.associatedSpectralWindowNumberInPair);
        out.write_boolean(s.useThisSpectralWindow);
        WindowFunctionHelper.write((OutputStream)out, (WindowFunction)s.windowFunction);
        ChannelAverageRegionSeqHelper.write(out, s.channelAverageRegions);
        out.write_boolean(s.frqChProfReproduction);
        SynthProfHelper.write((OutputStream)out, (SynthProf)s.synthProf);
        CorrelationBitHelper.write((OutputStream)out, (CorrelationBit)s.correlationBits);
        out.write_boolean(s.correlationNyquistOversampling);
        StokesParameterSeqHelper.write(out, s.polnProductsSeq);
        out.write_boolean(s.quantizationCorrection);
    }
}

