/*
 * Decompiled with CFR 0.152.
 */
package alma.Correlator;

import alma.ACS.TimeIntervalHelper;
import alma.ACS.TimeIntervalSeqHelper;
import alma.AccumModeMod.AccumMode;
import alma.AccumModeMod.AccumModeHelper;
import alma.BasebandNameMod.BasebandName;
import alma.BasebandNameMod.BasebandNameHelper;
import alma.CorrelationBitMod.CorrelationBitHelper;
import alma.CorrelationModeMod.CorrelationMode;
import alma.CorrelationModeMod.CorrelationModeHelper;
import alma.Correlator.BaseBandConfig;
import alma.Correlator.BinSwitching_tHelper;
import alma.Correlator.ChannelAverageRegionHelper;
import alma.Correlator.ChannelAverageRegionSeqHelper;
import alma.Correlator.SpectralWindowHelper;
import alma.Correlator.SpectralWindowSeqHelper;
import alma.Correlator.StokesParameterSeqHelper;
import alma.NetSidebandMod.NetSidebandHelper;
import alma.SidebandProcessingModeMod.SidebandProcessingMode;
import alma.SidebandProcessingModeMod.SidebandProcessingModeHelper;
import alma.StokesParameterMod.StokesParameterHelper;
import alma.SwitchingModeMod.SwitchingModeHelper;
import alma.SynthProfMod.SynthProfHelper;
import alma.WindowFunctionMod.WindowFunctionHelper;
import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class BaseBandConfigHelper {
    private static volatile TypeCode _type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCode type() {
        if (_type != null) return _type;
        Class<BaseBandConfigHelper> clazz = BaseBandConfigHelper.class;
        synchronized (BaseBandConfigHelper.class) {
            if (_type != null) return _type;
            _type = ORB.init().create_struct_tc(BaseBandConfigHelper.id(), "BaseBandConfig", new StructMember[]{new StructMember("basebandName", BaseBandConfigHelper.basebandNameFactory(), null), new StructMember("use12GHzFilter", BaseBandConfigHelper.use12GHzFilterFactory(), null), new StructMember("useUSB", BaseBandConfigHelper.useUSBFactory(), null), new StructMember("CAM", BaseBandConfigHelper.CAMFactory(), null), new StructMember("dataProducts", BaseBandConfigHelper.dataProductsFactory(), null), new StructMember("sideBandSeparationMode", BaseBandConfigHelper.sideBandSeparationModeFactory(), null), new StructMember("spectralWindows", BaseBandConfigHelper.spectralWindowsFactory(), null), new StructMember("binSwitchingMode", BaseBandConfigHelper.binSwitchingModeFactory(), null), new StructMember("LO2FrequencyMHz", BaseBandConfigHelper.LO2FrequencyMHzFactory(), null), new StructMember("centerFreqOfResidualDelayMHz", BaseBandConfigHelper.centerFreqOfResidualDelayMHzFactory(), null)});
            // ** MonitorExit[var0] (shouldn't be in output)
            return _type;
        }
    }

    private static TypeCode basebandNameFactory() {
        return ORB.init().create_enum_tc(BasebandNameHelper.id(), "BasebandName", new String[]{"NOBB", "BB_1", "BB_2", "BB_3", "BB_4", "BB_5", "BB_6", "BB_7", "BB_8", "BB_ALL", "A1C1_3BIT", "A2C2_3BIT", "AC_8BIT", "B1D1_3BIT", "B2D2_3BIT", "BD_8BIT"});
    }

    private static TypeCode binSwitchingModeFactory() {
        return ORB.init().create_struct_tc(BinSwitching_tHelper.id(), "BinSwitching_t", new StructMember[]{new StructMember("SwitchingType", ORB.init().create_enum_tc(SwitchingModeHelper.id(), "SwitchingMode", new String[]{"NO_SWITCHING", "LOAD_SWITCHING", "POSITION_SWITCHING", "PHASE_SWITCHING", "FREQUENCY_SWITCHING", "NUTATOR_SWITCHING", "CHOPPER_WHEEL"}), null), new StructMember("numberOfPositions", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null), new StructMember("dwellTime", ORB.init().create_alias_tc(TimeIntervalSeqHelper.id(), "TimeIntervalSeq", ORB.init().create_sequence_tc(0, TimeIntervalHelper.type())), null), new StructMember("deadTime", ORB.init().create_alias_tc(TimeIntervalSeqHelper.id(), "TimeIntervalSeq", ORB.init().create_sequence_tc(0, TimeIntervalHelper.type())), null)});
    }

    private static TypeCode LO2FrequencyMHzFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)7));
    }

    private static TypeCode useUSBFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode spectralWindowsFactory() {
        return ORB.init().create_alias_tc(SpectralWindowSeqHelper.id(), "SpectralWindowSeq", ORB.init().create_sequence_tc(64, ORB.init().create_struct_tc(SpectralWindowHelper.id(), "SpectralWindow", new StructMember[]{new StructMember("name", ORB.init().create_string_tc(0), null), new StructMember("centerFrequencyMHz", ORB.init().get_primitive_tc(TCKind.from_int((int)7)), null), new StructMember("effectiveBandwidthMHz", ORB.init().get_primitive_tc(TCKind.from_int((int)7)), null), new StructMember("effectiveNumberOfChannels", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null), new StructMember("spectralAveragingFactor", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null), new StructMember("sideBand", ORB.init().create_enum_tc(NetSidebandHelper.id(), "NetSideband", new String[]{"NOSB", "LSB", "USB", "DSB"}), null), new StructMember("associatedSpectralWindowNumberInPair", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null), new StructMember("useThisSpectralWindow", ORB.init().get_primitive_tc(TCKind.from_int((int)8)), null), new StructMember("windowFunction", ORB.init().create_enum_tc(WindowFunctionHelper.id(), "WindowFunction", new String[]{"UNIFORM", "HANNING", "HAMMING", "BARTLETT", "BLACKMANN", "BLACKMANN_HARRIS", "WELCH"}), null), new StructMember("channelAverageRegions", ORB.init().create_alias_tc(ChannelAverageRegionSeqHelper.id(), "ChannelAverageRegionSeq", ORB.init().create_sequence_tc(32, ORB.init().create_struct_tc(ChannelAverageRegionHelper.id(), "ChannelAverageRegion", new StructMember[]{new StructMember("startChannel", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null), new StructMember("numberChannels", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null)}))), null), new StructMember("frqChProfReproduction", ORB.init().get_primitive_tc(TCKind.from_int((int)8)), null), new StructMember("synthProf", ORB.init().create_enum_tc(SynthProfHelper.id(), "SynthProf", new String[]{"NOSYNTH", "ACACORR", "ACA_CDP"}), null), new StructMember("correlationBits", ORB.init().create_enum_tc(CorrelationBitHelper.id(), "CorrelationBit", new String[]{"BITS_2x2", "BITS_3x3", "BITS_4x4"}), null), new StructMember("correlationNyquistOversampling", ORB.init().get_primitive_tc(TCKind.from_int((int)8)), null), new StructMember("polnProductsSeq", ORB.init().create_alias_tc(StokesParameterSeqHelper.id(), "StokesParameterSeq", ORB.init().create_sequence_tc(0, ORB.init().create_enum_tc(StokesParameterHelper.id(), "StokesParameter", new String[]{"I", "Q", "U", "V", "RR", "RL", "LR", "LL", "XX", "XY", "YX", "YY", "RX", "RY", "LX", "LY", "XR", "XL", "YR", "YL", "PP", "PQ", "QP", "QQ", "RCIRCULAR", "LCIRCULAR", "LINEAR", "PTOTAL", "PLINEAR", "PFTOTAL", "PFLINEAR", "PANGLE"}))), null), new StructMember("quantizationCorrection", ORB.init().get_primitive_tc(TCKind.from_int((int)8)), null)})));
    }

    private static TypeCode dataProductsFactory() {
        return ORB.init().create_enum_tc(CorrelationModeHelper.id(), "CorrelationMode", new String[]{"CROSS_ONLY", "AUTO_ONLY", "CROSS_AND_AUTO"});
    }

    private static TypeCode centerFreqOfResidualDelayMHzFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)7));
    }

    private static TypeCode use12GHzFilterFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode CAMFactory() {
        return ORB.init().create_enum_tc(AccumModeHelper.id(), "AccumMode", new String[]{"FAST", "NORMAL", "UNDEFINED"});
    }

    private static TypeCode sideBandSeparationModeFactory() {
        return ORB.init().create_enum_tc(SidebandProcessingModeHelper.id(), "SidebandProcessingMode", new String[]{"NONE", "PHASE_SWITCH_SEPARATION", "FREQUENCY_OFFSET_SEPARATION", "PHASE_SWITCH_REJECTION", "FREQUENCY_OFFSET_REJECTION"});
    }

    public static void insert(Any any, BaseBandConfig s) {
        any.type(BaseBandConfigHelper.type());
        BaseBandConfigHelper.write(any.create_output_stream(), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseBandConfig extract(Any any) {
        InputStream in = any.create_input_stream();
        try {
            BaseBandConfig baseBandConfig = BaseBandConfigHelper.read(in);
            return baseBandConfig;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception " + e.toString());
            }
        }
    }

    public static String id() {
        return "IDL:alma/Correlator/BaseBandConfig:1.0";
    }

    public static BaseBandConfig read(InputStream in) {
        BaseBandConfig result = new BaseBandConfig();
        result.basebandName = BasebandNameHelper.read((InputStream)in);
        result.use12GHzFilter = in.read_boolean();
        result.useUSB = in.read_boolean();
        result.CAM = AccumModeHelper.read((InputStream)in);
        result.dataProducts = CorrelationModeHelper.read((InputStream)in);
        result.sideBandSeparationMode = SidebandProcessingModeHelper.read((InputStream)in);
        result.spectralWindows = SpectralWindowSeqHelper.read(in);
        result.binSwitchingMode = BinSwitching_tHelper.read(in);
        result.LO2FrequencyMHz = in.read_double();
        result.centerFreqOfResidualDelayMHz = in.read_double();
        return result;
    }

    public static void write(OutputStream out, BaseBandConfig s) {
        BasebandNameHelper.write((OutputStream)out, (BasebandName)s.basebandName);
        out.write_boolean(s.use12GHzFilter);
        out.write_boolean(s.useUSB);
        AccumModeHelper.write((OutputStream)out, (AccumMode)s.CAM);
        CorrelationModeHelper.write((OutputStream)out, (CorrelationMode)s.dataProducts);
        SidebandProcessingModeHelper.write((OutputStream)out, (SidebandProcessingMode)s.sideBandSeparationMode);
        SpectralWindowSeqHelper.write(out, s.spectralWindows);
        BinSwitching_tHelper.write(out, s.binSwitchingMode);
        out.write_double(s.LO2FrequencyMHz);
        out.write_double(s.centerFreqOfResidualDelayMHz);
    }
}

