/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.startup;

import alma.acs.commandcenter.engine.ExecuteContainer;
import alma.acs.commandcenter.engine.ExecuteManager;
import alma.acs.commandcenter.engine.ExecuteServices;
import alma.acs.commandcenter.engine.NativeCommand;
import alma.acs.commandcenter.engine.RunModelAdapter;
import alma.acs.util.ACSPorts;

public class AcsStartLight
extends RunModelAdapter
implements NativeCommand.Listener {
    protected String acsInstance;
    protected String mgrPort;
    protected String cdbPort;
    protected String cntPort;
    protected String cntName;
    protected String cdbRoot;
    protected ExecuteServices executeServices;
    protected ExecuteManager executeManager;
    protected ExecuteContainer executeContainer;

    public static void main(String[] args) {
        new AcsStartLight().go(args);
    }

    protected void go(String[] args) {
        long soLong = System.currentTimeMillis();
        this.config(args);
        System.err.println("\n---> now starting cdb\n");
        this.cdb();
        System.err.println("\n---> now starting manager\n");
        this.manager();
        System.err.println("\n---> now starting container\n");
        this.container();
        System.err.println("\n---> finished (after " + (System.currentTimeMillis() - soLong) + "ms)\n");
    }

    protected void config(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: (this) <AcsInstance> <CdbRoot> <ContainerName>");
            return;
        }
        try {
            this.acsInstance = String.valueOf(Integer.parseInt(args[0].trim()));
        }
        catch (NumberFormatException exc) {
            System.err.println(" AcsInstance argument invalid, using 0");
            this.acsInstance = "0";
        }
        this.mgrPort = "3" + this.acsInstance + "00";
        this.cdbPort = "3" + this.acsInstance + "12";
        this.cntPort = "3" + this.acsInstance + "51";
        this.cdbRoot = args[1].trim();
        this.cntName = args[2].trim();
    }

    protected void cdb() {
        this.executeServices = new ExecuteServices(this);
        this.executeServices.startLocalJava(this);
    }

    protected void manager() {
        this.executeManager = new ExecuteManager(this);
        this.executeManager.startLocalJava(this);
    }

    protected void container() {
        this.executeContainer = new ExecuteContainer();
        this.executeContainer.startLocalJava(this, this);
    }

    @Override
    public String getScriptBase() {
        return this.acsInstance;
    }

    @Override
    public String getServicesLocalJavaPort() {
        return this.cdbPort;
    }

    @Override
    public String getServicesLocalJavaRoot() {
        return this.cdbRoot;
    }

    @Override
    public String getManagerLocalJavaPort() {
        return this.mgrPort;
    }

    @Override
    public String getContainerLocalJavaPort() {
        return this.cntPort;
    }

    @Override
    public String getManagerLocalJavaAgainstCDBHost() {
        return ACSPorts.getIP();
    }

    @Override
    public String getManagerLocalJavaAgainstCDBPort() {
        return this.cdbPort;
    }

    @Override
    public String getContainerAgainstManagerHost() {
        return ACSPorts.getIP();
    }

    @Override
    public String getContainerAgainstManagerPort() {
        return this.mgrPort;
    }

    @Override
    public String getContainerName() {
        return this.cntName;
    }

    @Override
    public String getContainerType() {
        return "java";
    }

    @Override
    public void stdoutWritten(NativeCommand task, String additionalOutput) {
        System.err.print(additionalOutput);
    }

    @Override
    public void stderrWritten(NativeCommand task, String additionalOutput) {
    }

    @Override
    public void statusChanged(NativeCommand task, String status) {
    }
}

