/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.gui;

import alma.acs.commandcenter.gui.CommandCenterGui;
import alma.acs.commandcenter.gui.FeedbackTabs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class FeedbackArea
extends JPanel {
    protected final String[] kbytes = new String[]{"Max.Size: 32K", "Max.Size: 128K", "Max.Size: 512K", "Max.Size: unlimited"};
    protected final int[] chars = new int[]{16384, 65536, 262144, Integer.MAX_VALUE};
    protected FeedbackTabs surroundingTabbedPane;
    protected String surroundingTabTitle;
    protected JTextArea outputArea;
    protected JComboBox txtSize;
    protected CommandCenterGui master;
    protected boolean scrollLock = false;
    protected int maxLength;

    protected FeedbackArea(CommandCenterGui master, FeedbackTabs tabbedPane, String tabTitle) {
        this.master = master;
        this.surroundingTabbedPane = tabbedPane;
        this.surroundingTabTitle = tabTitle;
        this.setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        final JToggleButton btnScrollLock = new JToggleButton("Scroll Lock");
        btnScrollLock.setToolTipText("Scroll Lock (forces Unlimited Buffer Size)");
        btnScrollLock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedbackArea.this.scrollLock = btnScrollLock.isSelected();
                if (FeedbackArea.this.scrollLock) {
                    FeedbackArea.this.txtSize.setSelectedIndex(FeedbackArea.this.kbytes.length - 1);
                }
            }
        });
        toolbar.add(btnScrollLock);
        toolbar.add(Box.createHorizontalStrut(7));
        this.txtSize = new JComboBox<String>(this.kbytes);
        this.txtSize.setToolTipText("Change Buffer Size (caution: takes immediate effect)");
        this.txtSize.setMaximumSize(this.txtSize.getPreferredSize());
        this.txtSize.setEditable(false);
        class SizeListener
        extends KeyAdapter
        implements FocusListener,
        ItemListener {
            SizeListener() {
            }

            void changeSize() {
                int newLength = FeedbackArea.this.chars[FeedbackArea.this.txtSize.getSelectedIndex()];
                if (newLength != FeedbackArea.this.maxLength) {
                    FeedbackArea.this.maxLength = newLength;
                    FeedbackArea.this.append("");
                }
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    this.changeSize();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        }
        SizeListener sizeLis = new SizeListener();
        this.txtSize.addKeyListener(sizeLis);
        this.txtSize.addFocusListener(sizeLis);
        this.txtSize.addItemListener(sizeLis);
        toolbar.add(this.txtSize);
        toolbar.add(Box.createHorizontalStrut(7));
        JButton btnSave = new JButton("Save...");
        btnSave.setToolTipText("Save this Log");
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedbackArea.this.surroundingTabbedPane.saveTab(FeedbackArea.this);
            }
        });
        toolbar.add(btnSave);
        toolbar.add(Box.createHorizontalGlue());
        JButton btnClear = new JButton("Clear");
        btnClear.setToolTipText("Clear this Log");
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedbackArea.this.clear();
            }
        });
        toolbar.add(btnClear);
        toolbar.add(Box.createHorizontalStrut(7));
        JButton btnRemove = new JButton("Remove");
        btnRemove.setToolTipText("Remove this Log");
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeedbackArea.this.surroundingTabbedPane.removeTab(FeedbackArea.this.surroundingTabTitle);
            }
        });
        toolbar.add(btnRemove);
        toolbar.add(Box.createHorizontalStrut(7));
        toolbar.addSeparator();
        JButton btnClearAll = new JButton("Clear All");
        btnClearAll.setToolTipText("Clear all Logs");
        btnClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeedbackArea.this.surroundingTabbedPane.clearAllTabs();
            }
        });
        toolbar.add(btnClearAll);
        this.add((Component)toolbar, "North");
        PlainDocument doc = new PlainDocument();
        this.outputArea = new JTextArea(doc, null, 10, 40);
        this.outputArea.setEditable(false);
        JScrollPane scp = new JScrollPane(this.outputArea);
        this.add((Component)scp, "Center");
        this.txtSize.setSelectedIndex(1);
        this.maxLength = this.chars[1];
        this.outputArea.setName("txt_Output");
        this.txtSize.setName("txt_BufferSize");
        btnScrollLock.setName("btn_ScrollLock");
        btnSave.setName("btn_Save");
        btnClear.setName("btn_Clear");
        btnRemove.setName("btn_Remove");
        btnClearAll.setName("btn_ClearAll");
    }

    protected void clear() {
        this.outputArea.setText("");
    }

    protected void append(String feedback) {
        Document doc = this.outputArea.getDocument();
        if (doc == null) {
            return;
        }
        try {
            doc.insertString(doc.getLength(), feedback, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        int newCaretPosition = this.outputArea.getCaretPosition();
        int newLength = doc.getLength();
        int tooMuch = Math.max(newLength - this.maxLength, 0);
        if (newLength > this.maxLength) {
            newCaretPosition -= newLength - this.maxLength;
        }
        int caretPosition = !this.scrollLock ? doc.getLength() - tooMuch : (newCaretPosition >= 0 ? newCaretPosition : 0);
        this.outputArea.setCaretPosition(caretPosition);
        if (newLength > this.maxLength) {
            try {
                doc.remove(0, newLength - this.maxLength);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

