/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.gui;

import alma.acs.commandcenter.gui.CommandCenterGui;
import alma.acs.commandcenter.util.MapTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

class EditVariablesPanel
extends JPanel {
    protected Table t1 = new Table();
    protected Table t2 = new Table();
    protected CommandCenterGui controller;
    protected Map<String, Object> writeTo;
    protected Map<String, Object> inProject;
    protected Map<String, Object> inSession;

    public EditVariablesPanel(CommandCenterGui controller) {
        super(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        JScrollPane s1 = new JScrollPane(this.t1);
        JScrollPane s2 = new JScrollPane(this.t2);
        EmptyBorder indent = new EmptyBorder(5, 5, 5, 5);
        s1.setBorder(new CompoundBorder(indent, s1.getBorder()));
        s2.setBorder(new CompoundBorder(indent, s2.getBorder()));
        p1.add(Box.createVerticalStrut(10));
        p1.add(new JLabel("Presumptively used in current project"));
        p1.add(Box.createVerticalStrut(5));
        p1.add(s1);
        p1.add(new JLabel("Previously used / Predefined"));
        p1.add(Box.createVerticalStrut(5));
        p1.add(s2);
        p1.add(Box.createVerticalStrut(10));
        this.add((Component)p1, "Center");
        String tooltip = "To edit an entry, double-click its 'Value'";
        this.t1.setToolTipText(tooltip);
        this.t2.setToolTipText(tooltip);
        Dimension size = new Dimension(450, 120);
        this.t1.setPreferredScrollableViewportSize(size);
        this.t2.setPreferredScrollableViewportSize(size);
    }

    public void preShow(Map<String, Object> writeTo, Map<String, Object> inProject, Map<String, Object> inSession) {
        this.writeTo = writeTo;
        this.inProject = inProject;
        this.inSession = inSession;
        this.t1.readModel(inProject);
        this.t2.readModel(inSession);
    }

    public void afterOk() {
        this.t1.writeModel(this.writeTo);
        this.t2.writeModel(this.writeTo);
    }

    protected class Table
    extends JTable {
        protected Table() {
            super(new MapTableModel("Name", "Value"));
            this.setShowVerticalLines(false);
        }

        protected MapTableModel model() {
            return (MapTableModel)this.getModel();
        }

        public void readModel(Map<String, Object> m) {
            this.model().setData(m);
        }

        public void writeModel(Map<String, Object> m) {
            MapTableModel tableM = this.model();
            int nRows = tableM.getRowCount();
            for (int row = 0; row < nRows; ++row) {
                String key = tableM.getValueAt(row, 0).toString();
                Object value = tableM.getValueAt(row, 1);
                if (m instanceof Hashtable && value == null) continue;
                m.put(key, value);
            }
        }
    }
}

