/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.engine;

import alma.acs.commandcenter.engine.DefaultProperties;
import alma.acs.commandcenter.engine.Executor;
import alma.acs.commandcenter.engine.NativeCommand;
import alma.acs.commandcenter.engine.RunModel;
import alma.acs.commandcenter.engine.ToolManager;
import alma.acs.commandcenter.util.MiscUtils;
import alma.acs.container.AcsContainer;
import alma.acs.container.AcsEmbeddedContainerRunner;
import alma.acs.container.corba.AcsCorba;
import alma.acs.logging.AcsLogger;
import alma.acs.util.AcsLocations;
import alma.entity.xmlbinding.acscommandcentertools.Tool;
import java.util.Properties;

public class ExecuteContainer {
    protected AcsLogger log;
    protected AcsLogger acsCorbaLogger;
    public String startLocalJavaPexpect = "components activated.";
    public String stopLocalJavaPexpect = "logged out.";
    private AcsCorba acsCorba;
    private CustomAcsEmbeddedContainerRunner customAcsEmbeddedContainerRunner;

    public ExecuteContainer() {
        this.log = MiscUtils.getPackageLogger(this);
    }

    public ExecuteContainer(AcsLogger acsCorbaLogger) {
        this.acsCorbaLogger = acsCorbaLogger;
    }

    public void startLocalJava(RunModel runModel, NativeCommand.Listener listener) {
        final String contName = runModel.getContainerName();
        String managerHost = runModel.getContainerAgainstManagerHost();
        String managerPort = runModel.getContainerAgainstManagerPort();
        final Integer orbport = Integer.valueOf(runModel.getContainerLocalJavaPort());
        final String mgrLoc = AcsLocations.convertToManagerLocation((String)managerHost, (String)managerPort);
        DefaultProperties props = new DefaultProperties();
        props.setProperty("ACS.manager", mgrLoc);
        Executor.localInProc(props, this.startLocalJavaPexpect, listener, new Executor.RunMain(){

            @Override
            public void runMain() throws Throwable {
                if (ExecuteContainer.this.acsCorba == null) {
                    if (ExecuteContainer.this.acsCorbaLogger == null) {
                        ExecuteContainer.this.acsCorbaLogger = ExecuteContainer.this.log;
                    }
                    ExecuteContainer.this.acsCorba = new AcsCorba(ExecuteContainer.this.acsCorbaLogger);
                    ExecuteContainer.this.acsCorba.initCorba(new String[0], orbport.intValue());
                    ExecuteContainer.this.acsCorba.runCorba();
                }
                ExecuteContainer.this.customAcsEmbeddedContainerRunner = new CustomAcsEmbeddedContainerRunner(ExecuteContainer.this);
                ExecuteContainer.this.customAcsEmbeddedContainerRunner.run(ExecuteContainer.this.acsCorba, contName, mgrLoc);
            }
        });
    }

    public void stopLocalJava(RunModel runModel) {
        NativeCommand.Listener listener = null;
        Properties props = new Properties();
        Executor.localInProc(props, this.stopLocalJavaPexpect, listener, new Executor.RunMain(){

            @Override
            public void runMain() {
                AcsContainer cont;
                if (ExecuteContainer.this.customAcsEmbeddedContainerRunner != null && (cont = ExecuteContainer.this.customAcsEmbeddedContainerRunner.theContainer()) != null) {
                    int action = 512;
                    cont.shutdown(action);
                }
            }
        });
    }

    public void startLocalScript(RunModel runModel, NativeCommand.Listener listener) throws Throwable {
        Object containerType = runModel.getContainerType();
        if (((String)containerType).equals("py")) {
            containerType = (String)containerType + "_unbuffered";
        }
        Tool t = ToolManager.getBuiltinTool("Container_startLocalScript_" + (String)containerType);
        String command = ToolManager.generateCommand(t, runModel);
        Executor.localOutProc(command, t.getEnviron(), true, t.getMaxStartupSeconds() * 1000L, t.getExpectedOutput(), listener);
    }

    public void stopLocalScript(RunModel runModel, NativeCommand.Listener listener) throws Throwable {
        Tool t = ToolManager.getBuiltinTool("Container_stopLocalScript_" + runModel.getContainerType());
        String command = ToolManager.generateCommand(t, runModel);
        Executor.localOutProc(command, true, t.getMaxStartupSeconds() * 1000L, t.getExpectedOutput(), listener);
    }

    public void startRemote(RunModel runModel, boolean nativeSSH, NativeCommand.Listener listener) throws Throwable {
        String host = runModel.getContainerRemoteHost();
        String username = runModel.getContainerRemoteAccount();
        String password = runModel.getContainerRemotePassword();
        Object toolname = "Container_startRemote_" + runModel.getContainerType();
        if (runModel.getContainerType().equals("cpp") && !runModel.getContainerAgainstInterfaceRepository().equals("")) {
            toolname = "Container_startRemote_cpp_intrep";
        }
        Tool t = ToolManager.getBuiltinTool((String)toolname);
        String command = ToolManager.generateCommand(t, runModel);
        this.log.finer("generated remote command: " + command);
        Executor.remote(nativeSSH, username, password, command, t.getExpectedOutput(), listener, host);
    }

    public void stopRemote(RunModel runModel, boolean nativeSSH, NativeCommand.Listener listener) throws Throwable {
        String host = runModel.getContainerRemoteHost();
        String username = runModel.getContainerRemoteAccount();
        String password = runModel.getContainerRemotePassword();
        Tool t = ToolManager.getBuiltinTool("Container_stopRemote_" + runModel.getContainerType());
        String command = ToolManager.generateCommand(t, runModel);
        Executor.remote(nativeSSH, username, password, command, t.getExpectedOutput(), listener, host);
    }

    public Exception startRemoteDemonic(RunModel runModel, NativeCommand.Listener listener) {
        String contHost = runModel.getContainerRemoteHost();
        String contName = runModel.getContainerName();
        String contType = runModel.getContainerType();
        String[] contMods = runModel.getContainerTypeModifiers();
        int instance = MiscUtils.parseInt(runModel.getContainerScriptBase());
        String mgrHost = runModel.getContainerAgainstManagerHost();
        String mgrPort = runModel.getContainerAgainstManagerPort();
        String mgrLoc = AcsLocations.convertToManagerLocation((String)mgrHost, (String)mgrPort);
        String cmdFlags = "-m " + mgrLoc;
        String contHeap = runModel.getContainerHeapSize();
        if (contHeap != null) {
            cmdFlags = cmdFlags + " --passthroughProcessStart=\"-maxHeapSize=" + contHeap + "m\"";
        }
        boolean startStop = true;
        if ("archive".equals(contType)) {
            contType = "java";
            contMods = new String[]{"archiveContainer"};
        }
        return Executor.remoteDaemonForContainers(contHost, instance, startStop, contName, contType, contMods, cmdFlags, listener);
    }

    public void stopRemoteDemonic(RunModel runModel, NativeCommand.Listener listener) {
        String contHost = runModel.getContainerRemoteHost();
        String contName = runModel.getContainerName();
        String contType = runModel.getContainerType();
        String[] contMods = runModel.getContainerTypeModifiers();
        int instance = MiscUtils.parseInt(runModel.getContainerScriptBase());
        String mgrHost = runModel.getContainerAgainstManagerHost();
        String mgrPort = runModel.getContainerAgainstManagerPort();
        String mgrLoc = AcsLocations.convertToManagerLocation((String)mgrHost, (String)mgrPort);
        String cmdFlags = "-m " + mgrLoc;
        boolean startStop = false;
        Executor.remoteDaemonForContainers(contHost, instance, startStop, contName, contType, contMods, cmdFlags, listener);
    }

    private class CustomAcsEmbeddedContainerRunner
    extends AcsEmbeddedContainerRunner {
        private CustomAcsEmbeddedContainerRunner(ExecuteContainer executeContainer) {
        }

        AcsContainer theContainer() {
            return this.m_container;
        }
    }
}

