/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.app;

import alma.acs.commandcenter.app.ProjectMaker;
import alma.acs.commandcenter.app.ProjectRunModel;
import alma.acs.commandcenter.engine.ExecuteAcs;
import alma.acs.commandcenter.engine.ExecuteContainer;
import alma.acs.commandcenter.engine.ExecuteManager;
import alma.acs.commandcenter.engine.ExecuteServices;
import alma.acs.commandcenter.engine.ExecuteTools;
import alma.acs.commandcenter.engine.ToolManager;
import alma.acs.commandcenter.gui.CommandCenterGui;
import alma.acs.commandcenter.gui.DeploymentTreeController;
import alma.acs.commandcenter.meta.Firestarter;
import alma.acs.commandcenter.meta.GuiMaciSupervisor;
import alma.acs.commandcenter.meta.IMaciSupervisor;
import alma.acs.commandcenter.util.MiscUtils;
import alma.acs.logging.AcsLogger;
import alma.acs.util.ACSPorts;
import alma.entity.xmlbinding.acscommandcenterproject.AcsCommandCenterProject;
import alma.entity.xmlbinding.acscommandcenterproject.ContainerT;
import alma.entity.xmlbinding.acscommandcentertools.AcsCommandCenterTools;
import alma.entity.xmlbinding.acscommandcentertools.Tool;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.omg.CORBA.ORB;

public class CommandCenterLogic {
    public AcsCommandCenterProject project;
    public MyProjectRunModel model;
    public StartupOptions startupOptions;
    public ExecuteServices executeServices;
    public ExecuteManager executeManager;
    public ExecuteContainer executeContainer;
    public ExecuteAcs executeAcs;
    public ExecuteTools executeTools;
    public Firestarter firestarter;
    protected CommandCenterGui gui;
    protected ProjectMaker projectMaker;
    protected AcsLogger log;
    protected String projectCreatorId;
    protected String version = null;
    protected final String HELPSET_NAME = "AcsCommandCenter.hs";
    protected HelpSet helpSet;
    public URL latestBuiltinToolsUrl;
    public URL currentExtraToolsUrl;
    private List<String> variablesDiscoveredOnTheFly = new LinkedList<String>();
    private ExecutorService bgThreads = Executors.newCachedThreadPool(new ThreadFactory(this){
        ThreadFactory def = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread ret = this.def.newThread(r);
            ret.setDaemon(true);
            return ret;
        }
    });
    public DeploymentTreeControllerImpl deploymentTreeControllerImpl;

    public void prepare(StartupOptions startupOptions) {
        URL url;
        this.startupOptions = startupOptions;
        this.log = MiscUtils.getPackageLogger(this);
        this.projectCreatorId = this.version().equals("") ? null : "acc-" + this.version();
        this.projectMaker = new ProjectMaker(this.projectCreatorId);
        this.project = this.projectMaker.createProject();
        this.model = new MyProjectRunModel(this, this.project);
        this.executeServices = new ExecuteServices(this.model);
        this.executeManager = new ExecuteManager(this.model);
        this.executeContainer = new ExecuteContainer();
        this.executeAcs = new ExecuteAcs(this.model);
        this.executeTools = new ExecuteTools(this.model);
        this.firestarter = new Firestarter("AcsCommandCenter", this.log, null);
        alma.acs.commandcenter.engine.Executor.remoteDaemonEnable(this.firestarter);
        this.deploymentTreeControllerImpl = new DeploymentTreeControllerImpl();
        this.gui = new CommandCenterGui(this);
        this.gui.prepare();
        try {
            url = this.findResource(ToolManager.getDefaultBuiltinToolsName(), "");
            this.loadBuiltinTools(url);
        }
        catch (Exception exc) {
            this.log.severe("*** FATAL: Could not read definition of built-in tools. Printing stacktrace to stderr and exiting. ***");
            exc.printStackTrace(System.err);
            this.exit(4);
        }
        try {
            url = this.findResource(ToolManager.getDefaultExtraToolsName(), "");
            this.installExtraTools(url);
        }
        catch (Exception exc) {
            this.log.info("Failed to read " + ToolManager.getDefaultExtraToolsName() + "; reason was: " + exc);
        }
        try {
            ClassLoader cl = null;
            URL url2 = this.findResource("AcsCommandCenter.hs", "");
            this.helpSet = new HelpSet(cl, url2);
        }
        catch (HelpSetException ex) {
            this.log.info("couldn't read helpset, no help available");
        }
    }

    public void go() {
        boolean admincMode = this.startupOptions.manager != null;
        this.gui.go(admincMode);
        if (admincMode) {
            this.gui.deployTree.shieldedAddManager(this.startupOptions.manager);
        }
    }

    public void stop() {
        alma.acs.commandcenter.engine.Executor.remoteDownAll();
        if (this.deploymentTreeControllerImpl != null) {
            this.deploymentTreeControllerImpl.stop();
        }
        if (this.firestarter != null) {
            this.firestarter.shutdown();
        }
        this.gui.stop();
        this.bgThreads.shutdownNow();
        this.exit(0);
    }

    public void exit(final int code) {
        this.log.fine("requested to exit with exit code '" + code + "'");
        if (this.startupOptions.doExitOnClose) {
            new Thread(this){

                @Override
                public void run() {
                    try {
                        Thread.sleep(8000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("VM still up, shooting it now.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Runtime.getRuntime().halt(code);
                }
            }.start();
            System.exit(code);
        } else {
            this.log.fine("I am configured with the no-exit option, will not shut down the VM");
        }
    }

    public String projectCreatorId() {
        return this.projectCreatorId;
    }

    public String version() {
        if (this.version == null) {
            String ret = null;
            try {
                URL u = this.getClass().getClassLoader().getResource("VERSION");
                BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream()));
                while ((ret = r.readLine()) != null && "".equals(ret = ret.trim())) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.version = ret = ret == null ? "" : ret;
        }
        return this.version;
    }

    public URL findResource(String name) {
        return this.findResource(name, "alma/acs/commandcenter/resources/");
    }

    public URL findResource(String name, String where) {
        URL ret = this.getClass().getClassLoader().getResource(where + name);
        if (ret == null) {
            this.log.fine("couldn't find resource '" + name + "' at " + where);
        } else {
            this.log.finer("found resource " + ret);
        }
        return ret;
    }

    public HelpSet getHelpSet() {
        return this.helpSet;
    }

    public void installExtraTools(URL url) throws Exception {
        InputStream s = url.openStream();
        this.installExtraTools(s);
        this.currentExtraToolsUrl = url;
    }

    protected void installExtraTools(InputStream f) throws Exception {
        ToolManager.readExtraTools(new InputStreamReader(f));
        AcsCommandCenterTools tools = ToolManager.getExtraTools();
        for (int i = 0; i < tools.getToolCount(); ++i) {
            Tool tool = tools.getTool(i);
            HashMap<String, Object> input = new HashMap<String, Object>();
            ExecuteTools.ToolStarter ts = this.executeTools.addTool(tool, input);
            this.gui.addExtraTool(tool, input, ts);
        }
    }

    public void removeExtraTools() {
        this.gui.removeAllExtraTools();
    }

    public void loadBuiltinTools(URL url) throws Exception {
        InputStream is = url.openStream();
        this.loadBuiltinTools(is);
        this.latestBuiltinToolsUrl = url;
    }

    protected void loadBuiltinTools(InputStream f) throws Exception {
        InputStreamReader r = new InputStreamReader(f);
        ToolManager.readBuiltinTools(r);
    }

    public AcsCommandCenterProject createProject() {
        return this.projectMaker.createProject();
    }

    public void loadProject(File f) {
        try {
            AcsCommandCenterProject p;
            this.project = p = this.projectMaker.loadProject(f);
            this.model.setProject(p);
            this.gui.setCurrentProjectFile(f);
            this.gui.currentProjectChanged();
        }
        catch (Exception exc) {
            this.log.info("could not load project file '" + f + "' due to " + exc);
        }
    }

    public AcsCommandCenterProject readProject(File f) throws FileNotFoundException, MarshalException, ValidationException, IOException {
        return this.projectMaker.readProject(f);
    }

    public void writeProject(AcsCommandCenterProject p, File f) throws IOException, MarshalException, ValidationException {
        this.projectMaker.writeProject(p, f);
    }

    public void moreContainers() {
        this.project.getContainers().addContainer(this.projectMaker.createContainer());
    }

    public void lessContainers() {
        if (this.project.getContainers().getContainerCount() == 0) {
            return;
        }
        int indexOfLast = this.project.getContainers().getContainerCount() - 1;
        ContainerT last = this.project.getContainers().getContainer(indexOfLast);
        this.project.getContainers().removeContainer(last);
    }

    public ContainerT removeContainer(int index) {
        if (index < 0 || index >= this.project.getContainers().getContainerCount()) {
            return null;
        }
        ContainerT cont = this.project.getContainers().getContainer(index);
        this.project.getContainers().removeContainer(cont);
        return cont;
    }

    public void insertContainer(ContainerT cont, int index) {
        this.project.getContainers().addContainer(index, cont);
    }

    public Map<String, Object>[] giveVariableMapsForGui() {
        Map<String, Object> m0;
        Map[] ret = new Map[3];
        ret[0] = m0 = this.model.getVariables();
        List<String> projectVariableNames = this.giveProjectVariableNames();
        HashMap<String, Object> m1 = new HashMap<String, Object>();
        for (String key : projectVariableNames) {
            m1.put(key, m0.get(key));
        }
        ret[1] = m1;
        HashMap<String, Object> m2 = new HashMap<String, Object>(m0);
        m2.keySet().removeAll(projectVariableNames);
        ret[2] = m2;
        return ret;
    }

    public void handleUnresolvableVariable(String name) {
        this.variablesDiscoveredOnTheFly.add(name);
        this.gui.showUnresolvableVariableErrorDialog(name);
    }

    public List<String> giveProjectVariableNames() {
        LinkedList<String> ret = new LinkedList<String>();
        this.scanForVariables(this.project, ret);
        ret.addAll(this.variablesDiscoveredOnTheFly);
        return ret;
    }

    private void scanForVariables(Object[] xx, List<String> l) {
        for (int i = 0; i < xx.length; ++i) {
            this.scanForVariables(xx[i], l);
        }
    }

    private void scanForVariables(Object x, List<String> l) {
        Method[] mm = x.getClass().getDeclaredMethods();
        for (int i = 0; i < mm.length; ++i) {
            Method m = mm[i];
            if (!m.getName().startsWith("get") || (m.getModifiers() & 1) == 0 || m.getParameterTypes().length != 0) continue;
            Object rv = null;
            try {
                rv = m.invoke(x, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (rv == null) continue;
            if (rv instanceof String) {
                this.scanForVariables((String)rv, 0, l);
            } else if (rv instanceof Object[]) {
                this.scanForVariables((Object[])rv, l);
            }
            if (!(rv instanceof Object)) continue;
            this.scanForVariables(rv, l);
        }
    }

    private void scanForVariables(String s, int i, List<String> l) {
        int markerEnd;
        int markerStart = s.indexOf("${", i);
        if (markerStart != -1 && (markerEnd = s.indexOf("}", markerStart)) != -1) {
            String embeddedVarName = s.substring(markerStart + 2, markerEnd);
            l.add(embeddedVarName);
            this.scanForVariables(s, markerEnd + 1, l);
        }
    }

    public void runBackground(Runnable r) {
        this.bgThreads.execute(r);
    }

    public static class StartupOptions {
        public Rectangle geometry;
        public File project;
        public String manager;
        public boolean doExitOnClose = true;
    }

    public class MyProjectRunModel
    extends ProjectRunModel {
        public MyProjectRunModel(CommandCenterLogic this$0, AcsCommandCenterProject project) {
            super(project);
        }

        @Override
        public String getManagerLocalJavaAgainstCDBHost() {
            return ACSPorts.getIP();
        }
    }

    public class DeploymentTreeControllerImpl
    implements DeploymentTreeController {
        private Map<String, GuiMaciSupervisor> managerLoc2instance = new WeakHashMap<String, GuiMaciSupervisor>();

        @Override
        public synchronized GuiMaciSupervisor giveMaciSupervisor(String managerLoc) throws Firestarter.OrbInitException {
            GuiMaciSupervisor ret = this.managerLoc2instance.get(managerLoc);
            if (ret == null) {
                ORB orb = CommandCenterLogic.this.firestarter.giveOrb();
                ret = new GuiMaciSupervisor("AcsCommandCenter", managerLoc, orb, (Logger)CommandCenterLogic.this.log);
                ret.setRefreshesPeriodically(true);
                this.managerLoc2instance.put(managerLoc, ret);
            }
            return ret;
        }

        @Override
        public Executor getBackgroundExecutor() {
            return CommandCenterLogic.this.bgThreads;
        }

        public synchronized void stop() {
            for (IMaciSupervisor iMaciSupervisor : this.managerLoc2instance.values()) {
                try {
                    iMaciSupervisor.stop();
                }
                catch (Exception exception) {}
            }
        }
    }
}

