/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ValueConverter {
    private final String name_;
    private static final Pattern SEX_PATTERN = Pattern.compile(" *([+\\-]?) *([0-9]+) *[: ] *([0-9]+) *[: ] *([0-9]+\\.?[0-9]*) *");

    public ValueConverter(String name) {
        this.name_ = name;
    }

    public abstract double convertValue(String var1);

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.getName();
    }

    private static double dmsToDegrees(String dms) {
        Matcher matcher = SEX_PATTERN.matcher(dms);
        if (!matcher.matches()) {
            throw new NumberFormatException("\"" + dms + "\" not sexagesimal");
        }
        try {
            double sign = "-".equals(matcher.group(1)) ? -1.0 : 1.0;
            int deg = Integer.parseInt(matcher.group(2));
            int min = Integer.parseInt(matcher.group(3));
            double sec = Double.parseDouble(matcher.group(4));
            return sign * ((double)deg + ((double)min + sec / 60.0) / 60.0);
        }
        catch (IllegalArgumentException e) {
            throw new NumberFormatException("\"" + dms + "\" not sexagesimal");
        }
    }

    public static class HMSDegreesValueConverter
    extends ValueConverter {
        public HMSDegreesValueConverter() {
            super("hh:mm:ss");
        }

        public double convertValue(String sval) {
            return 15.0 * ValueConverter.dmsToDegrees(sval);
        }
    }

    public static class DMSDegreesValueConverter
    extends ValueConverter {
        public DMSDegreesValueConverter() {
            super("dd:mm:ss");
        }

        public double convertValue(String sval) {
            return ValueConverter.dmsToDegrees(sval);
        }
    }

    public static class UnitValueConverter
    extends ValueConverter {
        private final double factor_;

        public UnitValueConverter(String name, double factor) {
            super(name);
            this.factor_ = factor;
        }

        public double convertValue(String sval) {
            return Double.parseDouble(sval) * this.factor_;
        }
    }
}

