/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.vo.DoubleValueField;
import uk.ac.starlink.vo.ResolverException;
import uk.ac.starlink.vo.ResolverInfo;
import uk.ac.starlink.vo.ValueFieldPanel;

public class SkyPositionEntry
extends JPanel {
    private final Action resolveAction_;
    private final DoubleValueField raField_;
    private final DoubleValueField decField_;
    private final ValueFieldPanel qPanel_;
    private final List fieldList_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public SkyPositionEntry(String coordSysLabel) {
        super(new BorderLayout());
        Box box = Box.createVerticalBox();
        this.add((Component)box, "Center");
        Box resolveBox = Box.createHorizontalBox();
        JTextField resolveField = new JTextField(20);
        this.resolveAction_ = new ResolveAction(resolveField);
        resolveBox.add(new JLabel("Object Name: "));
        resolveBox.add(resolveField);
        resolveBox.add(Box.createHorizontalStrut(5));
        resolveBox.add(new JButton(this.resolveAction_));
        resolveBox.add(Box.createHorizontalGlue());
        box.add(resolveBox);
        box.add(Box.createVerticalStrut(5));
        this.raField_ = DoubleValueField.makeRADegreesField();
        this.decField_ = DoubleValueField.makeDecDegreesField();
        String sysLabel = coordSysLabel == null || coordSysLabel.trim().length() == 0 ? null : "(" + coordSysLabel + ")";
        this.qPanel_ = new ValueFieldPanel();
        this.qPanel_.addField(this.raField_, sysLabel == null ? null : new JLabel(sysLabel));
        this.qPanel_.addField(this.decField_, sysLabel == null ? null : new JLabel(sysLabel));
        box.add(this.qPanel_);
        this.fieldList_ = new ArrayList();
        this.fieldList_.add(this.raField_);
        this.fieldList_.add(this.decField_);
    }

    public void addField(DoubleValueField field) {
        this.qPanel_.addField(field);
        this.fieldList_.add(field);
    }

    public DoubleValueField getRaDegreesField() {
        return this.raField_;
    }

    public DoubleValueField getDecDegreesField() {
        return this.decField_;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Iterator it = this.fieldList_.iterator();
        while (it.hasNext()) {
            ((DoubleValueField)it.next()).setEnabled(enabled);
        }
    }

    public void addActionListener(ActionListener listener) {
        Iterator it = this.fieldList_.iterator();
        while (it.hasNext()) {
            ((DoubleValueField)it.next()).getEntryField().addActionListener(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        Iterator it = this.fieldList_.iterator();
        while (it.hasNext()) {
            ((DoubleValueField)it.next()).getEntryField().removeActionListener(listener);
        }
    }

    private void setResolvedObject(ResolverInfo info) {
        this.setDegrees(this.raField_, info.getRaDegrees());
        this.setDegrees(this.decField_, info.getDecDegrees());
    }

    private void setDegrees(DoubleValueField field, double degValue) {
        JComboBox convSel = field.getConverterSelector();
        for (int i = 0; i < convSel.getItemCount(); ++i) {
            Object item = convSel.getItemAt(i);
            if (!"degrees".equals(item.toString())) continue;
            convSel.setSelectedItem(item);
            field.getEntryField().setText(Double.toString(degValue));
            return;
        }
        logger_.warning("Oops - no degrees option");
    }

    private class ResolveAction
    extends AbstractAction {
        final JTextField resolveField_;

        ResolveAction(JTextField field) {
            super("Resolve");
            this.resolveField_ = field;
            this.resolveField_.addActionListener(this);
        }

        public void actionPerformed(ActionEvent evt) {
            final String name = this.resolveField_.getText();
            if (name != null && name.trim().length() == 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.setEnabled(false);
            new Thread("Name Resolver: " + name){

                public void run() {
                    ResolverInfo info = null;
                    ResolverException error = null;
                    try {
                        info = ResolverInfo.resolve(name);
                    }
                    catch (ResolverException e) {
                        error = e;
                    }
                    final ResolverInfo info1 = info;
                    final ResolverException error1 = error;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (info1 != null) {
                                SkyPositionEntry.this.setResolvedObject(info1);
                            } else {
                                ErrorDialog.showError((Component)SkyPositionEntry.this, (String)"Name Resolution Error", (Throwable)error1);
                            }
                            ResolveAction.this.setEnabled(true);
                        }
                    });
                }
            }.start();
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.resolveField_.setEnabled(enabled);
        }
    }
}

