/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Container;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.vo.MetaColumnModel;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.ResourceTableModel;

public class RegistryTable
extends JTable {
    private final ResourceTableModel tModel_ = new ResourceTableModel();
    private final MetaColumnModel colModel_;
    private static String[] DEFAULT_COLUMNS = new String[]{"shortName", "title"};

    public RegistryTable() {
        this.setModel(this.tModel_);
        this.colModel_ = RegistryTable.makeMetaColumnModel(this.getColumnModel(), this.tModel_, DEFAULT_COLUMNS);
        this.colModel_.addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent evt) {
                StarJTable.configureColumnWidth((JTable)RegistryTable.this, (int)1000, (int)1000, (int)evt.getToIndex());
                RegistryTable.this.reconfigureResizeMode();
                int from = evt.getToIndex();
                int to = RegistryTable.this.colModel_.getColumnCount() - 1;
            }

            public void columnRemoved(TableColumnModelEvent evt) {
                RegistryTable.this.reconfigureResizeMode();
            }

            public void columnMarginChanged(ChangeEvent evt) {
            }

            public void columnMoved(TableColumnModelEvent evt) {
            }

            public void columnSelectionChanged(ListSelectionEvent evt) {
            }
        });
        this.setColumnModel(this.colModel_);
    }

    public void setData(RegResource[] data) {
        this.tModel_.setResources(data);
        this.colModel_.purgeEmptyColumns();
        StarJTable.configureColumnWidths((JTable)this, (int)1000, (int)10000);
    }

    public RegResource[] getData() {
        return this.tModel_.getResources();
    }

    public MetaColumnModel getMetaColumnModel() {
        return this.colModel_;
    }

    private void reconfigureResizeMode() {
        Container holder = this.getParent();
        if (holder instanceof JViewport) {
            int cwidth = 0;
            TableColumnModel cmodel = this.getColumnModel();
            for (int i = 0; i < cmodel.getColumnCount(); ++i) {
                cwidth += cmodel.getColumn(i).getPreferredWidth();
            }
            this.setAutoResizeMode(cwidth <= holder.getSize().width ? 4 : 0);
        }
    }

    private static MetaColumnModel makeMetaColumnModel(TableColumnModel cmodel, TableModel tmodel, Object[] initcols) {
        int ic;
        int nfix = 0;
        block0: for (int iv = 0; iv < initcols.length; ++iv) {
            for (ic = nfix; ic < cmodel.getColumnCount(); ++ic) {
                TableColumn col = cmodel.getColumn(ic);
                if (!initcols[iv].equals(col.getHeaderValue())) continue;
                cmodel.moveColumn(ic, nfix++);
                continue block0;
            }
        }
        MetaColumnModel mcmodel = new MetaColumnModel(cmodel, tmodel);
        for (ic = mcmodel.getColumnCount() - 1; ic >= nfix; --ic) {
            mcmodel.removeColumn(mcmodel.getColumn(ic));
        }
        return mcmodel;
    }
}

