/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

public final class JNaming {
    private static final String[] KEYWORDS = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final String[] COLLECTIONS = new String[]{"ArrayList", "List", "Set", "Collection", "Vector", "Hashtable", "Map", "HashMap", "HashSet", "TreeSet", "Enumeration", "Iterator", "ListIterator", "SortedSet", "SortedMap", "Queue", "EnumSet", "EnumMap", "IdentityHashMap", "LinkedHashMap", "LinkedHashSet", "LinkedList", "Stack", "TreeMap", "WeakHashMap"};
    private static final String[] JAVA_LANG = new String[]{"Appendable", "CharSequence", "Cloneable", "Comparable", "Iterable", "Readable", "Runnable", "Boolean", "Byte", "Character", "Class", "ClassLoader", "Compiler", "Double", "Enum", "Float", "InheritableThreadLocal", "Integer", "Long", "Math", "Number", "Object", "Package", "Process", "ProcessBuilder", "Runtime", "RuntimePermission", "SecurityManager", "Short", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "System", "Thread", "ThreadGroup", "ThreadLocal", "Throwable", "Void", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "ClassCastException", "ClassNotFoundException", "CloneNotSupportedException", "EnumConstantNotPresentException", "Exception", "IllegalAccessException", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IndexOutOfBoundsException", "InstantiationException", "InterruptedException", "NegativeArraySizeException", "NoSuchFieldException", "NoSuchMethodException", "NullPointerException", "NumberFormatException", "RuntimeException", "SecurityException", "StringIndexOutOfBoundsException", "TypeNotPresentException", "UnsupportedOperationException", "AbstractMethodError", "AssertionError", "ClassCircularityError", "ClassFormatError", "Error", "ExceptionInInitializerError", "IllegalAccessError", "IncompatibleClassChangeError", "InstantiationError", "InternalError", "LinkageError", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchMethodError", "OutOfMemoryError", "StackOverflowError", "ThreadDeath", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "VerifyError", "VirtualMachineError", "Deprecated", "Override", "SuppressWarnings"};
    private static final String[] CASTOR_RESERVED = new String[]{"Content", "MenuItem"};
    private static final String[] WINDOWS_RESERVED = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    private JNaming() {
    }

    public static boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        for (String keyword : KEYWORDS) {
            if (!keyword.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isParameterizedCollectionsObject(String name) {
        if (name == null) {
            return false;
        }
        for (String collection : COLLECTIONS) {
            if (name.indexOf(collection) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isInJavaLang(String name) {
        if (name == null) {
            return false;
        }
        for (String javaLang : JAVA_LANG) {
            if (!javaLang.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReservedByCastor(String name) {
        if (name == null) {
            return false;
        }
        for (String reserved : CASTOR_RESERVED) {
            if (!reserved.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReservedByWindows(String name) {
        if (name == null) {
            return false;
        }
        for (String windowsReserved : WINDOWS_RESERVED) {
            if (!windowsReserved.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] chars = string.toCharArray();
        if (JNaming.isParameterizedCollectionsObject(string)) {
            return true;
        }
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (char ch : chars) {
            if (Character.isJavaIdentifierPart(ch)) continue;
            return false;
        }
        return !JNaming.isKeyword(string);
    }

    public static String getPackageFromClassName(String className) {
        if (className == null) {
            return null;
        }
        int idx = className.lastIndexOf(46);
        if (idx > 0) {
            return className.substring(0, idx);
        }
        return null;
    }

    public static String getLocalNameFromClassName(String className) {
        if (className == null) {
            return null;
        }
        int idx = className.lastIndexOf(46);
        if (idx > 0) {
            return className.substring(idx + 1);
        }
        return className;
    }
}

