/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.HashSet;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.xml.EventProducer;
import org.exolab.castor.xml.NamespacesStack;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class AnyNode2SAX
implements EventProducer {
    private AnyNode _node;
    private DocumentHandler _handler;
    private HashSet _elements = new HashSet();
    private NamespacesStack namespacesStack;

    public AnyNode2SAX() {
        this(null, null);
    }

    public AnyNode2SAX(AnyNode node) {
        this(node, null);
    }

    public AnyNode2SAX(AnyNode node, NamespacesStack namespacesStack) {
        this._node = node;
        this.namespacesStack = namespacesStack != null ? namespacesStack : new NamespacesStack();
    }

    @Override
    public void setDocumentHandler(DocumentHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("AnyNode2SAX#setDocumentHandler 'null' value for handler");
        }
        this._handler = handler;
    }

    public static void fireEvents(AnyNode node, DocumentHandler handler) throws SAXException {
        AnyNode2SAX.fireEvents(node, handler, null);
    }

    public static void fireEvents(AnyNode node, DocumentHandler handler, NamespacesStack namespacesStack) throws SAXException {
        AnyNode2SAX eventProducer = new AnyNode2SAX(node, namespacesStack);
        eventProducer.setDocumentHandler(handler);
        eventProducer.start();
    }

    @Override
    public void start() throws SAXException {
        if (this._node == null || this._handler == null) {
            return;
        }
        this.processAnyNode(this._node, this._handler);
    }

    private void processAnyNode(AnyNode node, DocumentHandler handler) throws SAXException {
        String value;
        if (node == null || handler == null) {
            throw new IllegalArgumentException();
        }
        if (!this._elements.add(node)) {
            return;
        }
        if (node.getNodeType() == 1) {
            int len;
            AnyNode tempNode;
            String name = node.getLocalName();
            AttributeListImpl atts = new AttributeListImpl();
            Object xmlName = null;
            String value2 = null;
            String attUri = null;
            String attPrefix = null;
            for (tempNode = node.getFirstAttribute(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                xmlName = tempNode.getLocalName();
                attUri = tempNode.getNamespaceURI();
                if (attUri != null) {
                    attPrefix = this.namespacesStack.getNamespacePrefix(attUri);
                }
                if (attPrefix != null && attPrefix.length() > 0) {
                    xmlName = attPrefix + ":" + (String)xmlName;
                }
                value2 = tempNode.getStringValue();
                atts.addAttribute((String)xmlName, "CDATA", value2);
            }
            this.namespacesStack.addNewNamespaceScope();
            String nsPrefix = node.getNamespacePrefix();
            String nsURI = node.getNamespaceURI();
            String prefix = null;
            for (tempNode = node.getFirstNamespace(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                prefix = tempNode.getNamespacePrefix();
                value2 = tempNode.getNamespaceURI();
                if (value2 == null || value2.length() <= 0) continue;
                this.namespacesStack.addNamespace(prefix, value2);
            }
            Object qName = null;
            if (nsURI != null && nsURI.length() > 0) {
                String tempPrefix = this.namespacesStack.getNamespacePrefix(nsURI);
                if (tempPrefix != null) {
                    nsPrefix = tempPrefix;
                } else {
                    this.namespacesStack.addNamespace(nsPrefix, nsURI);
                }
            }
            qName = nsPrefix != null ? ((len = nsPrefix.length()) > 0 ? nsPrefix + ":" + name : name) : name;
            try {
                this.namespacesStack.declareAsAttributes(atts, true);
                handler.startElement((String)qName, atts);
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
            for (tempNode = node.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                this.processAnyNode(tempNode, handler);
            }
            try {
                handler.endElement((String)qName);
                this.namespacesStack.removeNamespaceScope();
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
        }
        if (node.getNodeType() == 6 && (value = node.getStringValue()) != null && value.length() > 0) {
            char[] chars = value.toCharArray();
            try {
                handler.characters(chars, 0, chars.length);
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
        }
    }
}

