/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.castor.core.util.Assert;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public final class Namespaces {
    public static final String XML_NAMESPACE_PREFIX = "xml";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String CDATA = "CDATA";
    private static final String XMLNS = "xmlns";
    private final List<Namespace> namespaces = new ArrayList<Namespace>();
    private final Map<String, Namespace> namespaceMap = new HashMap<String, Namespace>();

    public Namespaces() {
        this.namespaceMap.put(XML_NAMESPACE_PREFIX, new Namespace(XML_NAMESPACE_PREFIX, XML_NAMESPACE));
    }

    public synchronized void addNamespace(String prefix, String uri) {
        Assert.notNull(uri, "Namespace URI must not be null");
        if (prefix == null) {
            prefix = "";
        }
        if (XML_NAMESPACE_PREFIX.equalsIgnoreCase(prefix)) {
            if (!XML_NAMESPACE.equals(uri)) {
                String err = "The prefix 'xml' is reserved (XML 1.0 Specification) and cannot be declared.";
                throw new IllegalArgumentException(err);
            }
            return;
        }
        if (XML_NAMESPACE.equals(uri)) {
            Object err = "The namespace 'http://www.w3.org/XML/1998/namespace";
            err = (String)err + "' is reserved (XML 1.0 Specification) and cannot be declared.";
            throw new IllegalArgumentException((String)err);
        }
        if (this.namespaceMap.containsKey(prefix)) {
            this.namespaceMap.get(prefix).setUri(uri);
        } else {
            Namespace namespace = new Namespace(prefix, uri);
            this.namespaces.add(namespace);
            this.namespaceMap.put(prefix, namespace);
        }
    }

    public Enumeration<String> getLocalNamespaces() {
        return new NamespaceEnumerator(this.namespaces.iterator());
    }

    public String getNamespaceURI(String prefix) {
        Namespace namespace;
        if (prefix == null) {
            prefix = "";
        }
        if ((namespace = this.namespaceMap.get(prefix)) != null) {
            return namespace.getUri();
        }
        return null;
    }

    public String getNamespacePrefix(String nsURI) {
        Assert.notNull(nsURI, "Namespace URI must not be null.");
        for (Namespace namespace : this.namespaces) {
            if (!nsURI.equals(namespace.getUri())) continue;
            return namespace.getPrefix();
        }
        if (XML_NAMESPACE.equals(nsURI)) {
            return XML_NAMESPACE_PREFIX;
        }
        return null;
    }

    public Enumeration<String> getLocalNamespacePrefixes() {
        return new NamespaceEnumerator(this.namespaces.iterator(), 1);
    }

    public String[] getNamespacePrefixes(String nsURI) {
        Assert.notNull(nsURI, "Namespace URI must not be null.");
        ArrayList<String> prefixes = new ArrayList<String>();
        for (Namespace namespace : this.namespaces) {
            if (!namespace.getUri().equals(nsURI)) continue;
            prefixes.add(namespace.getPrefix());
        }
        return prefixes.toArray(new String[0]);
    }

    public String getNonDefaultNamespacePrefix(String nsURI) {
        Assert.notNull(nsURI, "Namespace URI must not be null.");
        for (Namespace namespace : this.namespaces) {
            if (!nsURI.equals(namespace.getUri()) || namespace.getPrefix().length() <= 0) continue;
            return namespace.getPrefix();
        }
        if (XML_NAMESPACE.equals(nsURI)) {
            return XML_NAMESPACE_PREFIX;
        }
        return null;
    }

    public synchronized boolean removeNamespace(String prefix) {
        if (prefix == null) {
            return false;
        }
        if (this.namespaceMap.containsKey(prefix)) {
            Namespace namespace = this.namespaceMap.get(prefix);
            this.namespaceMap.remove(prefix);
            this.namespaces.remove(namespace);
            return true;
        }
        return false;
    }

    public void sendEndEvents(ContentHandler handler) throws SAXException {
        for (Namespace namespace : this.namespaces) {
            handler.endPrefixMapping(namespace.getPrefix());
        }
    }

    public void sendStartEvents(ContentHandler handler) throws SAXException {
        for (Namespace namespace : this.namespaces) {
            handler.startPrefixMapping(namespace.getPrefix(), namespace.getUri());
        }
    }

    public void declareAsAttributes(AttributeListImpl atts) {
        String attName = null;
        for (Namespace ns : this.namespaces) {
            if (ns.prefix != null) {
                int len = ns.prefix.length();
                if (len > 0) {
                    attName = new StringBuilder(6 + len).append(XMLNS).append(':').append(ns.prefix).toString();
                    atts.addAttribute(attName, CDATA, ns.uri);
                    continue;
                }
                atts.addAttribute(XMLNS, CDATA, ns.uri);
                continue;
            }
            atts.addAttribute(XMLNS, CDATA, ns.uri);
        }
    }

    class Namespace {
        private String uri;
        private String prefix;

        Namespace() {
        }

        Namespace(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Namespace namespace = (Namespace)object;
            if (this.prefix != null ? !this.prefix.equals(namespace.prefix) : namespace.prefix != null) {
                return false;
            }
            return !(this.uri != null ? !this.uri.equals(namespace.uri) : namespace.uri != null);
        }

        public int hashCode() {
            int result = this.prefix != null ? this.prefix.hashCode() : 0;
            result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
            return result;
        }
    }

    static class NamespaceEnumerator
    implements Enumeration<String> {
        public static final int URI = 0;
        public static final int PREFIX = 1;
        private int _returnType = 0;
        private Iterator<Namespace> namespaceIterator;

        NamespaceEnumerator(Iterator<Namespace> namespaceIterator) {
            this.namespaceIterator = namespaceIterator;
        }

        NamespaceEnumerator(Iterator<Namespace> namespaceIterator, int returnType) {
            this.namespaceIterator = namespaceIterator;
            this._returnType = returnType;
        }

        @Override
        public boolean hasMoreElements() {
            return this.namespaceIterator.hasNext();
        }

        @Override
        public String nextElement() {
            Namespace ns = this.namespaceIterator.next();
            String result = this._returnType == 0 ? ns.getUri() : ns.getPrefix();
            return result;
        }
    }
}

