/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.DateTime;
import org.exolab.castor.types.Duration;

public abstract class DateTimeBase
implements Serializable,
Cloneable {
    public static final int INDETERMINATE = -1;
    public static final int LESS_THAN = 0;
    public static final int EQUALS = 1;
    public static final int GREATER_THAN = 2;
    protected static final int MAX_TIME_ZONE_COMPARISON_OFFSET = 14;
    protected static final String WRONGLY_PLACED = " is wrongly placed.";
    private boolean _isNegative = false;
    private short _century = 0;
    private short _year = 0;
    private short _month = 0;
    private short _day = 0;
    private short _hour = 0;
    private short _minute = 0;
    private short _second = 0;
    private short _millsecond = 0;
    private boolean _zoneNegative = false;
    private boolean _utc = false;
    private short _zoneHour = 0;
    private short _zoneMinute = 0;

    public abstract Date toDate();

    public abstract void setValues(short[] var1);

    public abstract short[] getValues();

    public final boolean isLeap(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private final boolean isLeap(short century, short year) {
        return this.isLeap(century * 100 + year);
    }

    public void setNegative() throws UnsupportedOperationException {
        this._isNegative = true;
    }

    public void setCentury(short century) throws UnsupportedOperationException {
        Object err = "";
        if (century < 0) {
            err = "century " + century + " must not be negative.";
            throw new IllegalArgumentException((String)err);
        }
        if (this._year == 0 && century == 0 && this._century != 0) {
            err = "century:  0000 is not an allowed year.";
            throw new IllegalArgumentException((String)err);
        }
        this._century = century;
    }

    public void setYear(short year) throws UnsupportedOperationException {
        Object err = "";
        if (year < 0) {
            err = "year " + year + " must not be negative.";
            throw new IllegalArgumentException((String)err);
        }
        if (year == -1) {
            if (this._century != -1) {
                err = "year can not be omitted unless century is also omitted.";
                throw new IllegalArgumentException((String)err);
            }
        } else {
            if (year == 0 && this._century == 0) {
                err = "year:  0000 is not an allowed year";
                throw new IllegalArgumentException((String)err);
            }
            if (year > 99) {
                err = "year " + year + " is out of range:  0 <= year <= 99.";
                throw new IllegalArgumentException((String)err);
            }
        }
        this._year = year;
    }

    public void setMonth(short month) throws UnsupportedOperationException {
        Object err = "";
        if (month == -1) {
            if (this._century != -1) {
                err = "month cannot be omitted unless the previous component is also omitted.\nonly higher level components can be omitted.";
                throw new IllegalArgumentException((String)err);
            }
        } else if (month < 1 || month > 12) {
            err = "month " + month + " is out of range:  1 <= month <= 12";
            throw new IllegalArgumentException((String)err);
        }
        this._month = month;
    }

    public void setDay(short day) throws UnsupportedOperationException {
        short maxDay;
        Object err = "";
        if (day == -1) {
            if (this._month != -1) {
                err = "day cannot be omitted unless the previous component is also omitted.\nonly higher level components can be omitted.";
                throw new IllegalArgumentException((String)err);
            }
        } else if (day < 1) {
            err = "day " + day + " cannot be negative.";
            throw new IllegalArgumentException((String)err);
        }
        if (day > (maxDay = this.maxDayInMonthFor(this._century, this._year, this._month))) {
            if (this._month != 2) {
                err = "day " + day + " is out of range for month " + this._month + ":  1 <= day <= " + maxDay;
                throw new IllegalArgumentException((String)err);
            }
            if (this.isLeap(this._century, this._year)) {
                err = "day " + day + " is out of range for February in a leap year:  1 <= day <= 29";
                throw new IllegalArgumentException((String)err);
            }
            err = "day " + day + " is out of range for February in a non-leap year:  1 <= day <= 28";
            throw new IllegalArgumentException((String)err);
        }
        this._day = day;
    }

    public void setHour(short hour) throws UnsupportedOperationException {
        if (hour > 23) {
            String err = "hour " + hour + " must be strictly less than 24";
            throw new IllegalArgumentException(err);
        }
        if (hour < 0) {
            String err = "hour " + hour + " cannot be negative.";
            throw new IllegalArgumentException(err);
        }
        this._hour = hour;
    }

    public void setMinute(short minute) throws UnsupportedOperationException {
        if (minute > 59) {
            String err = "minute " + minute + " must be strictly less than 60.";
            throw new IllegalArgumentException(err);
        }
        if (minute < 0) {
            String err = "minute " + minute + " cannot be negative.";
            throw new IllegalArgumentException(err);
        }
        this._minute = minute;
    }

    public void setSecond(short second, short millsecond) throws UnsupportedOperationException {
        this.setSecond(second);
        this.setMilliSecond(millsecond);
    }

    public void setSecond(short second) throws UnsupportedOperationException {
        if (second > 59) {
            String err = "seconds " + second + " must be less than 60";
            throw new IllegalArgumentException(err);
        }
        if (second < 0) {
            String err = "seconds " + second + " cannot be negative.";
            throw new IllegalArgumentException(err);
        }
        this._second = second;
    }

    public void setMilliSecond(short millisecond) throws UnsupportedOperationException {
        if (millisecond < 0) {
            String err = "milliseconds " + millisecond + " cannot be negative.";
            throw new IllegalArgumentException(err);
        }
        if (millisecond > 999) {
            String err = "milliseconds " + millisecond + " is out of bounds: 0 <= milliseconds <= 999.";
            throw new IllegalArgumentException(err);
        }
        this._millsecond = millisecond;
    }

    public void setUTC() {
        this._utc = true;
    }

    public void setZoneNegative(boolean zoneNegative) {
        this._zoneNegative = zoneNegative;
    }

    public void setZone(short hour, short minute) {
        this.setZoneHour(hour);
        this.setZoneMinute(minute);
    }

    public void setZoneHour(short hour) {
        if (hour > 23) {
            String err = "time zone hour " + hour + " must be strictly less than 24";
            throw new IllegalArgumentException(err);
        }
        if (hour < 0) {
            String err = "time zone hour " + hour + " cannot be negative.";
            throw new IllegalArgumentException(err);
        }
        this._zoneHour = hour;
        this.setUTC();
    }

    public void setZoneMinute(short minute) {
        if (minute > 59) {
            String err = "time zone minute " + minute + " must be strictly lower than 60";
            throw new IllegalArgumentException(err);
        }
        if (minute < 0) {
            String err = "time zone minute " + minute + " cannot be negative.";
            throw new IllegalArgumentException(err);
        }
        this._zoneMinute = minute;
        this.setUTC();
    }

    public boolean isNegative() throws UnsupportedOperationException {
        return this._isNegative;
    }

    public short getCentury() throws UnsupportedOperationException {
        return this._century;
    }

    public short getYear() throws UnsupportedOperationException {
        return this._year;
    }

    public short getMonth() throws UnsupportedOperationException {
        return this._month;
    }

    public short getDay() throws UnsupportedOperationException {
        return this._day;
    }

    public short getHour() throws UnsupportedOperationException {
        return this._hour;
    }

    public short getMinute() throws UnsupportedOperationException {
        return this._minute;
    }

    public short getSeconds() throws UnsupportedOperationException {
        return this._second;
    }

    public short getMilli() throws UnsupportedOperationException {
        return this._millsecond;
    }

    public boolean isUTC() {
        return this._utc;
    }

    public boolean isZoneNegative() {
        return this._zoneNegative;
    }

    public short getZoneHour() {
        return this._zoneHour;
    }

    public short getZoneMinute() {
        return this._zoneMinute;
    }

    public boolean hasIsNegative() {
        return true;
    }

    public boolean hasCentury() {
        return true;
    }

    public boolean hasYear() {
        return true;
    }

    public boolean hasMonth() {
        return true;
    }

    public boolean hasDay() {
        return true;
    }

    public boolean hasHour() {
        return true;
    }

    public boolean hasMinute() {
        return true;
    }

    public boolean hasSeconds() {
        return true;
    }

    public boolean hasMilli() {
        return true;
    }

    public void addDuration(Duration duration) {
        int temp = 0;
        int carry = 0;
        int sign = duration.isNegative() ? -1 : 1;
        try {
            temp = this._month + sign * duration.getMonth();
            carry = this.fQuotient(temp - 1, 12);
            this.setMonth((short)(this.modulo(temp - 1, 12) + 1));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            temp = this._century * 100 + this._year + sign * duration.getYear() + carry;
            this.setCentury((short)(temp / 100));
            this.setYear((short)(temp % 100));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        int tempDay = this._day;
        if (tempDay < 1) {
            tempDay = 1;
        } else {
            int maxDay = this.maxDayInMonthFor(this._century, this._year, this._month);
            if (this._day > maxDay) {
                tempDay = maxDay;
            }
        }
        try {
            temp = this._millsecond + sign * (int)duration.getMilli();
            carry = this.fQuotient(temp, 1000);
            this.setMilliSecond((short)this.modulo(temp, 1000));
            temp = this._second + sign * duration.getSeconds() + carry;
            carry = this.fQuotient(temp, 60);
            this.setSecond((short)this.modulo(temp, 60));
        }
        catch (UnsupportedOperationException maxDay) {
            // empty catch block
        }
        try {
            temp = this._minute + sign * duration.getMinute() + carry;
            carry = this.fQuotient(temp, 60);
            this.setMinute((short)this.modulo(temp, 60));
        }
        catch (UnsupportedOperationException maxDay) {
            // empty catch block
        }
        try {
            temp = this._hour + sign * duration.getHour() + carry;
            carry = this.fQuotient(temp, 24);
            this.setHour((short)this.modulo(temp, 24));
        }
        catch (UnsupportedOperationException maxDay) {
            // empty catch block
        }
        try {
            tempDay += sign * duration.getDay() + carry;
            while (true) {
                short maxDay = this.maxDayInMonthFor(this._century, this._year, this._month);
                if (tempDay < 1) {
                    tempDay = (short)(tempDay + this.maxDayInMonthFor(this._century, this._year, this._month - 1));
                    carry = -1;
                } else {
                    if (tempDay <= maxDay) break;
                    tempDay = (short)(tempDay - maxDay);
                    carry = 1;
                }
                try {
                    temp = this._month + carry;
                    this.setMonth((short)(this.modulo(temp - 1, 12) + 1));
                    temp = this.getCentury() * 100 + this.getYear() + this.fQuotient(temp - 1, 12);
                    this.setCentury((short)(temp / 100));
                    this.setYear((short)(temp % 100));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            this.setDay((short)tempDay);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private int fQuotient(int a, int b) {
        return (int)Math.floor((float)a / (float)b);
    }

    private int modulo(int a, int b) {
        return a - this.fQuotient(a, b) * b;
    }

    private final short maxDayInMonthFor(short century, short year, int month) {
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            return (short)(this.isLeap(century, year) ? 29 : 28);
        }
        return 31;
    }

    public void normalize() {
        if (!this.isUTC() || this._zoneHour == 0 && this._zoneMinute == 0) {
            return;
        }
        Duration temp = new Duration();
        temp.setHour(this._zoneHour);
        temp.setMinute(this._zoneMinute);
        if (!this.isZoneNegative()) {
            temp.setNegative();
        }
        this.addDuration(temp);
        this.setZone((short)0, (short)0);
        this.setZoneNegative(false);
    }

    public int compareTo(DateTimeBase dateTime) {
        DateTimeBase tempDate2;
        DateTimeBase tempDate1;
        if (dateTime == null) {
            throw new IllegalArgumentException("a Date/Time datatype cannot be compared with a null value");
        }
        try {
            tempDate1 = this.clone(this);
            if (tempDate1.isUTC()) {
                tempDate1.normalize();
            }
            if ((tempDate2 = this.clone(dateTime)).isUTC()) {
                tempDate2.normalize();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unexpected 'clone not supported' Exception");
        }
        if (tempDate1.isUTC() == tempDate2.isUTC()) {
            return DateTimeBase.compareFields(tempDate1, tempDate2);
        }
        if (tempDate1.isUTC()) {
            tempDate2.setZone((short)14, (short)0);
            tempDate2.normalize();
            int result = DateTimeBase.compareFields(tempDate1, tempDate2);
            if (result == 0) {
                return result;
            }
            tempDate2.setZone((short)14, (short)0);
            tempDate2.setZoneNegative(true);
            tempDate2.normalize();
            tempDate2.setZone((short)14, (short)0);
            tempDate2.setZoneNegative(true);
            tempDate2.normalize();
            result = DateTimeBase.compareFields(tempDate1, tempDate2);
            if (result == 2) {
                return result;
            }
            return -1;
        }
        if (tempDate2.isUTC()) {
            tempDate1.setZone((short)14, (short)0);
            tempDate1.normalize();
            int result = DateTimeBase.compareFields(tempDate1, tempDate2);
            if (result == 2) {
                return result;
            }
            tempDate1.setZone((short)14, (short)0);
            tempDate1.setZoneNegative(true);
            tempDate1.normalize();
            tempDate1.setZone((short)14, (short)0);
            tempDate1.setZoneNegative(true);
            tempDate1.normalize();
            result = DateTimeBase.compareFields(tempDate1, tempDate2);
            if (result == 0) {
                return result;
            }
            return -1;
        }
        return -1;
    }

    private DateTimeBase copyDateTimeInstance(DateTimeBase dateTime) {
        DateTime newDateTime = new DateTime();
        newDateTime._isNegative = dateTime._isNegative;
        newDateTime._century = dateTime._century;
        newDateTime._year = dateTime._year;
        newDateTime._month = dateTime._month;
        newDateTime._day = dateTime._day;
        newDateTime._hour = dateTime._hour;
        newDateTime._minute = dateTime._minute;
        newDateTime._second = dateTime._second;
        newDateTime._millsecond = dateTime._millsecond;
        newDateTime._zoneNegative = dateTime._zoneNegative;
        newDateTime._utc = dateTime._utc;
        newDateTime._zoneHour = dateTime._zoneHour;
        newDateTime._zoneMinute = dateTime._zoneMinute;
        return newDateTime;
    }

    public DateTimeBase clone(DateTimeBase dateTime) throws CloneNotSupportedException {
        DateTimeBase newDateTime = (DateTimeBase)super.clone();
        newDateTime.setValues(dateTime.getValues());
        if (dateTime.hasIsNegative() && dateTime.isNegative()) {
            newDateTime.setNegative();
        }
        if (dateTime.isUTC()) {
            newDateTime.setUTC();
            newDateTime.setZone(dateTime.getZoneHour(), dateTime.getZoneMinute());
            newDateTime.setZoneNegative(dateTime.isZoneNegative());
        }
        return newDateTime;
    }

    private static int compareFields(DateTimeBase date1, DateTimeBase date2) {
        short field2;
        short field1;
        if (date1.hasCentury() != date2.hasCentury()) {
            return -1;
        }
        if (date1.hasCentury() && date2.hasCentury()) {
            field1 = date1.getCentury();
            if (field1 < (field2 = date2.getCentury())) {
                return 0;
            }
            if (field1 > field2) {
                return 2;
            }
        }
        if (date1.hasYear() != date2.hasYear()) {
            return -1;
        }
        if (date1.hasYear() && date2.hasYear()) {
            field1 = date1.getYear();
            if (field1 < (field2 = date2.getYear())) {
                return 0;
            }
            if (field1 > field2) {
                return 2;
            }
        }
        if (date1.hasMonth() != date2.hasMonth()) {
            return -1;
        }
        if (date1.hasMonth() && date2.hasMonth()) {
            field1 = date1.getMonth();
            if (field1 < (field2 = date2.getMonth())) {
                return 0;
            }
            if (field1 > field2) {
                return 2;
            }
        }
        if (date1.hasDay() != date2.hasDay()) {
            return -1;
        }
        if (date1.hasDay() && date2.hasDay()) {
            field1 = date1.getDay();
            if (field1 < (field2 = date2.getDay())) {
                return 0;
            }
            if (field1 > field2) {
                return 2;
            }
        }
        if (date1.hasHour() != date2.hasHour()) {
            return -1;
        }
        if (date1.hasHour() && date2.hasHour()) {
            field1 = date1.getHour();
            if (field1 < (field2 = date2.getHour())) {
                return 0;
            }
            if (field1 > field2) {
                return 2;
            }
        }
        if (date1.hasMinute() != date2.hasMinute()) {
            return -1;
        }
        if (date1.hasMinute() && date2.hasMinute()) {
            field1 = date1.getMinute();
            if (field1 < (field2 = date2.getMinute())) {
                return 0;
            }
            if (field1 > field2) {
                return 2;
            }
        }
        if (date1.hasSeconds() != date2.hasSeconds()) {
            return -1;
        }
        if (date1.hasSeconds() && date2.hasSeconds()) {
            field1 = date1.getSeconds();
            if (field1 < (field2 = date2.getSeconds())) {
                return 0;
            }
            if (field1 > field2) {
                return 2;
            }
        }
        if (date1.hasMilli() != date2.hasMilli()) {
            return -1;
        }
        if (date1.hasMilli() && date2.hasMilli()) {
            field1 = date1.getMilli();
            if (field1 < (field2 = date2.getMilli())) {
                return 0;
            }
            if (field1 > field2) {
                return 2;
            }
        }
        return 1;
    }

    public int hashCode() {
        return this._year ^ this._month ^ this._day ^ this._hour ^ this._minute ^ this._second ^ this._millsecond ^ this._zoneHour ^ this._zoneMinute;
    }

    public boolean equals(Object object) {
        if (object instanceof DateTimeBase) {
            return this.equal((DateTimeBase)object);
        }
        return false;
    }

    protected boolean equal(DateTimeBase dateTime) {
        return 1 == this.compareTo(dateTime);
    }

    public Calendar toCalendar() {
        GregorianCalendar result = new GregorianCalendar();
        result.setTime(this.toDate());
        return result;
    }

    protected static int parseYear(String str, DateTimeBase result, char[] chars, int index, String complaint) throws ParseException {
        int idx = index;
        if (chars[idx] == '-') {
            ++idx;
            result.setNegative();
        }
        if (!(str.length() >= idx + 4 && Character.isDigit(chars[idx]) && Character.isDigit(chars[idx + 1]) && Character.isDigit(chars[idx + 2]) && Character.isDigit(chars[idx + 3]))) {
            throw new ParseException(complaint + str + "\nThe Year must be 4 digits long", idx);
        }
        short value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        short value2 = (short)((chars[idx + 2] - 48) * 10 + (chars[idx + 3] - 48));
        if (value1 == 0 && value2 == 0) {
            throw new ParseException(complaint + str + "\n'0000' is not allowed as a year.", idx);
        }
        result.setCentury(value1);
        result.setYear(value2);
        return idx += 4;
    }

    protected static int parseMonth(String str, DateTimeBase result, char[] chars, int index, String complaint) throws ParseException {
        int idx = index;
        if (chars[idx] != '-') {
            throw new ParseException(complaint + str + "\n '-'  is wrongly placed.", idx);
        }
        if (str.length() < ++idx + 2 || !Character.isDigit(chars[idx]) || !Character.isDigit(chars[idx + 1])) {
            throw new ParseException(complaint + str + "\nThe Month must be 2 digits long", idx);
        }
        short value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        result.setMonth(value1);
        return idx += 2;
    }

    protected static int parseDay(String str, DateTimeBase result, char[] chars, int index, String complaint) throws ParseException {
        int idx = index;
        if (chars[idx] != '-') {
            throw new ParseException(complaint + str + "\n '-'  is wrongly placed.", idx);
        }
        if (str.length() < ++idx + 2 || !Character.isDigit(chars[idx]) || !Character.isDigit(chars[idx + 1])) {
            throw new ParseException(complaint + str + "\nThe Day must be 2 digits long", idx);
        }
        short value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        result.setDay(value1);
        return idx += 2;
    }

    protected static int parseTime(String str, DateTimeBase result, char[] chars, int index, String complaint) throws ParseException {
        int idx = index;
        if (str.length() < idx + 8) {
            throw new ParseException(complaint + str + "\nA Time field must be at least 8 characters long", idx);
        }
        if (!Character.isDigit(chars[idx]) || !Character.isDigit(chars[idx + 1])) {
            throw new ParseException(complaint + str + "\nThe Hour must be 2 digits long", idx);
        }
        short hour = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        boolean isHourOfValue24 = false;
        if (hour == 24) {
            result.setHour((short)0);
            Duration oneDay = new Duration();
            oneDay.setDay((short)1);
            result.addDuration(oneDay);
            isHourOfValue24 = true;
        } else {
            result.setHour(hour);
        }
        if (chars[idx += 2] != ':') {
            throw new ParseException(complaint + str + "\n ':#1'  is wrongly placed.", idx);
        }
        if (!Character.isDigit(chars[++idx]) || !Character.isDigit(chars[idx + 1])) {
            throw new ParseException(complaint + str + "\nThe Minute must be 2 digits long", idx);
        }
        short minutes = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        if (isHourOfValue24 && minutes != 0) {
            throw new ParseException(complaint + str + "\nWhen an hour of 24 is used, minutes must be strictly of value 00.", idx);
        }
        result.setMinute(minutes);
        if (chars[idx += 2] != ':') {
            throw new ParseException(complaint + str + "\n ':#2'  is wrongly placed.", idx);
        }
        if (!Character.isDigit(chars[++idx]) || !Character.isDigit(chars[idx + 1])) {
            throw new ParseException(complaint + str + "\nThe Second must be 2 digits long", idx);
        }
        short seconds = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        if (isHourOfValue24 && seconds != 0) {
            throw new ParseException(complaint + str + "\nWhen an hour of 24 is used, seconds must be strictly of value 00.", idx);
        }
        result.setSecond(seconds);
        if ((idx += 2) < chars.length && chars[idx] == '.') {
            ++idx;
            long decimalValue = 0L;
            long powerOfTen = 1L;
            while (idx < chars.length && Character.isDigit(chars[idx])) {
                decimalValue = decimalValue * 10L + (long)(chars[idx] - 48);
                powerOfTen *= 10L;
                ++idx;
            }
            if (powerOfTen > 1000L) {
                decimalValue /= powerOfTen / 1000L;
                powerOfTen = 1000L;
            } else if (powerOfTen < 1000L) {
                decimalValue *= 1000L / powerOfTen;
                powerOfTen = 1000L;
            }
            result.setMilliSecond((short)decimalValue);
        }
        return idx;
    }

    protected static int parseTimeZone(String str, DateTimeBase result, char[] chars, int index, String complaint) throws ParseException {
        if (index >= chars.length) {
            return index;
        }
        int idx = index;
        if (chars[idx] == 'Z') {
            result.setUTC();
            return ++idx;
        }
        if (chars[idx] == '+' || chars[idx] == '-') {
            if (chars[idx] == '-') {
                result.setZoneNegative(true);
            }
            if (!(++idx + 5 <= chars.length && chars[idx + 2] == ':' && Character.isDigit(chars[idx]) && Character.isDigit(chars[idx + 1]) && Character.isDigit(chars[idx + 3]) && Character.isDigit(chars[idx + 4]))) {
                throw new ParseException(complaint + str + "\nTimeZone must have the format (+/-)hh:mm", idx);
            }
            short value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
            short value2 = (short)((chars[idx + 3] - 48) * 10 + (chars[idx + 4] - 48));
            result.setZone(value1, value2);
            idx += 5;
        }
        return idx;
    }

    protected void setDateFormatTimeZone(DateFormat df) {
        if (!this.isUTC()) {
            return;
        }
        int offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
        offset = this.isZoneNegative() ? -offset : offset;
        SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
        timeZone.setRawOffset(offset);
        timeZone.setID(TimeZone.getAvailableIDs(offset)[0]);
        df.setTimeZone(timeZone);
    }

    protected void setDateFormatTimeZone(Calendar calendar) {
        if (!this.isUTC()) {
            return;
        }
        int offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
        offset = this.isZoneNegative() ? -offset : offset;
        SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
        timeZone.setRawOffset(offset);
        String[] availableIDs = TimeZone.getAvailableIDs(offset);
        if (availableIDs != null && availableIDs.length > 0) {
            timeZone.setID(availableIDs[0]);
        }
        calendar.setTimeZone(timeZone);
    }

    protected void appendDateString(StringBuffer result) {
        if (this.isNegative()) {
            result.append('-');
        }
        if (this.getCentury() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getCentury());
        if (this.getYear() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getYear());
        result.append('-');
        if (this.getMonth() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getMonth());
        result.append('-');
        if (this.getDay() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getDay());
    }

    protected void appendTimeString(StringBuffer result) {
        if (this.getHour() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getHour());
        result.append(':');
        if (this.getMinute() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getMinute());
        result.append(':');
        if (this.getSeconds() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getSeconds());
        if (this.getMilli() != 0) {
            result.append('.');
            if (this.getMilli() < 100) {
                result.append('0');
                if (this.getMilli() < 10) {
                    result.append('0');
                }
            }
            result.append(this.getMilli());
        }
    }

    protected void appendTimeZoneString(StringBuffer result) {
        if (!this.isUTC()) {
            return;
        }
        if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
            result.append('Z');
            return;
        }
        if (this.isZoneNegative()) {
            result.append('-');
        } else {
            result.append('+');
        }
        if (this.getZoneHour() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getZoneHour());
        result.append(':');
        if (this.getZoneMinute() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getZoneMinute());
    }
}

