/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.exceptions.CastorRuntimeException;
import org.castor.xml.BackwardCompatibilityContext;
import org.castor.xml.InternalContext;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.JClassRegistry;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SingleClassGenerator;
import org.exolab.castor.builder.SourceGeneratorMain;
import org.exolab.castor.builder.binding.BindingException;
import org.exolab.castor.builder.binding.BindingLoader;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.binding.XPathHelper;
import org.exolab.castor.builder.binding.xml.PackageType;
import org.exolab.castor.builder.binding.xml.PackageTypeChoice;
import org.exolab.castor.builder.binding.xml.types.BindingType;
import org.exolab.castor.builder.conflict.strategy.ClassNameConflictResolver;
import org.exolab.castor.builder.conflict.strategy.TypeClassNameConflictResolver;
import org.exolab.castor.builder.conflict.strategy.XPATHClassNameConflictResolver;
import org.exolab.castor.builder.factory.FieldInfoFactory;
import org.exolab.castor.builder.factory.SourceFactory;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.printing.JClassPrinterFactoryRegistry;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.util.NestedIOException;
import org.exolab.castor.util.dialog.ConsoleDialog;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContextImpl;
import org.exolab.castor.xml.schema.SimpleContent;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.javasource.JClass;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SourceGenerator
extends BuilderConfiguration {
    private static final Log LOG = LogFactory.getLog(SourceGenerator.class);
    static final String APP_NAME = "Castor";
    static final String APP_DESC = "XML data binder for Java";
    static final String VERSION = "1.4.1";
    static final String APP_URI = "http://www.castor.org";
    private static final String IMPORT_WARNING = "Note: No code will be generated for the following *imported* schema: ";
    private final InternalContext _internalContext;
    private final XMLBindingComponent _bindingComponent;
    private final SingleClassGenerator _singleClassGenerator;
    private final FieldInfoFactory _infoFactory;
    private final ConsoleDialog _dialog;
    private final Vector<Schema> _schemasProcessed = new Vector(7);
    private boolean _suppressNonFatalWarnings = false;
    private boolean _verbose = false;
    private boolean _createDescriptors = true;
    private boolean _createJdoDescriptors = false;
    private boolean _generateImported = false;
    private SourceFactory _sourceFactory = null;
    private boolean _generateMapping = false;
    private String _mappingFilename = "mapping.xml";
    private boolean _createMarshalMethods = true;
    private boolean _testable = false;
    private boolean _sax1 = false;
    private boolean _caseInsensitive = false;
    private boolean _failOnFirstError = false;
    private GroupNaming _groupNaming = null;
    private String _nameConflictStrategy = "warnViaConsoleDialog";
    private JClassRegistry _xmlInfoRegistry;
    private ClassNameConflictResolver _conflictResolver = new XPATHClassNameConflictResolver();
    private String _jclassPrinterType = "standard";
    private JClassPrinterFactoryRegistry _jclassPrinterFactoryRegistry;
    protected SGStateInfo _sInfo;

    public SourceGenerator() {
        this(null);
    }

    public SourceGenerator(FieldInfoFactory infoFactory) {
        this(infoFactory, null);
    }

    public SourceGenerator(FieldInfoFactory infoFactory, ExtendedBinding binding) {
        this._internalContext = new BackwardCompatibilityContext();
        this.setJavaNaming(this._internalContext.getJavaNaming());
        this._dialog = new ConsoleDialog();
        this._infoFactory = infoFactory == null ? (this.useOldFieldNaming() ? new FieldInfoFactory() : new FieldInfoFactory(false)) : infoFactory;
        this._groupNaming = new GroupNaming(this.getJavaNaming());
        this._jclassPrinterFactoryRegistry = new JClassPrinterFactoryRegistry(this);
        this._singleClassGenerator = new SingleClassGenerator(this._dialog, this, this._nameConflictStrategy, this._jclassPrinterType);
        this._bindingComponent = new XMLBindingComponent(this, this._groupNaming);
        this.setBinding(binding);
        this._conflictResolver.setSourceGenerator(this);
        this._xmlInfoRegistry = new JClassRegistry(this._conflictResolver, this.getJavaNaming());
    }

    private String getJClassPrinterType() {
        return this._jclassPrinterType;
    }

    public final void setMappingFilename(String filename) {
        this._mappingFilename = filename;
    }

    public final void setNameConflictStrategy(String nameConflictStrategy) {
        this._nameConflictStrategy = nameConflictStrategy;
        this._singleClassGenerator.setNameConflictStrategy(nameConflictStrategy);
    }

    public static String getVersion() {
        return VERSION;
    }

    public final void setSAX1(boolean sax1) {
        this._sax1 = sax1;
    }

    public final void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public final void setFailOnFirstError(boolean failOnFirstError) {
        this._failOnFirstError = failOnFirstError;
    }

    public final void setSuppressNonFatalWarnings(boolean suppress) {
        this._singleClassGenerator.setPromptForOverwrite(!suppress);
        this._suppressNonFatalWarnings = suppress;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public void setClassNameConflictResolver(String resolverName) {
        if (resolverName.equals("type")) {
            this._conflictResolver = new TypeClassNameConflictResolver();
            this._conflictResolver.setSourceGenerator(this);
        } else if (!resolverName.equals("xpath")) {
            throw new IllegalArgumentException("Invalid resolver type.");
        }
        this._xmlInfoRegistry.setClassNameConflictResolver(this._conflictResolver);
    }

    public final void setDescriptorCreation(boolean createDescriptors) {
        this._createDescriptors = createDescriptors;
        this._singleClassGenerator.setDescriptorCreation(createDescriptors);
    }

    public final void setJdoDescriptorCreation(boolean createJdoDescriptors) {
        this._createJdoDescriptors = createJdoDescriptors;
        this._singleClassGenerator.setJdoDescriptorCreation(createJdoDescriptors);
    }

    public final void setDestDir(String destDir) {
        this._singleClassGenerator.setDestDir(destDir);
    }

    public final void setResourceDestination(String destination) {
        this._singleClassGenerator.setResourceDestinationDirectory(destination);
    }

    public final void setCreateMarshalMethods(boolean createMarshalMethods) {
        this._createMarshalMethods = createMarshalMethods;
    }

    public final void setGenerateImportedSchemas(boolean generate) {
        this._generateImported = generate;
    }

    public final void setGenerateMappingFile(boolean generateMapping) {
        this._generateMapping = generateMapping;
    }

    public final void setTestable(boolean testable) {
        this._testable = testable;
    }

    public final void setBinding(ExtendedBinding binding) {
        if (binding != null) {
            this.processNamespaces(binding.getPackage());
        }
        this._bindingComponent.setBinding(binding);
    }

    public final void setBinding(String fileName) {
        try {
            ExtendedBinding binding = BindingLoader.createBinding(fileName);
            this.setBinding(binding);
        }
        catch (BindingException e) {
            String err = "Unable to load a binding file due to the following:\n" + e.getMessage() + "\nThe Source Generator will continue with no binding file.";
            this._dialog.notify(err);
        }
    }

    public final void setBinding(InputSource source) {
        try {
            ExtendedBinding binding = BindingLoader.createBinding(source);
            this.setBinding(binding);
        }
        catch (BindingException e) {
            String err = "unable to load a binding file due to the following:\n" + e.getMessage() + "\nThe Source Generator will continue with no binding file.";
            this._dialog.notify(err);
        }
    }

    public final void setLineSeparator(String lineSeparator) {
        this._singleClassGenerator.setLineSeparator(lineSeparator);
    }

    @Override
    public final boolean mappingSchemaElement2Java() {
        BindingType type;
        ExtendedBinding binding;
        if (this._bindingComponent != null && (binding = this._bindingComponent.getBinding()) != null && (type = binding.getDefaultBindingType()) != null) {
            return type == BindingType.ELEMENT;
        }
        return super.mappingSchemaElement2Java();
    }

    @Override
    public final boolean mappingSchemaType2Java() {
        BindingType type;
        ExtendedBinding binding;
        if (this._bindingComponent != null && (binding = this._bindingComponent.getBinding()) != null && (type = binding.getDefaultBindingType()) != null) {
            return type == BindingType.TYPE;
        }
        return super.mappingSchemaType2Java();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateSource(String filename, String packageName) throws IOException {
        File schemaFile = filename.startsWith("./") ? new File(filename.substring(2)) : new File(filename);
        FileReader reader = new FileReader(schemaFile);
        try {
            InputSource source = new InputSource(reader);
            source.setSystemId(SourceGenerator.toURIRepresentation(schemaFile.getAbsolutePath()));
            this.generateSource(source, packageName);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public final void generateSource(Reader reader, String packageName) throws IOException {
        InputSource source = new InputSource(reader);
        this.generateSource(source, packageName);
    }

    public void generateSource(InputSource source, String packageName) throws IOException {
        Parser parser = null;
        try {
            parser = this._internalContext.getParser();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (parser == null) {
            this._dialog.notify("fatal error: unable to create SAX parser.");
            return;
        }
        SchemaContextImpl schemaContext = new SchemaContextImpl();
        SchemaUnmarshaller schemaUnmarshaller = null;
        try {
            schemaUnmarshaller = new SchemaUnmarshaller(schemaContext);
        }
        catch (XMLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Sax2ComponentReader handler = new Sax2ComponentReader(schemaUnmarshaller);
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        try {
            parser.parse(source);
        }
        catch (IOException ioe) {
            this._dialog.notify("error reading XML Schema file");
            if (this._failOnFirstError) {
                throw ioe;
            }
            return;
        }
        catch (SAXException sx) {
            Exception except = sx.getException();
            if (except == null) {
                except = sx;
            }
            if (except instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)except;
                this._dialog.notify("SAXParseException: " + spe);
                this._dialog.notify(" - occured at line ");
                this._dialog.notify(Integer.toString(spe.getLineNumber()));
                this._dialog.notify(", column ");
                this._dialog.notify(Integer.toString(spe.getColumnNumber()));
            } else {
                except.printStackTrace();
            }
            if (this._failOnFirstError) {
                String msg = "Source Generator: schema parser threw an Exception";
                throw new CastorRuntimeException(msg, sx);
            }
            return;
        }
        Schema schema = schemaUnmarshaller.getSchema();
        try {
            schema.validate();
        }
        catch (ValidationException vx) {
            throw new NestedIOException(vx);
        }
        this.generateSource(schema, packageName);
    }

    public final void generateSource(Schema schema, String packageName) throws IOException {
        if (schema == null) {
            throw new IllegalArgumentException("The argument 'schema' must not be null.");
        }
        try {
            schema.validate();
        }
        catch (ValidationException ve) {
            String err = "The schema: " + schema.getSchemaLocation() + " is not valid.\n" + ve.getMessage();
            throw new IllegalArgumentException(err);
        }
        if (this._sourceFactory == null) {
            this._sourceFactory = new SourceFactory(this, this._infoFactory, this._groupNaming, this);
            this._sourceFactory.setCreateMarshalMethods(this._createMarshalMethods);
            this._sourceFactory.setTestable(this._testable);
            this._sourceFactory.setSAX1(this._sax1);
            this._sourceFactory.setCaseInsensitive(this._caseInsensitive);
        }
        this._sInfo = new SGStateInfo(schema, this);
        this._sInfo.setPackageName(packageName);
        this._sInfo.setDialog(this._dialog);
        this._sInfo.setVerbose(this._verbose);
        this._sInfo.setSuppressNonFatalWarnings(this._suppressNonFatalWarnings);
        if (packageName != null) {
            super.setLocationPackageMapping(schema.getSchemaLocation(), packageName);
        }
        this._schemasProcessed.clear();
        this.generateAllClassFiles(schema, this._sInfo);
        if (!this._createDescriptors && this._generateMapping) {
            this.generateMappingFile(packageName, this._sInfo);
        }
        if (this.isAutomaticConflictResolution()) {
            this._xmlInfoRegistry.printStatistics(this._bindingComponent);
        }
    }

    private void generateAllClassFiles(Schema schema, SGStateInfo sInfo) throws IOException {
        this.processImportedSchemas(schema, sInfo);
        for (ElementDecl element : schema.getElementDecls()) {
            this._xmlInfoRegistry.prebindGlobalElement(XPathHelper.getSchemaLocation(element));
        }
        for (ModelGroup modelGroup : schema.getModelGroups()) {
            this._xmlInfoRegistry.prebindGlobalElement(XPathHelper.getSchemaLocation(modelGroup));
        }
        for (ElementDecl element : schema.getElementDecls()) {
            this.createClasses(element, sInfo);
        }
        for (ComplexType complexType : schema.getComplexTypes()) {
            this.processComplexType(complexType, sInfo);
        }
        for (SimpleType simpleType : schema.getSimpleTypes()) {
            this.processSimpleType(simpleType, sInfo);
        }
        for (ModelGroup modelGroup : schema.getModelGroups()) {
            this.createClasses(modelGroup, sInfo);
        }
        this._singleClassGenerator.processIfNotAlreadyProcessed(sInfo.keys(), sInfo);
        Enumeration<String> cdrFiles = sInfo.getCDRFilenames();
        while (cdrFiles.hasMoreElements()) {
            String filename = cdrFiles.nextElement();
            Properties props = sInfo.getCDRFile(filename);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(filename));
            props.store(fileOutputStream, null);
            fileOutputStream.close();
        }
    }

    private void processImportedSchemas(Schema schema, SGStateInfo sInfo) throws IOException {
        for (Schema importedSchema : schema.getImportedSchema()) {
            if (!this._generateImported) {
                LOG.warn((Object)(IMPORT_WARNING + importedSchema.getSchemaLocation() + "; if this is on intention, please do not forget to generate code for this schema as well. Alternatively,consider using the 'generateImportedSchemas' flag."));
                continue;
            }
            this._schemasProcessed.add(schema);
            if (this._schemasProcessed.contains(importedSchema)) continue;
            SGStateInfo importedSInfo = new SGStateInfo(importedSchema, this);
            String packageName = sInfo.getPackageName();
            importedSInfo.setPackageName(packageName);
            if (packageName != null) {
                this.setLocationPackageMapping(importedSchema.getSchemaLocation(), packageName);
            }
            this.generateAllClassFiles(importedSchema, importedSInfo);
            sInfo.storeImportedSourcesByName(importedSInfo.getSourcesByName());
            sInfo.storeImportedSourcesByName(importedSInfo.getImportedSourcesByName());
            importedSInfo = null;
        }
    }

    private void generateMappingFile(String packageName, SGStateInfo sInfo) throws IOException {
        String pkg = packageName != null ? packageName : "";
        MappingRoot mapping = sInfo.getMapping(pkg);
        if (mapping == null) {
            return;
        }
        FileWriter writer = new FileWriter(this._mappingFilename);
        try {
            Marshaller marshaller = new Marshaller(writer);
            marshaller.setSuppressNamespaces(true);
            marshaller.marshal(mapping);
        }
        catch (Exception ex) {
            throw new NestedIOException(ex);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private void createClasses(ElementDecl elementDecl, SGStateInfo sInfo) throws IOException {
        if (sInfo.getStatusCode() == 1 || elementDecl == null) {
            return;
        }
        XMLType xmlType = elementDecl.getType();
        if (this.mappingSchemaType2Java() && (elementDecl.isReference() || xmlType != null && xmlType.getName() != null)) {
            return;
        }
        this._bindingComponent.setView(elementDecl);
        ClassInfo cInfo = sInfo.resolve(elementDecl);
        if (cInfo != null && cInfo.getJClass() != null) {
            JClass jClass = cInfo.getJClass();
            if (sInfo.processed(jClass)) {
                return;
            }
            jClass = null;
        }
        if (xmlType == null) {
            if (sInfo.verbose()) {
                String msg = "No type found for element: " + elementDecl.getName();
                sInfo.getDialog().notify(msg);
            }
            return;
        }
        if (xmlType.isComplexType()) {
            JClass[] classes = this._sourceFactory.createSourceCode(this._bindingComponent, sInfo);
            if (!this._singleClassGenerator.process(classes, sInfo)) {
                return;
            }
            if (xmlType.getSchema() == this._bindingComponent.getSchema()) {
                this.processComplexType((ComplexType)xmlType, sInfo);
            }
        } else if (xmlType.isSimpleType()) {
            this.processSimpleType((SimpleType)xmlType, sInfo);
        }
    }

    private void createClasses(Group group, SGStateInfo sInfo) throws IOException {
        if (group == null) {
            return;
        }
        if (group.getParticleCount() == 0) {
            if (group instanceof ModelGroup) {
                ModelGroup mg = (ModelGroup)group;
                if (mg.isReference() && (mg = mg.getReference()).getParticleCount() == 0) {
                    return;
                }
            } else {
                return;
            }
        }
        this._bindingComponent.setView(group);
        JClass[] classes = this._sourceFactory.createSourceCode(this._bindingComponent, sInfo);
        this.processContentModel(group, sInfo);
        this._singleClassGenerator.process(classes, sInfo);
    }

    private void processComplexType(ComplexType complexType, SGStateInfo sInfo) throws IOException {
        if (sInfo.getStatusCode() == 1 || complexType == null) {
            return;
        }
        this._bindingComponent.setView(complexType);
        ClassInfo classInfo = sInfo.resolve(complexType);
        if (classInfo == null) {
            JClass[] classes;
            if (complexType.isTopLevel() && !this._singleClassGenerator.process(classes = this._sourceFactory.createSourceCode(this._bindingComponent, sInfo), sInfo)) {
                return;
            }
            this.processAttributes(complexType, sInfo);
            ContentType temp = complexType.getContentType();
            if (temp.getType() == 4) {
                this.processSimpleType(((SimpleContent)temp).getSimpleType(), sInfo);
            }
            this.processContentModel(complexType, sInfo);
        } else {
            JClass jClass = classInfo.getJClass();
            if (!sInfo.processed(jClass)) {
                this.processAttributes(complexType, sInfo);
                this.processContentModel(complexType, sInfo);
                this._singleClassGenerator.process(jClass, sInfo);
            }
        }
    }

    private void processAttributes(ComplexType complexType, SGStateInfo sInfo) throws IOException {
        if (sInfo.getStatusCode() == 1 || complexType == null) {
            return;
        }
        Enumeration<AttributeDecl> enumeration = complexType.getAttributeDecls();
        while (enumeration.hasMoreElements()) {
            AttributeDecl attribute = enumeration.nextElement();
            this.processSimpleType(attribute.getSimpleType(), sInfo);
        }
    }

    private void processContentModel(ContentModelGroup cmGroup, SGStateInfo sInfo) throws IOException {
        if (sInfo.getStatusCode() == 1 || cmGroup == null) {
            return;
        }
        Enumeration<Particle> enumeration = cmGroup.enumerate();
        while (enumeration.hasMoreElements()) {
            Structure struct = enumeration.nextElement();
            switch (struct.getStructureType()) {
                case 8: {
                    ElementDecl eDecl = (ElementDecl)struct;
                    if (eDecl.isReference()) break;
                    this.createClasses(eDecl, sInfo);
                    break;
                }
                case 10: {
                    this.processContentModel((Group)struct, sInfo);
                    if (cmGroup instanceof ComplexType || cmGroup instanceof ModelGroup) break;
                    this.createClasses((Group)struct, sInfo);
                    break;
                }
            }
        }
    }

    private void processSimpleType(SimpleType simpleType, SGStateInfo sInfo) throws IOException {
        if (sInfo.getStatusCode() == 1 || simpleType == null || simpleType.getSchema() != sInfo.getSchema()) {
            return;
        }
        if (simpleType.hasFacet("enumeration")) {
            ClassInfo classInfo = sInfo.resolve(simpleType);
            if (classInfo == null) {
                JClass jClass = this._sourceFactory.createSourceCode(this._bindingComponent.getBinding(), simpleType, sInfo);
                this._singleClassGenerator.process(jClass, sInfo);
            } else {
                JClass jClass = classInfo.getJClass();
                this._singleClassGenerator.process(jClass, sInfo);
            }
        }
    }

    private void processNamespaces(PackageType[] packages) {
        if (packages.length == 0) {
            return;
        }
        for (PackageType temp : packages) {
            PackageTypeChoice choice = temp.getPackageTypeChoice();
            if (choice.getNamespace() != null) {
                super.setNamespacePackageMapping(choice.getNamespace(), temp.getName());
                continue;
            }
            if (choice.getSchemaLocation() == null) continue;
            Object tempLocation = choice.getSchemaLocation();
            String currentDir = System.getProperty("user.dir");
            currentDir = currentDir.replace('\\', '/');
            if (((String)tempLocation).startsWith("./")) {
                tempLocation = ((String)tempLocation).substring(1);
                tempLocation = currentDir + (String)tempLocation;
            } else if (((String)tempLocation).startsWith("../")) {
                tempLocation = ((String)tempLocation).substring("../".length());
                int lastDir = currentDir.lastIndexOf(47);
                currentDir = currentDir.substring(0, lastDir + 1);
                tempLocation = currentDir + (String)tempLocation;
            }
            super.setLocationPackageMapping((String)tempLocation, temp.getName());
            currentDir = null;
            tempLocation = null;
        }
    }

    public static String toURIRepresentation(String path) {
        Object result = path;
        if (!new File((String)result).isAbsolute()) {
            throw new IllegalArgumentException("The parameter must represent an absolute path.");
        }
        if (File.separatorChar != '/') {
            result = ((String)result).replace(File.separatorChar, '/');
        }
        result = ((String)result).startsWith("/") ? "file://" + (String)result : "file:///" + (String)result;
        return result;
    }

    public static void main(String[] args) {
        LOG.info((Object)"org.exolab.castor.builder.SourceGenerator.main() is deprecated. Please use org.exolab.castor.builder.SourceGeneratorMain#main() instead.");
        SourceGeneratorMain.main(args);
    }

    public JClassRegistry getXMLInfoRegistry() {
        return this._xmlInfoRegistry;
    }

    public final void setJClassPrinterType(String jClassPrinterType) {
        LOG.info((Object)("Setting JClass printing mode " + jClassPrinterType));
        this._jclassPrinterType = jClassPrinterType;
        if (this._singleClassGenerator != null) {
            this._singleClassGenerator.setJClassPrinterType(jClassPrinterType);
        }
    }

    public boolean getGenerateImportedSchemas() {
        return this._generateImported;
    }

    public JClassPrinterFactoryRegistry getJClassPrinterFactoryRegistry() {
        return this._jclassPrinterFactoryRegistry;
    }
}

