/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.xml.JavaNaming;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.binding.XPathHelper;
import org.exolab.castor.builder.binding.xml.Exclude;
import org.exolab.castor.builder.conflict.strategy.ClassNameConflictResolver;
import org.exolab.castor.builder.conflict.strategy.XPATHClassNameConflictResolver;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.javasource.JClass;

public class JClassRegistry {
    private static final Log LOG = LogFactory.getLog(JClassRegistry.class);
    private Set<String> _globalElements = new HashSet<String>();
    private Map<String, JClass> _xpathToJClass = new HashMap<String, JClass>();
    private Map<String, List<String>> _localNames = new HashMap<String, List<String>>();
    private Map<String, String> _typedLocalNames = new HashMap<String, String>();
    private JavaNaming _javaNaming;
    private ClassNameConflictResolver _classNameConflictResolver = new XPATHClassNameConflictResolver();

    public void prebindGlobalElement(String xpath) {
        this._globalElements.add(xpath);
    }

    public JClassRegistry(ClassNameConflictResolver resolver, JavaNaming javaNaming) {
        this._classNameConflictResolver = resolver;
        this._javaNaming = javaNaming;
    }

    public void bind(JClass jClass, XMLBindingComponent component, String mode) {
        ElementDecl element;
        boolean isReference;
        boolean isGlobalElement;
        boolean alreadyProcessed;
        String expectedClassNameDerivedFromXPath;
        String jClassLocalName;
        Group group;
        Annotated annotated = component.getAnnotated();
        Object xPath = XPathHelper.getSchemaLocation((Structure)annotated, true);
        String localXPath = this.getLocalXPath((String)xPath);
        String untypedXPath = xPath;
        String localName = this.getLocalName((String)xPath);
        Object typedLocalName = localName;
        if (annotated instanceof ElementDecl) {
            ElementDecl element2 = (ElementDecl)annotated;
            String typexPath = XPathHelper.getSchemaLocation(element2.getType());
            xPath = (String)xPath + "[" + typexPath + "]";
            typedLocalName = (String)typedLocalName + "[" + typexPath + "]";
        } else if (annotated instanceof Group && (group = (Group)annotated).getOrder() == Order.choice && !this._globalElements.contains("/" + localXPath)) {
            xPath = (String)xPath + "/#choice";
        }
        ExtendedBinding binding = component.getBinding();
        if (binding != null) {
            if (binding.existsExclusion((String)typedLocalName)) {
                Exclude exclusion = binding.getExclusion((String)typedLocalName);
                if (exclusion.getClassName() != null) {
                    LOG.info((Object)("Dealing with exclusion for local element " + (String)xPath + " as per binding file."));
                    jClass.changeLocalName(exclusion.getClassName());
                }
                return;
            }
            if (binding.existsForce(localName)) {
                List<String> localNamesList = this._localNames.get(localName);
                this.memorizeCollision((String)xPath, localName, localNamesList);
                LOG.info((Object)("Changing class name for local element " + (String)xPath + " as per binding file (force)."));
                this.checkAndChange(jClass, annotated, untypedXPath, (String)typedLocalName);
                return;
            }
        }
        if (!(jClassLocalName = jClass.getLocalName()).equals(expectedClassNameDerivedFromXPath = this._javaNaming.toJavaClassName(localName))) {
            if (component.createGroupItem()) {
                xPath = (String)xPath + "/#item";
            }
            this._xpathToJClass.put((String)xPath, jClass);
            return;
        }
        if (mode.equals("field")) {
            ElementDecl element3;
            ModelGroup group2;
            boolean isReference2;
            if (annotated instanceof ModelGroup && (isReference2 = (group2 = (ModelGroup)annotated).isReference())) {
                return;
            }
            if (annotated instanceof ElementDecl && (isReference2 = (element3 = (ElementDecl)annotated).isReference())) {
                ElementDecl referredElement = element3.getReference();
                Enumeration<ElementDecl> possibleSubstitutes = referredElement.getSubstitutionGroupMembers();
                if (possibleSubstitutes.hasMoreElements()) {
                    XMLType referredType = referredElement.getType();
                    String xPathType = XPathHelper.getSchemaLocation(referredType);
                    JClass typeJClass = this._xpathToJClass.get(xPathType);
                    if (typeJClass != null) {
                        jClass.changeLocalName(typeJClass.getLocalName());
                    } else {
                        XMLBindingComponent temp = component;
                        temp.setView(referredType);
                        jClass.changeLocalName(temp.getJavaClassName());
                        component.setView(annotated);
                    }
                }
                return;
            }
        }
        if (alreadyProcessed = this._xpathToJClass.containsKey(xPath)) {
            JClass jClassAlreadyProcessed = this._xpathToJClass.get(xPath);
            jClass.changeLocalName(jClassAlreadyProcessed.getLocalName());
            return;
        }
        this._xpathToJClass.put((String)xPath, jClass);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Binding JClass[" + jClass.getName() + "] for XML schema structure " + (String)xPath));
        }
        if (isGlobalElement = this._globalElements.contains(untypedXPath)) {
            return;
        }
        if (mode.equals("field") && annotated instanceof ElementDecl && (isReference = (element = (ElementDecl)annotated).isReference())) {
            ElementDecl referredElement = element.getReference();
            Enumeration<ElementDecl> possibleSubstitutes = referredElement.getSubstitutionGroupMembers();
            if (possibleSubstitutes.hasMoreElements()) {
                String typeXPath = XPathHelper.getSchemaLocation(referredElement);
                JClass referredJClass = this._xpathToJClass.get(typeXPath + "_class");
                jClass.changeLocalName(referredJClass.getSuperClass().getLocalName());
            }
            return;
        }
        boolean conflictExistsWithGlobalElement = this._globalElements.contains("/" + localXPath);
        if (conflictExistsWithGlobalElement) {
            LOG.info((Object)("Resolving conflict for local element " + (String)xPath + " against global element."));
            this.checkAndChange(jClass, annotated, untypedXPath, (String)typedLocalName);
            List<String> localNamesList = this._localNames.get(localName);
            this.memorizeCollision((String)xPath, localName, localNamesList);
            return;
        }
        List<String> localNamesList = this._localNames.get(localName);
        this.memorizeCollision((String)xPath, localName, localNamesList);
        if (localNamesList == null) {
            String typedJClassName = this._typedLocalNames.get(typedLocalName);
            if (typedJClassName == null) {
                this._typedLocalNames.put((String)typedLocalName, jClass.getName());
            }
        } else {
            LOG.info((Object)("Resolving conflict for local element " + (String)xPath + " against another local element of the same name."));
            this.checkAndChange(jClass, annotated, untypedXPath, (String)typedLocalName);
        }
    }

    private void memorizeCollision(String xPath, String localName, List<String> localNamesList) {
        if (localNamesList == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(xPath);
            this._localNames.put(localName, arrayList);
        } else if (!localNamesList.contains(xPath)) {
            localNamesList.add(xPath);
        }
    }

    private void checkAndChange(JClass jClass, Annotated annotated, String untypedXPath, String typedLocalName) {
        String typedJClassName = this._typedLocalNames.get(typedLocalName);
        if (typedJClassName != null) {
            String localClassName = typedJClassName.substring(typedJClassName.lastIndexOf(".") + 1);
            jClass.changeLocalName(localClassName);
        } else {
            this.changeClassInfoAsResultOfConflict(jClass, untypedXPath, typedLocalName, annotated);
            this._typedLocalNames.put(typedLocalName, jClass.getName());
        }
    }

    private String getLocalName(String xPath) {
        String localName = xPath.substring(xPath.lastIndexOf("/") + 1);
        if (localName.startsWith("complexType:") || localName.startsWith("simpleType:") || localName.startsWith("enumType:") || localName.startsWith("group:")) {
            localName = localName.substring(localName.indexOf(":") + 1);
        }
        return localName;
    }

    private String getLocalXPath(String xPath) {
        return xPath.substring(xPath.lastIndexOf("/") + 1);
    }

    private void changeClassInfoAsResultOfConflict(JClass jClass, String xpath, String typedXPath, Annotated annotated) {
        this._classNameConflictResolver.changeClassInfoAsResultOfConflict(jClass, xpath, typedXPath, annotated);
    }

    public void setClassNameConflictResolver(ClassNameConflictResolver conflictResolver) {
        this._classNameConflictResolver = conflictResolver;
    }

    public void printStatistics(XMLBindingComponent binding) {
        Iterator<String> keyIterator = this._localNames.keySet().iterator();
        LOG.info((Object)"*** Summary ***");
        if (binding.getBinding() != null && binding.getBinding().getForces() != null && !binding.getBinding().getForces().isEmpty()) {
            Iterator<String> forceIterator = binding.getBinding().getForces().iterator();
            LOG.info((Object)"The following 'forces' have been enabled:");
            while (forceIterator.hasNext()) {
                String forceValue = forceIterator.next();
                LOG.info((Object)forceValue);
            }
        }
        if (keyIterator.hasNext()) {
            LOG.info((Object)"Local name conflicts encountered for the following element definitions");
            while (keyIterator.hasNext()) {
                String localName = keyIterator.next();
                List<String> collisions = this._localNames.get(localName);
                if (collisions.size() <= 1 || this.ofTheSameType(collisions)) continue;
                LOG.info((Object)(localName + ", with the following (element) definitions being involved:"));
                for (String xPath : collisions) {
                    LOG.info((Object)xPath);
                }
            }
        }
        if ((keyIterator = this._localNames.keySet().iterator()).hasNext()) {
            StringBuilder xmlFragment = new StringBuilder(32);
            xmlFragment.append("<forces>\n");
            while (keyIterator.hasNext()) {
                String localName = keyIterator.next();
                List<String> collisions = this._localNames.get(localName);
                if (collisions.size() <= 1 || this.ofTheSameType(collisions)) continue;
                xmlFragment.append("   <force>");
                xmlFragment.append(localName);
                xmlFragment.append("</force>\n");
            }
            xmlFragment.append("</forces>");
            LOG.info((Object)xmlFragment.toString());
        }
    }

    private boolean ofTheSameType(List<String> collisions) {
        boolean allSame = true;
        Iterator<String> iterator = collisions.iterator();
        String typeString = null;
        while (iterator.hasNext()) {
            String xPath = iterator.next();
            String newTypeString = xPath.substring(xPath.indexOf("[") + 1, xPath.indexOf("]"));
            if (typeString != null) {
                if (typeString.equals(newTypeString)) continue;
                allSame = false;
                break;
            }
            typeString = newTypeString;
        }
        return allSame;
    }
}

